/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hy extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Գրինվիչի ժամանակ",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Ապիայի ստանդարտ ժամանակ",
               "",
               "Ապիայի ամառային ժամանակ",
               "",
               "Ապիայի ժամանակ",
               "",
            };
        final String[] Cook = new String[] {
               "Կուկի կղզիների ստանդարտ ժամանակ",
               "",
               "Կուկի կղզիների կիսաամառային ժամանակ",
               "",
               "Կուկի կղզիների ժամանակ",
               "",
            };
        final String[] Cuba = new String[] {
               "Կուբայի ստանդարտ ժամանակ",
               "CST",
               "Կուբայի ամառային ժամանակ",
               "CDT",
               "Կուբայի ժամանակ",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Ֆիջիի ստանդարտ ժամանակ",
               "",
               "Ֆիջիի ամառային ժամանակ",
               "",
               "Ֆիջիի ժամանակ",
               "",
            };
        final String[] Gulf = new String[] {
               "Պարսից ծոցի ստանդարտ ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Հովդի ստանդարտ ժամանակ",
               "",
               "Հովդի ամառային ժամանակ",
               "",
               "Հովդի ժամանակ",
               "",
            };
        final String[] Iran = new String[] {
               "Իրանի ստանդարտ ժամանակ",
               "",
               "Իրանի ամառային ժամանակ",
               "",
               "Իրանի ժամանակ",
               "",
            };
        final String[] Niue = new String[] {
               "Նիուեյի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Օմսկի ստանդարտ ժամանակ",
               "",
               "Օմսկի ամառային ժամանակ",
               "",
               "Օմսկի ժամանակ",
               "",
            };
        final String[] Peru = new String[] {
               "Պերուի ստանդարտ ժամանակ",
               "",
               "Պերուի ամառային ժամանակ",
               "",
               "Պերուի ժամանակ",
               "",
            };
        final String[] Truk = new String[] {
               "Տրուկի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Ուեյք կղզու ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Չիլիի ստանդարտ ժամանակ",
               "",
               "Չիլիի ամառային ժամանակ",
               "",
               "Չիլիի ժամանակ",
               "",
            };
        final String[] China = new String[] {
               "Չինաստանի ստանդարտ ժամանակ",
               "CST",
               "Չինաստանի ամառային ժամանակ",
               "CDT",
               "Չինաստանի ժամանակ",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Կոկոսյան կղզիների ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Դեյվիսի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Հնդկաստանի ստանդարտ ժամանակ",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Ճապոնիայի ստանդարտ ժամանակ",
               "JST",
               "Ճապոնիայի ամառային ժամանակ",
               "JDT",
               "Ճապոնիայի ժամանակ",
               "JT",
            };
        final String[] Korea = new String[] {
               "Կորեայի ստանդարտ ժամանակ",
               "KST",
               "Կորեայի ամառային ժամանակ",
               "KST",
               "Կորեայի ժամանակ",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Նաուրուի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Նեպալի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Պալաույի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Սամոայի ստանդարտ ժամանակ",
               "SST",
               "Սամոայի ամառային ժամանակ",
               "SST",
               "Սամոայի ժամանակ",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Սյովայի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Տոնգայի ստանդարտ ժամանակ",
               "",
               "Տոնգայի ամառային ժամանակ",
               "",
               "Տոնգայի ժամանակ",
               "",
            };
        final String[] Yukon = new String[] {
               "Յուկոնի ժամանակ",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Ալյասկայի ստանդարտ ժամանակ",
               "AKST",
               "Ալյասկայի ամառային ժամանակ",
               "AKDT",
               "Ալյասկայի ժամանակ",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Ամազոնյան ստանդարտ ժամանակ",
               "",
               "Ամազոնյան ամառային ժամանակ",
               "",
               "Ամազոնյան ժամանակ",
               "",
            };
        final String[] Azores = new String[] {
               "Ազորյան կղզիների ստանդարտ ժամանակ",
               "",
               "Ազորյան կղզիների ամառային ժամանակ",
               "",
               "Ազորյան կղզիների ժամանակ",
               "",
            };
        final String[] Bhutan = new String[] {
               "Բութանի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Բրունեյի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Զատկի կղզու ստանդարտ ժամանակ",
               "",
               "Զատկի կղզու ամառային ժամանակ",
               "",
               "Զատկի կղզու ժամանակ",
               "",
            };
        final String[] Guyana = new String[] {
               "Գայանայի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Հավայան-ալեության ստանդարտ ժամանակ",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Իսրայելի ստանդարտ ժամանակ",
               "IST",
               "Իսրայելի ամառային ժամանակ",
               "IDT",
               "Իսրայելի ժամանակ",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Կոսրաեյի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Մոուսոնի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Մոսկվայի ստանդարտ ժամանակ",
               "MSK",
               "Մոսկվայի ամառային ժամանակ",
               "MSK",
               "Մոսկվայի ժամանակ",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Պոնապե կղզու ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Թաիթիի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Թայպեյի ստանդարտ ժամանակ",
               "CST",
               "Թայպեյի ամառային ժամանակ",
               "CDT",
               "Թայպեյի ժամանակ",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Տուվալույի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Վոստոկի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Ուոլիս և Ֆուտունայի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Սաուդյան Արաբիայի ստանդարտ ժամանակ",
               "",
               "Սաուդյան Արաբիայի ամառային ժամանակ",
               "",
               "Սաուդյան Արաբիայի ժամանակ",
               "",
            };
        final String[] Armenia = new String[] {
               "Հայաստանի ստանդարտ ժամանակ",
               "",
               "Հայաստանի ամառային ժամանակ",
               "",
               "Հայաստանի ժամանակ",
               "",
            };
        final String[] Bolivia = new String[] {
               "Բոլիվիայի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Չաթեմ կղզու ստանդարտ ժամանակ",
               "",
               "Չաթեմ կղզու ամառային ժամանակ",
               "",
               "Չաթեմ կղզու ժամանակ",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Համաշխարհային կոորդինացված ժամանակ",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Էկվադորի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Գամբյե կղզիների ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Վրաստանի ստանդարտ ժամանակ",
               "",
               "Վրաստանի ամառային ժամանակ",
               "",
               "Վրաստանի ժամանակ",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Իրկուտսկի ստանդարտ ժամանակ",
               "",
               "Իրկուտսկի ամառային ժամանակ",
               "",
               "Իրկուտսկի ժամանակ",
               "",
            };
        final String[] Magadan = new String[] {
               "Մագադանի ստանդարտ ժամանակ",
               "",
               "Մագադանի ամառային ժամանակ",
               "",
               "Մագադանի ժամանակ",
               "",
            };
        final String[] Myanmar = new String[] {
               "Մյանմայի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Նորֆոլկ կղզու ստանդարտ ժամանակ",
               "",
               "Նորֆոլկ կղզու ամառային ժամանակ",
               "",
               "Նորֆոլկ կղզու ժամանակ",
               "",
            };
        final String[] Noronha = new String[] {
               "Ֆերնանդու դի Նորոնյայի ստանդարտ ժամանակ",
               "",
               "Ֆերնանդու դի Նորոնյայի ամառային ժամանակ",
               "",
               "Ֆերնանդու դի Նորոնյայի ժամանակ",
               "",
            };
        final String[] Reunion = new String[] {
               "Ռեյունիոնի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ռոտերայի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Սողոմոնի կղզիների ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Տոկելաույի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Ուրուգվայի ստանդարտ ժամանակ",
               "",
               "Ուրուգվայի ամառային ժամանակ",
               "",
               "Ուրուգվայի ժամանակ",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Վանուատույի ստանդարտ ժամանակ",
               "",
               "Վանուատույի ամառային ժամանակ",
               "",
               "Վանուատույի ժամանակ",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Յակուտսկի ստանդարտ ժամանակ",
               "",
               "Յակուտսկի ամառային ժամանակ",
               "",
               "Յակուտսկի ժամանակ",
               "",
            };
        final String[] Atlantic = new String[] {
               "Ատլանտյան ստանդարտ ժամանակ",
               "AST",
               "Ատլանտյան ամառային ժամանակ",
               "AST",
               "Ատլանտյան ժամանակ",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Բրազիլիայի ստանդարտ ժամանակ",
               "",
               "Բրազիլիայի ամառային ժամանակ",
               "",
               "Բրազիլիայի ժամանակ",
               "",
            };
        final String[] Chamorro = new String[] {
               "Չամոռոյի ժամանակ",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Կոլումբիայի ստանդարտ ժամանակ",
               "",
               "Կոլումբիայի ամառային ժամանակ",
               "",
               "Կոլումբիայի ժամանակ",
               "",
            };
        final String[] Falkland = new String[] {
               "Ֆոլքլենդյան կղզիների ստանդարտ ժամանակ",
               "",
               "Ֆոլքլենդյան կղզիների ամառային ժամանակ",
               "",
               "Ֆոլքլենդյան կղզիների ժամանակ",
               "",
            };
        final String[] Malaysia = new String[] {
               "Մալայզիայի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Մալդիվների ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ուլան Բատորի ստանդարտ ժամանակ",
               "",
               "Ուլան Բատորի ամառային ժամանակ",
               "",
               "Ուլան Բատորի ժամանակ",
               "",
            };
        final String[] Pakistan = new String[] {
               "Պակիստանի ստանդարտ ժամանակ",
               "PKT",
               "Պակիստանի ամառային ժամանակ",
               "PKST",
               "Պակիստանի ժամանակ",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Պարագվայի ստանդարտ ժամանակ",
               "",
               "Պարագվայի ամառային ժամանակ",
               "",
               "Պարագվայի ժամանակ",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Պիտկեռնի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Սուրինամի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Արգենտինայի ստնադարտ ժամանակ",
               "",
               "Արգենտինայի ամառային ժամանակ",
               "",
               "Արգենտինայի ժամանակ",
               "",
            };
        final String[] Christmas = new String[] {
               "Սուրբ Ծննդյան կղզու ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Գալապագոսյան կղզիների ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Հոնկոնգի ստանդարտ ժամանակ",
               "HKT",
               "Հոնկոնգի ամառային ժամանակ",
               "HKST",
               "Հոնկոնգի ժամանակ",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Հնդկաչինական ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Ղրղզստանի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Լորդ Հաուի ստանդարտ ժամանակ",
               "",
               "Լորդ Հաուի ամառային ժամանակ",
               "",
               "Լորդ Հաուի ժամանակ",
               "",
            };
        final String[] Marquesas = new String[] {
               "Մարկիզյան կղզիների ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Մավրիկիոսի ստանդարտ ժամանակ",
               "",
               "Մավրիկիոսի ամառային ժամանակ",
               "",
               "Մավրիկիոսի ժամանակ",
               "",
            };
        final String[] Singapore = new String[] {
               "Սինգապուրի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Վենեսուելայի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Ադրբեջանի ստանդարտ ժամանակ",
               "",
               "Ադրբեջանի ամառային ժամանակ",
               "",
               "Ադրբեջանի ժամանակ",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Բանգլադեշի ստանդարտ ժամանակ",
               "",
               "Բանգլադեշի ամառային ժամանակ",
               "",
               "Բանգլադեշի ժամանակ",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Կաբո Վերդեի ստանդարտ ժամանակ",
               "",
               "Կաբո Վերդեի ամառային ժամանակ",
               "",
               "Կաբո Վերդեի ժամանակ",
               "",
            };
        final String[] East_Timor = new String[] {
               "Արևելյան Թիմորի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Ղազախստանի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Սեյշելյան կղզիների ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Տաջիկստանի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ուզբեկստանի ստանդարտ ժամանակ",
               "",
               "Ուզբեկստանի ամառային ժամանակ",
               "",
               "Ուզբեկստանի ժամանակ",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Աֆղանստանի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Կրասնոյարսկի ստանդարտ ժամանակ",
               "",
               "Կրասնոյարսկի ամառային ժամանակ",
               "",
               "Կրասնոյարսկի ժամանակ",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Նոր Զելանդիայի ստանդարտ ժամանակ",
               "NZST",
               "Նոր Զելանդիայի ամառային ժամանակ",
               "NZDT",
               "Նոր Զելանդիայի ժամանակ",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Ֆիլիպինների ստանդարտ ժամանակ",
               "PST",
               "Ֆիլիպինների ամառային ժամանակ",
               "PDT",
               "Ֆիլիպինների ժամանակ",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Վլադիվոստոկի ստանդարտ ժամանակ",
               "",
               "Վլադիվոստոկի ամառային ժամանակ",
               "",
               "Վլադիվոստոկի ժամանակ",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Հնդկական օվկիանոսի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Լայն կղզիների ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Նյուֆաունդլենդի ստանդարտ ժամանակ",
               "NST",
               "Նյուֆաունդլենդի ամառային ժամանակ",
               "NDT",
               "Նյուֆաունդլենդի ժամանակ",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Թուրքմենստանի ստանդարտ ժամանակ",
               "",
               "Թուրքմենստանի ամառային ժամանակ",
               "",
               "Թուրքմենստանի ժամանակ",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ֆրանսիական Գվիանայի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Նոր Կալեդոնիայի ստանդարտ ժամանակ",
               "",
               "Նոր Կալեդոնիայի ամառային ժամանակ",
               "",
               "Նոր Կալեդոնիայի ժամանակ",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Հարավային Ջորջիայի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Եկատերինբուրգի ստանդարտ ժամանակ",
               "",
               "Եկատերինբուրգի ամառային ժամանակ",
               "",
               "Եկատերինբուրգի ժամանակ",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Կենտրոնական Աֆրիկայի ժամանակ",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Արևելյան Աֆրիկայի ժամանակ",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Արևմտյան Աֆրիկայի ժամանակ",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Դյումոն դ’Յուրվիլի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Կենտրոնական Եվրոպայի ստանդարտ ժամանակ",
               "CET",
               "Կենտրոնական Եվրոպայի ամառային ժամանակ",
               "CEST",
               "Կենտրոնական Եվրոպայի ժամանակ",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Արևելյան Եվրոպայի ստանդարտ ժամանակ",
               "EET",
               "Արևելյան Եվրոպայի ամառային ժամանակ",
               "EEST",
               "Արևելյան Եվրոպայի ժամանակ",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Արևմտյան Եվրոպայի ստանդարտ ժամանակ",
               "WET",
               "Արևմտյան Եվրոպայի ամառային ժամանակ",
               "WEST",
               "Արևմտյան Եվրոպայի ժամանակ",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Մեքսիկայի խաղաղօվկիանոսյան ստանդարտ ժամանակ",
               "MST",
               "Մեքսիկայի խաղաղօվկիանոսյան ամառային ժամանակ",
               "MDT",
               "Մեքսիկայի խաղաղօվկիանոսյան ժամանակ",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Հարավային Աֆրիկայի ժամանակ",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Կենտրոնական Ամերիկայի ստանդարտ ժամանակ",
               "CST",
               "Կենտրոնական Ամերիկայի ամառային ժամանակ",
               "CDT",
               "Կենտրոնական Ամերիկայի ժամանակ",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Արևելյան Ամերիկայի ստանդարտ ժամանակ",
               "EST",
               "Արևելյան Ամերիկայի ամառային ժամանակ",
               "EST",
               "Արևելյան Ամերիկայի ժամանակ",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Խաղաղօվկիանոսյան ստանդարտ ժամանակ",
               "PST",
               "Խաղաղօվկիանոսյան ամառային ժամանակ",
               "PDT",
               "Խաղաղօվկիանոսյան ժամանակ",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Ֆրանսիական հարավային և անտարկտիդյան ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ջիլբերթի կղզիների ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Հավայան-ալեության ստանդարտ ժամանակ",
               "HST",
               "Հավայան-ալեության ամառային ժամանակ",
               "HDT",
               "Հավայան-ալեության ժամանակ",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ֆինիքս կղզիների ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Սեն Պիեռ և Միքելոնի ստանդարտ ժամանակ",
               "",
               "Սեն Պիեռ և Միքելոնի ամառային ժամանակ",
               "",
               "Սեն Պիեռ և Միքելոնի ժամանակ",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Լեռնային ստանդարտ ժամանակ (ԱՄՆ)",
               "MST",
               "Լեռնային ամառային ժամանակ (ԱՄՆ)",
               "MST",
               "Լեռնային ժամանակ (ԱՄՆ)",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Մարշալյան կղզիների ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Պապուա Նոր Գվինեայի ժամանակ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Կենտրոնական Ավստրալիայի ստանդարտ ժամանակ",
               "ACST",
               "Կենտրոնական Ավստրալիայի ամառային ժամանակ",
               "ACDT",
               "Կենտրոնական Ավստրալիայի ժամանակ",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Արևելյան Ավստրալիայի ստանդարտ ժամանակ",
               "AEST",
               "Արևելյան Ավստրալիայի ամառային ժամանակ",
               "AEDT",
               "Արևելյան Ավստրալիայի ժամանակ",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Արևմտյան Ավստրալիայի ստանդարտ ժամանակ",
               "AWST",
               "Արևմտյան Ավստրալիայի ամառային ժամանակ",
               "AWDT",
               "Արևմտյան Ավստրալիայի ժամանակ",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Կենտրոնական Ինդոնեզիայի ժամանակ",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Արևելյան Ինդոնեզիայի ժամանակ",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Արևմտյան Ինդոնեզիայի ժամանակ",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Կենտրոնական Ավստրալիայի արևմտյան ստանդարտ ժամանակ",
               "",
               "Կենտրոնական Ավստրալիայի արևմտյան ամառային ժամանակ",
               "",
               "Կենտրոնական Ավստրալիայի արևմտյան ժամանակ",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Գրինվիչի ժամանակ",
                    "GMT",
                    "Բրիտանական ամառային ժամանակ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Համաշխարհային կոորդինացված ժամանակ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Գրինվիչի ժամանակ",
                    "GMT",
                    "Իռլանդական ստանդարտ ժամանակ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Համաշխարհային կոորդինացված ժամանակ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Համաշխարհային կոորդինացված ժամանակ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Գրինվիչի ժամանակ",
                    "GMT",
                    "Բրիտանական ամառային ժամանակ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Համաշխարհային կոորդինացված ժամանակ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Համաշխարհային կոորդինացված ժամանակ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Համաշխարհային կոորդինացված ժամանակ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Գրինվիչի ժամանակ",
                    "GMT",
                    "Իռլանդական ստանդարտ ժամանակ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Գրինվիչի ժամանակ",
                    "GMT",
                    "Բրիտանական ամառային ժամանակ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Գրինվիչի ժամանակ",
                    "GMT",
                    "Բրիտանական ամառային ժամանակ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Գրինվիչի ժամանակ",
                    "GMT",
                    "Բրիտանական ամառային ժամանակ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Գրինվիչի ժամանակ",
                    "GMT",
                    "Բրիտանական ամառային ժամանակ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Գրինվիչի ժամանակ",
                    "GMT",
                    "Բրիտանական ամառային ժամանակ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Ադեն" },
            { "timezone.excity.Asia/Baku", "Բաքու" },
            { "timezone.excity.Asia/Dili", "Դիլի" },
            { "timezone.excity.Asia/Gaza", "Գազա" },
            { "timezone.excity.Asia/Hovd", "Հովդ" },
            { "timezone.excity.Asia/Omsk", "Օմսկ" },
            { "timezone.excity.Asia/Oral", "Ուրալսկ" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Ամման" },
            { "timezone.excity.Asia/Aqtau", "Ակտաու" },
            { "timezone.excity.Asia/Chita", "Չիտա" },
            { "timezone.excity.Asia/Dhaka", "Դաքքա" },
            { "timezone.excity.Asia/Dubai", "Դուբայ" },
            { "timezone.excity.Asia/Kabul", "Քաբուլ" },
            { "timezone.excity.Asia/Macau", "Մակաո" },
            { "timezone.excity.Asia/Qatar", "Կատար" },
            { "timezone.excity.Asia/Seoul", "Սեուլ" },
            { "timezone.excity.Asia/Tokyo", "Տոկիո" },
            { "timezone.excity.Asia/Tomsk", "Տոմսկ" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Ջուբա" },
            { "timezone.excity.Africa/Lome", "Լոմե" },
            { "timezone.excity.Asia/Almaty", "Ալմաթի" },
            { "timezone.excity.Asia/Anadyr", "Անադիր" },
            { "timezone.excity.Asia/Aqtobe", "Ակտոբե" },
            { "timezone.excity.Asia/Atyrau", "Ատիրաու" },
            { "timezone.excity.Asia/Beirut", "Բեյրութ" },
            { "timezone.excity.Asia/Brunei", "Բրունեյ" },
            { "timezone.excity.Asia/Hebron", "Հեբրոն" },
            { "timezone.excity.Asia/Kuwait", "Քուվեյթ" },
            { "timezone.excity.Asia/Manila", "Մանիլա" },
            { "timezone.excity.Asia/Muscat", "Մասկատ" },
            { "timezone.excity.Asia/Riyadh", "Էր Ռիադ" },
            { "timezone.excity.Asia/Saigon", "Հոշիմին" },
            { "timezone.excity.Asia/Taipei", "Թայպեյ" },
            { "timezone.excity.Asia/Tehran", "Թեհրան" },
            { "timezone.excity.Asia/Urumqi", "Ուրումչի" },
            { "timezone.excity.Etc/Unknown", "Անհայտ քաղաք" },
            { "timezone.excity.Europe/Kiev", "Կիև" },
            { "timezone.excity.Europe/Oslo", "Օսլո" },
            { "timezone.excity.Europe/Riga", "Ռիգա" },
            { "timezone.excity.Europe/Rome", "Հռոմ" },
            { "timezone.excity.Indian/Mahe", "Մաէ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Աքրա" },
            { "timezone.excity.Africa/Cairo", "Կահիրե" },
            { "timezone.excity.Africa/Ceuta", "Սեուտա" },
            { "timezone.excity.Africa/Dakar", "Դաքար" },
            { "timezone.excity.Africa/Lagos", "Լագոս" },
            { "timezone.excity.Africa/Tunis", "Թունիս" },
            { "timezone.excity.America/Adak", "Ադակ կղզի" },
            { "timezone.excity.America/Lima", "Լիմա" },
            { "timezone.excity.America/Nome", "Նոմ" },
            { "timezone.excity.Asia/Baghdad", "Բաղդադ" },
            { "timezone.excity.Asia/Bahrain", "Բահրեյն" },
            { "timezone.excity.Asia/Bangkok", "Բանգկոկ" },
            { "timezone.excity.Asia/Barnaul", "Բառնաուլ" },
            { "timezone.excity.Asia/Bishkek", "Բիշքեկ" },
            { "timezone.excity.Asia/Colombo", "Կոլոմբո" },
            { "timezone.excity.Asia/Irkutsk", "Իրկուտսկ" },
            { "timezone.excity.Asia/Jakarta", "Ջակարտա" },
            { "timezone.excity.Asia/Karachi", "Կարաչի" },
            { "timezone.excity.Asia/Kuching", "Կուչինգ" },
            { "timezone.excity.Asia/Magadan", "Մագադան" },
            { "timezone.excity.Asia/Nicosia", "Նիկոսիա" },
            { "timezone.excity.Asia/Rangoon", "Ռանգուն" },
            { "timezone.excity.Asia/Tbilisi", "Թբիլիսի" },
            { "timezone.excity.Asia/Thimphu", "Տհիմպհու" },
            { "timezone.excity.Asia/Yakutsk", "Յակուտսկ" },
            { "timezone.excity.Asia/Yerevan", "Երևան" },
            { "timezone.excity.Europe/Kirov", "Կիրով" },
            { "timezone.excity.Europe/Malta", "Մալթա" },
            { "timezone.excity.Europe/Minsk", "Մինսկ" },
            { "timezone.excity.Europe/Paris", "Փարիզ" },
            { "timezone.excity.Europe/Sofia", "Սոֆիա" },
            { "timezone.excity.Europe/Vaduz", "Վադուց" },
            { "timezone.excity.Indian/Cocos", "Կոկոսյան կղզիներ" },
            { "timezone.excity.Pacific/Apia", "Ապիա" },
            { "timezone.excity.Pacific/Fiji", "Ֆիջի" },
            { "timezone.excity.Pacific/Guam", "Գուամ" },
            { "timezone.excity.Pacific/Niue", "Նիուե" },
            { "timezone.excity.Pacific/Truk", "Չուուկ" },
            { "timezone.excity.Pacific/Wake", "Ուեյք կղզի" },
            { "timezone.excity.Africa/Asmera", "Ասմերա" },
            { "timezone.excity.Africa/Bamako", "Բամակո" },
            { "timezone.excity.Africa/Bangui", "Բանգի" },
            { "timezone.excity.Africa/Banjul", "Բանժուլ" },
            { "timezone.excity.Africa/Bissau", "Բիսաու" },
            { "timezone.excity.Africa/Douala", "Դուալա" },
            { "timezone.excity.Africa/Harare", "Հարարե" },
            { "timezone.excity.Africa/Kigali", "Կիգալի" },
            { "timezone.excity.Africa/Luanda", "Լուանդա" },
            { "timezone.excity.Africa/Lusaka", "Լուսակա" },
            { "timezone.excity.Africa/Malabo", "Մալաբո" },
            { "timezone.excity.Africa/Maputo", "Մապուտու" },
            { "timezone.excity.Africa/Maseru", "Մասերու" },
            { "timezone.excity.Africa/Niamey", "Նիամեյ" },
            { "timezone.excity.America/Aruba", "Արուբա" },
            { "timezone.excity.America/Bahia", "Բաիյա" },
            { "timezone.excity.America/Belem", "Բելեմ" },
            { "timezone.excity.America/Boise", "Բոյսե" },
            { "timezone.excity.America/Jujuy", "Ժուժույ" },
            { "timezone.excity.America/Sitka", "Սիտկա" },
            { "timezone.excity.America/Thule", "Տուլե" },
            { "timezone.excity.Asia/Ashgabat", "Աշխաբադ" },
            { "timezone.excity.Asia/Calcutta", "Կալկուտա" },
            { "timezone.excity.Asia/Damascus", "Դամասկոս" },
            { "timezone.excity.Asia/Dushanbe", "Դուշանբե" },
            { "timezone.excity.Asia/Jayapura", "Ջայպուրա" },
            { "timezone.excity.Asia/Katmandu", "Կատմանդու" },
            { "timezone.excity.Asia/Khandyga", "Խանդիգա" },
            { "timezone.excity.Asia/Makassar", "Մակասար" },
            { "timezone.excity.Asia/Qostanay", "Կոստանայ" },
            { "timezone.excity.Asia/Sakhalin", "Սախալին" },
            { "timezone.excity.Asia/Shanghai", "Շանհայ" },
            { "timezone.excity.Asia/Tashkent", "Տաշքենդ" },
            { "timezone.excity.Asia/Ust-Nera", "Ուստ-Ներա" },
            { "timezone.excity.Europe/Athens", "Աթենք" },
            { "timezone.excity.Europe/Berlin", "Բեռլին" },
            { "timezone.excity.Europe/Dublin", "Դուբլին" },
            { "timezone.excity.Europe/Jersey", "Ջերսի" },
            { "timezone.excity.Europe/Lisbon", "Լիսաբոն" },
            { "timezone.excity.Europe/London", "Լոնդոն" },
            { "timezone.excity.Europe/Madrid", "Մադրիդ" },
            { "timezone.excity.Europe/Monaco", "Մոնակո" },
            { "timezone.excity.Europe/Moscow", "Մոսկվա" },
            { "timezone.excity.Europe/Prague", "Պրահա" },
            { "timezone.excity.Europe/Samara", "Սամարա" },
            { "timezone.excity.Europe/Skopje", "Սկոպյե" },
            { "timezone.excity.Europe/Tirane", "Տիրանա" },
            { "timezone.excity.Europe/Vienna", "Վիեննա" },
            { "timezone.excity.Europe/Warsaw", "Վարշավա" },
            { "timezone.excity.Europe/Zagreb", "Զագրեբ" },
            { "timezone.excity.Europe/Zurich", "Ցյուրիխ" },
            { "timezone.excity.Indian/Chagos", "Չագոս" },
            { "timezone.excity.Indian/Comoro", "Կոմորյան կղզիներ" },
            { "timezone.excity.Pacific/Efate", "Էֆատե" },
            { "timezone.excity.Pacific/Nauru", "Նաուրու" },
            { "timezone.excity.Pacific/Palau", "Պալաու" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Աբիջան" },
            { "timezone.excity.Africa/Algiers", "Ալժիր" },
            { "timezone.excity.Africa/Conakry", "Կոնակրի" },
            { "timezone.excity.Africa/Kampala", "Կամպալա" },
            { "timezone.excity.Africa/Mbabane", "Մբաբանե" },
            { "timezone.excity.Africa/Nairobi", "Նայրոբի" },
            { "timezone.excity.Africa/Tripoli", "Տրիպոլի" },
            { "timezone.excity.America/Belize", "Բելիզ" },
            { "timezone.excity.America/Bogota", "Բոգոտա" },
            { "timezone.excity.America/Cancun", "Կանկուն" },
            { "timezone.excity.America/Cayman", "Կայման կղզիներ" },
            { "timezone.excity.America/Cuiaba", "Կույաբա" },
            { "timezone.excity.America/Dawson", "Դոուսոն" },
            { "timezone.excity.America/Denver", "Դենվեր" },
            { "timezone.excity.America/Guyana", "Գայանա" },
            { "timezone.excity.America/Havana", "Հավանա" },
            { "timezone.excity.America/Inuvik", "Ինուվիկ" },
            { "timezone.excity.America/Juneau", "Ջունո" },
            { "timezone.excity.America/La_Paz", "Լա Պաս" },
            { "timezone.excity.America/Maceio", "Մասեյո" },
            { "timezone.excity.America/Manaus", "Մանաուս" },
            { "timezone.excity.America/Merida", "Մերիդա" },
            { "timezone.excity.America/Nassau", "Նասաու" },
            { "timezone.excity.America/Panama", "Պանամա" },
            { "timezone.excity.America/Recife", "Ռեսիֆի" },
            { "timezone.excity.America/Regina", "Ռեջայնա" },
            { "timezone.excity.Asia/Famagusta", "Ֆամագուստա" },
            { "timezone.excity.Asia/Hong_Kong", "Հոնկոնգ" },
            { "timezone.excity.Asia/Jerusalem", "Երուսաղեմ" },
            { "timezone.excity.Asia/Kamchatka", "Կամչատկա" },
            { "timezone.excity.Asia/Pontianak", "Պոնտիանակ" },
            { "timezone.excity.Asia/Pyongyang", "Փխենյան" },
            { "timezone.excity.Asia/Qyzylorda", "Կիզիլորդա" },
            { "timezone.excity.Asia/Samarkand", "Սամարղանդ" },
            { "timezone.excity.Asia/Singapore", "Սինգապուր" },
            { "timezone.excity.Asia/Vientiane", "Վյենտյան" },
            { "timezone.excity.Europe/Andorra", "Անդորրա" },
            { "timezone.excity.Europe/Saratov", "Սարատով" },
            { "timezone.excity.Europe/Tallinn", "Տալլին" },
            { "timezone.excity.Europe/Vatican", "Վատիկան" },
            { "timezone.excity.Europe/Vilnius", "Վիլնյուս" },
            { "timezone.excity.Indian/Mayotte", "Մայոթ" },
            { "timezone.excity.Indian/Reunion", "Ռեյունիոն" },
            { "timezone.excity.Pacific/Easter", "Զատկի կղզի" },
            { "timezone.excity.Pacific/Kosrae", "Կոսրաե" },
            { "timezone.excity.Pacific/Majuro", "Մաջուրո" },
            { "timezone.excity.Pacific/Midway", "Միդուեյ կղզի" },
            { "timezone.excity.Pacific/Noumea", "Նումեա" },
            { "timezone.excity.Pacific/Ponape", "Պոնպեի" },
            { "timezone.excity.Pacific/Saipan", "Սայպան" },
            { "timezone.excity.Pacific/Tahiti", "Թաիթի" },
            { "timezone.excity.Pacific/Tarawa", "Տարավա" },
            { "timezone.excity.Pacific/Wallis", "Ուոլիս" },
            { "timezone.excity.Africa/Blantyre", "Բլանթայր" },
            { "timezone.excity.Africa/Djibouti", "Ջիբութի" },
            { "timezone.excity.Africa/El_Aaiun", "Էլ Այուն" },
            { "timezone.excity.Africa/Freetown", "Ֆրիթաուն" },
            { "timezone.excity.Africa/Gaborone", "Գաբորոնե" },
            { "timezone.excity.Africa/Khartoum", "Խարթում" },
            { "timezone.excity.Africa/Kinshasa", "Կինշասա" },
            { "timezone.excity.Africa/Monrovia", "Մոնրովիա" },
            { "timezone.excity.Africa/Ndjamena", "Նջամենա" },
            { "timezone.excity.Africa/Sao_Tome", "Սան Տոմե" },
            { "timezone.excity.Africa/Windhoek", "Վինդհուկ" },
            { "timezone.excity.America/Antigua", "Անտիգուա" },
            { "timezone.excity.America/Caracas", "Կարակաս" },
            { "timezone.excity.America/Cayenne", "Կայեն" },
            { "timezone.excity.America/Chicago", "Չիկագո" },
            { "timezone.excity.America/Cordoba", "Կորդովա" },
            { "timezone.excity.America/Creston", "Քրեսթոն" },
            { "timezone.excity.America/Curacao", "Կյուրասաո" },
            { "timezone.excity.America/Detroit", "Դետրոյթ" },
            { "timezone.excity.America/Godthab", "Նուուկ" },
            { "timezone.excity.America/Grenada", "Գրենադա" },
            { "timezone.excity.America/Halifax", "Հալիֆաքս" },
            { "timezone.excity.America/Iqaluit", "Իկալուիտ" },
            { "timezone.excity.America/Jamaica", "Ճամայկա" },
            { "timezone.excity.America/Managua", "Մանագուա" },
            { "timezone.excity.America/Marigot", "Մարիգո" },
            { "timezone.excity.America/Mendoza", "Մենդոսա" },
            { "timezone.excity.America/Moncton", "Մոնկտոն" },
            { "timezone.excity.America/Noronha", "Նորոնյա" },
            { "timezone.excity.America/Ojinaga", "Օխինագա" },
            { "timezone.excity.America/Phoenix", "Ֆինիքս" },
            { "timezone.excity.America/Tijuana", "Տիխուանա" },
            { "timezone.excity.America/Toronto", "Տորոնտո" },
            { "timezone.excity.America/Tortola", "Թորթոլա" },
            { "timezone.excity.America/Yakutat", "Յակուտատ" },
            { "timezone.excity.Asia/Phnom_Penh", "Պնոմպեն" },
            { "timezone.excity.Atlantic/Azores", "Ազորյան կղզիներ" },
            { "timezone.excity.Atlantic/Canary", "Կանարյան կղզիներ" },
            { "timezone.excity.Atlantic/Faeroe", "Ֆարերյան կղզիներ" },
            { "timezone.excity.Australia/Eucla", "Յուկլա" },
            { "timezone.excity.Australia/Perth", "Պերթ" },
            { "timezone.excity.Europe/Belgrade", "Բելգրադ" },
            { "timezone.excity.Europe/Brussels", "Բրյուսել" },
            { "timezone.excity.Europe/Budapest", "Բուդապեշտ" },
            { "timezone.excity.Europe/Busingen", "Բյուզինգեն" },
            { "timezone.excity.Europe/Chisinau", "Քիշնև" },
            { "timezone.excity.Europe/Guernsey", "Գերնսի" },
            { "timezone.excity.Europe/Helsinki", "Հելսինկի" },
            { "timezone.excity.Europe/Istanbul", "Ստամբուլ" },
            { "timezone.excity.Europe/Sarajevo", "Սարաևո" },
            { "timezone.excity.Indian/Maldives", "Մալդիվներ" },
            { "timezone.excity.Pacific/Chatham", "Չաթեմ կղզի" },
            { "timezone.excity.Pacific/Fakaofo", "Ֆակաոֆո" },
            { "timezone.excity.Pacific/Gambier", "Գամբյե կղզիներ" },
            { "timezone.excity.Pacific/Norfolk", "Նորֆոլկ" },
            { "timezone.excity.Africa/Bujumbura", "Բուժումբուրա" },
            { "timezone.excity.Africa/Mogadishu", "Մոգադիշո" },
            { "timezone.excity.America/Anguilla", "Անգուիլա" },
            { "timezone.excity.America/Asuncion", "Ասունսյոն" },
            { "timezone.excity.America/Barbados", "Բարբադոս" },
            { "timezone.excity.America/Dominica", "Դոմինիկա" },
            { "timezone.excity.America/Edmonton", "Էդմոնտոն" },
            { "timezone.excity.America/Eirunepe", "Էյրունեպե" },
            { "timezone.excity.America/Mazatlan", "Մազաթլան" },
            { "timezone.excity.America/Miquelon", "Միքելոն" },
            { "timezone.excity.America/New_York", "Նյու Յորք" },
            { "timezone.excity.America/Resolute", "Ռեզոլյուտ" },
            { "timezone.excity.America/Santarem", "Սանտարեմ" },
            { "timezone.excity.America/Santiago", "Սանտյագո" },
            { "timezone.excity.America/St_Johns", "Սենթ Ջոնս" },
            { "timezone.excity.America/St_Kitts", "Սենթ Քիտս" },
            { "timezone.excity.America/St_Lucia", "Սենթ Լյուսիա" },
            { "timezone.excity.America/Winnipeg", "Վինիպեգ" },
            { "timezone.excity.Antarctica/Casey", "Քեյսի" },
            { "timezone.excity.Antarctica/Davis", "Դեյվիս" },
            { "timezone.excity.Antarctica/Syowa", "Սյովա" },
            { "timezone.excity.Antarctica/Troll", "Տրոլլ" },
            { "timezone.excity.Asia/Krasnoyarsk", "Կրասնոյարսկ" },
            { "timezone.excity.Asia/Novosibirsk", "Նովոսիբիրսկ" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ուլան Բատոր" },
            { "timezone.excity.Asia/Vladivostok", "Վլադիվոստոկ" },
            { "timezone.excity.Atlantic/Bermuda", "Բերմուդներ" },
            { "timezone.excity.Atlantic/Madeira", "Մադեյրա" },
            { "timezone.excity.Atlantic/Stanley", "Սթենլի" },
            { "timezone.excity.Australia/Darwin", "Դարվին" },
            { "timezone.excity.Australia/Hobart", "Հոբարտ" },
            { "timezone.excity.Australia/Sydney", "Սիդնեյ" },
            { "timezone.excity.Europe/Amsterdam", "Ամստերդամ" },
            { "timezone.excity.Europe/Astrakhan", "Աստրախան" },
            { "timezone.excity.Europe/Bucharest", "Բուխարեստ" },
            { "timezone.excity.Europe/Gibraltar", "Ջիբրալթար" },
            { "timezone.excity.Europe/Ljubljana", "Լյուբլյանա" },
            { "timezone.excity.Europe/Mariehamn", "Մարիեհամն" },
            { "timezone.excity.Europe/Podgorica", "Պոդգորիցա" },
            { "timezone.excity.Europe/Stockholm", "Ստոկհոլմ" },
            { "timezone.excity.Europe/Ulyanovsk", "Ուլյանովսկ" },
            { "timezone.excity.Europe/Volgograd", "Վոլգոգրադ" },
            { "timezone.excity.Indian/Christmas", "Սուրբ Ծննդյան կղզի" },
            { "timezone.excity.Indian/Kerguelen", "Կերգելեն" },
            { "timezone.excity.Indian/Mauritius", "Մավրիկիոս" },
            { "timezone.excity.Pacific/Auckland", "Օքլենդ" },
            { "timezone.excity.Pacific/Funafuti", "Ֆունաֆուտի" },
            { "timezone.excity.Pacific/Honolulu", "Հոնոլուլու" },
            { "timezone.excity.Pacific/Pitcairn", "Պիտկեռն" },
            { "timezone.excity.Africa/Casablanca", "Կասաբլանկա" },
            { "timezone.excity.Africa/Libreville", "Լիբրևիլ" },
            { "timezone.excity.Africa/Lubumbashi", "Լուբումբաշի" },
            { "timezone.excity.Africa/Nouakchott", "Նուակշոտ" },
            { "timezone.excity.Africa/Porto-Novo", "Պորտո Նովո" },
            { "timezone.excity.America/Anchorage", "Անքորիջ" },
            { "timezone.excity.America/Araguaina", "Արագուաինա" },
            { "timezone.excity.America/Boa_Vista", "Բոա Վիստա" },
            { "timezone.excity.America/Catamarca", "Կատամարկա" },
            { "timezone.excity.America/Chihuahua", "Չիուաուա" },
            { "timezone.excity.America/Coyhaique", "Կոյայկե" },
            { "timezone.excity.America/Fortaleza", "Ֆորտալեզա" },
            { "timezone.excity.America/Glace_Bay", "Գլեյս Բեյ" },
            { "timezone.excity.America/Goose_Bay", "Գուս Բեյ" },
            { "timezone.excity.America/Guatemala", "Գվատեմալա" },
            { "timezone.excity.America/Guayaquil", "Գուայակիլ" },
            { "timezone.excity.America/Matamoros", "Մատամորոս" },
            { "timezone.excity.America/Menominee", "Մենոմինի" },
            { "timezone.excity.America/Monterrey", "Մոնտեռեյ" },
            { "timezone.excity.America/Sao_Paulo", "Սան Պաուլու" },
            { "timezone.excity.America/St_Thomas", "Սենթ Թոմաս" },
            { "timezone.excity.America/Vancouver", "Վանկուվեր" },
            { "timezone.excity.Antarctica/Mawson", "Մոուսոն" },
            { "timezone.excity.Antarctica/Palmer", "Պալմեր" },
            { "timezone.excity.Antarctica/Vostok", "Վոստոկ" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Կուալա Լումպուր" },
            { "timezone.excity.Asia/Novokuznetsk", "Նովոկուզնեցկ" },
            { "timezone.excity.Europe/Bratislava", "Բրատիսլավա" },
            { "timezone.excity.Europe/Copenhagen", "Կոպենհագեն" },
            { "timezone.excity.Europe/Luxembourg", "Լյուքսեմբուրգ" },
            { "timezone.excity.Europe/San_Marino", "Սան Մարինո" },
            { "timezone.excity.Europe/Simferopol", "Սիմֆերոպոլ" },
            { "timezone.excity.Pacific/Enderbury", "Կանտոն" },
            { "timezone.excity.Pacific/Galapagos", "Գալապագոսյան կղզիներ" },
            { "timezone.excity.Pacific/Kwajalein", "Քվաջալեյն" },
            { "timezone.excity.Pacific/Marquesas", "Մարկիզյան կղզիներ" },
            { "timezone.excity.Pacific/Pago_Pago", "Պագո Պագո" },
            { "timezone.excity.Pacific/Rarotonga", "Ռարոտոնգա" },
            { "timezone.excity.Pacific/Tongatapu", "Տոնգատապու" },
            { "timezone.excity.Africa/Addis_Ababa", "Ադիս Աբեբա" },
            { "timezone.excity.Africa/Brazzaville", "Բրազավիլ" },
            { "timezone.excity.Africa/Ouagadougou", "Ուագադուգու" },
            { "timezone.excity.America/Costa_Rica", "Կոստա Ռիկա" },
            { "timezone.excity.America/Grand_Turk", "Գրանդ Տյորք" },
            { "timezone.excity.America/Guadeloupe", "Գվադելուպա" },
            { "timezone.excity.America/Hermosillo", "Էրմոսիլյո" },
            { "timezone.excity.America/Kralendijk", "Կրալենդեյկ" },
            { "timezone.excity.America/Louisville", "Լուիսվիլ" },
            { "timezone.excity.America/Martinique", "Մարտինիկա" },
            { "timezone.excity.America/Metlakatla", "Մետլակատլա" },
            { "timezone.excity.America/Montevideo", "Մոնտեվիդեո" },
            { "timezone.excity.America/Montserrat", "Մոնսեռատ" },
            { "timezone.excity.America/Paramaribo", "Պարամարիբո" },
            { "timezone.excity.America/Rio_Branco", "Ռիու Բրանկու" },
            { "timezone.excity.America/St_Vincent", "Սենթ Վինսենթ" },
            { "timezone.excity.America/Whitehorse", "Ուայթհորս" },
            { "timezone.excity.Antarctica/McMurdo", "Մակ-Մերդո" },
            { "timezone.excity.Antarctica/Rothera", "Ռոտերա" },
            { "timezone.excity.Asia/Srednekolymsk", "Սրեդնեկոլիմսկ" },
            { "timezone.excity.Asia/Yekaterinburg", "Եկատերինբուրգ" },
            { "timezone.excity.Atlantic/Reykjavik", "Ռեյկյավիկ" },
            { "timezone.excity.Atlantic/St_Helena", "Սուրբ Հեղինեի կղզի" },
            { "timezone.excity.Australia/Adelaide", "Ադելաիդա" },
            { "timezone.excity.Australia/Brisbane", "Բրիսբեն" },
            { "timezone.excity.Australia/Lindeman", "Լինդեման" },
            { "timezone.excity.Europe/Isle_of_Man", "Մեն կղզի" },
            { "timezone.excity.Europe/Kaliningrad", "Կալինինգրադ" },
            { "timezone.excity.Pacific/Kiritimati", "Կիրիտիմատի" },
            { "timezone.excity.Africa/Johannesburg", "Յոհանեսբուրգ" },
            { "timezone.excity.America/El_Salvador", "Սալվադոր" },
            { "timezone.excity.America/Fort_Nelson", "Ֆորտ Նելսոն" },
            { "timezone.excity.America/Los_Angeles", "Լոս Անջելես" },
            { "timezone.excity.America/Mexico_City", "Մեխիկո" },
            { "timezone.excity.America/Porto_Velho", "Պորտու Վելյու" },
            { "timezone.excity.America/Puerto_Rico", "Պուերտո Ռիկո" },
            { "timezone.excity.America/Tegucigalpa", "Տեգուսիգալպա" },
            { "timezone.excity.Arctic/Longyearbyen", "Լոնգյիր" },
            { "timezone.excity.Atlantic/Cape_Verde", "Կաբո Վերդե" },
            { "timezone.excity.Australia/Lord_Howe", "Լորդ Հաու կղզի" },
            { "timezone.excity.Australia/Melbourne", "Մելբուրն" },
            { "timezone.excity.Indian/Antananarivo", "Անտանանարիվու" },
            { "timezone.excity.Pacific/Guadalcanal", "Գուադալկանալ" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Դար-Էս-Սալամ" },
            { "timezone.excity.America/Blanc-Sablon", "Բլանկ-Սաբլոն" },
            { "timezone.excity.America/Buenos_Aires", "Բուենոս Այրես" },
            { "timezone.excity.America/Campo_Grande", "Կամպու Գրանդի" },
            { "timezone.excity.America/Danmarkshavn", "Դենմարքսհավն" },
            { "timezone.excity.America/Dawson_Creek", "Դոուսոն Քրիք" },
            { "timezone.excity.America/Indiana/Knox", "Նոքս, Ինդիանա" },
            { "timezone.excity.America/Indianapolis", "Ինդիանապոլիս" },
            { "timezone.excity.America/Punta_Arenas", "Պունտա Արենաս" },
            { "timezone.excity.America/Rankin_Inlet", "Ռանկին Ինլեթ" },
            { "timezone.excity.America/Scoresbysund", "Սկորսբիսուն" },
            { "timezone.excity.Antarctica/Macquarie", "Մակկուորի կղզի" },
            { "timezone.excity.Pacific/Bougainville", "Բուգենվիլ" },
            { "timezone.excity.Pacific/Port_Moresby", "Պորտ Մորսբի" },
            { "timezone.excity.America/Cambridge_Bay", "Քեմբրիջ Բեյ" },
            { "timezone.excity.America/Ciudad_Juarez", "Սյուդադ Խուարես" },
            { "timezone.excity.America/Coral_Harbour", "Ատիկոկան" },
            { "timezone.excity.America/Indiana/Vevay", "Վիվեյ, Ինդիանա" },
            { "timezone.excity.America/Lower_Princes", "Լոուեր Պրինսես Քվորթեր" },
            { "timezone.excity.America/Port_of_Spain", "Պորտ-օֆ-Սփեյն" },
            { "timezone.excity.America/Santo_Domingo", "Սանտո Դոմինգո" },
            { "timezone.excity.America/St_Barthelemy", "Սեն Բարտելմի" },
            { "timezone.excity.America/Swift_Current", "Սվիֆթ Քարենթ" },
            { "timezone.excity.Australia/Broken_Hill", "Բրոքեն Հիլ" },
            { "timezone.excity.America/Bahia_Banderas", "Բաիյա Բանդերաս" },
            { "timezone.excity.America/Port-au-Prince", "Պորտ-օ-Պրենս" },
            { "timezone.excity.Atlantic/South_Georgia", "Հարավային Ջորջիա" },
            { "timezone.excity.America/Argentina/Salta", "Սալտա" },
            { "timezone.excity.America/Indiana/Marengo", "Մարենգո, Ինդիանա" },
            { "timezone.excity.America/Indiana/Winamac", "Վինամակ, Ինդիանա" },
            { "timezone.excity.America/Argentina/Tucuman", "Տուկուման" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ուշուայա" },
            { "timezone.excity.America/Indiana/Tell_City", "Թել Սիթի, Ինդիանա" },
            { "timezone.excity.America/Indiana/Vincennes", "Վինսենս, Ինդիանա" },
            { "timezone.excity.Antarctica/DumontDUrville", "Դյումոն դ’Յուրվիլ" },
            { "timezone.excity.America/Argentina/La_Rioja", "Լա Ռիոխա" },
            { "timezone.excity.America/Argentina/San_Juan", "Սան Խուան" },
            { "timezone.excity.America/Argentina/San_Luis", "Սան Լուիս" },
            { "timezone.excity.America/Indiana/Petersburg", "Պետերսբուրգ, Ինդիանա" },
            { "timezone.excity.America/Kentucky/Monticello", "Մոնտիսելո, Կենտուկի" },
            { "timezone.excity.America/North_Dakota/Beulah", "Բոյլա, Հյուսիսային Դակոտա" },
            { "timezone.excity.America/North_Dakota/Center", "Հյուսիսային Դակոտա - Կենտրոն" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Ռիո Գալյեգոս" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Նյու Սալեմ, Հյուսիսային Դակոտա" },
        };
        return data;
    }
}
