/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_km extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ម៉ោងនៅគ្រីនវិច",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "ម៉ោង​ស្តង់ដា​នៅ​អាប្យា",
               "",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​អាប្យា",
               "",
               "ម៉ោង​នៅ​អាប្យា",
               "",
            };
        final String[] Cook = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ប្រជុំកោះ​ខូក",
               "",
               "ម៉ោង​នៅប្រជុំ​កោះ​ខូកនាពាក់កណ្ដាល​រដូវ​​​ក្ដៅ",
               "",
               "ម៉ោង​នៅប្រជុំ​កោះ​ខូក",
               "",
            };
        final String[] Cuba = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​គុយបា",
               "CST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​គុយបា",
               "CDT",
               "ម៉ោង​នៅ​គុយបា",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ហ្វីជី",
               "",
               "ម៉ោង​នៅ​​ហ្វីជីនា​​រដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​ហ្វីជី",
               "",
            };
        final String[] Gulf = new String[] {
               "ម៉ោង​ស្តង់ដា​នៅ​កាល់",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅហូវ",
               "",
               "ម៉ោងនៅ​ហូវនា​រដូវ​ក្ដៅ​",
               "",
               "ម៉ោង​នៅ​ហូវ",
               "",
            };
        final String[] Iran = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អ៊ីរ៉ង់",
               "",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​អ៊ីរ៉ង់",
               "",
               "ម៉ោង​នៅ​អ៊ីរ៉ង់",
               "",
            };
        final String[] Niue = new String[] {
               "ម៉ោងនៅ​នីវ៉េ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អូម",
               "",
               "ម៉ោង​នៅ​អូមនា​រដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​អូម",
               "",
            };
        final String[] Peru = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ប៉េរូ",
               "",
               "ម៉ោង​​នៅ​ប៉េរូនារដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​ប៉េរូ",
               "",
            };
        final String[] Truk = new String[] {
               "ម៉ោង​នៅ​ចូអុក",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ម៉ោង​នៅ​កោះវេក",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "ម៉ោងស្តង់ដារនៅស៊ីលី",
               "",
               "ម៉ោងនៅស៊ីលីនារដូវក្តៅ",
               "",
               "ម៉ោងនៅស៊ីលី",
               "",
            };
        final String[] China = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ចិន",
               "CST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​ចិន",
               "CDT",
               "ម៉ោង​នៅ​ចិន",
               "CT",
            };
        final String[] Cocos = new String[] {
               "ម៉ោង​នៅ​ប្រជុំកោះ​កូកូស",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ម៉ោង​នៅ​ដាវីស",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ម៉ោង​ស្តង់ដារនៅ​ឥណ្ឌា",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ជប៉ុន",
               "JST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅជប៉ុន",
               "JDT",
               "ម៉ោង​នៅ​ជប៉ុន",
               "JT",
            };
        final String[] Korea = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​កូរ៉េ",
               "KST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​កូរ៉េ",
               "KST",
               "ម៉ោង​នៅ​កូរ៉េ",
               "KST",
            };
        final String[] Nauru = new String[] {
               "ម៉ោង​នៅ​ណូរូ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "ម៉ោងនៅនេប៉ាល់",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "ម៉ោង​នៅ​ផាឡៅ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "ម៉ោង​ស្តង់ដារនៅ​សាម័រ",
               "SST",
               "ម៉ោង​នៅ​សាម័រនារដូវក្តៅ",
               "SST",
               "ម៉ោង​នៅ​សាម័រ",
               "SST",
            };
        final String[] Syowa = new String[] {
               "ម៉ោង​នៅ​ស៊ីអូវ៉ា",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ម៉ោង​ស្តង់ដារ​​នៅ​តុងហ្គា",
               "",
               "ម៉ោង​​នៅ​តុងហ្គានារដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​តុងហ្គា",
               "",
            };
        final String[] Yukon = new String[] {
               "ម៉ោងនៅយូខន់",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អាឡាស្កា",
               "AKST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​​អាឡាស្កា",
               "AKDT",
               "ម៉ោង​នៅ​អាឡាស្កា",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ម៉ោងស្តង់ដារ​នៅ​អាម៉ាហ្សូន",
               "",
               "ម៉ោង​នៅ​អាម៉ាហ្សូននារដូវក្តៅ",
               "",
               "ម៉ោង​នៅ​អាម៉ាហ្សូន",
               "",
            };
        final String[] Azores = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អេហ្សស",
               "",
               "ម៉ោង​​នៅ​អេហ្សសនារដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​អេហ្សស",
               "",
            };
        final String[] Bhutan = new String[] {
               "ម៉ោងនៅប៊ូតង់",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ម៉ោងនៅព្រុយណេដារូសាឡឹម",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ម៉ោងស្តង់ដារនៅកោះអ៊ីស្ទ័រ",
               "",
               "ម៉ោងនៅកោះអ៊ីស្ទ័រនារដូវក្តៅ",
               "",
               "ម៉ោងនៅកោះអ៊ីស្ទ័រ",
               "",
            };
        final String[] Guyana = new String[] {
               "ម៉ោង​នៅ​ហ្គីយ៉ាន",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "ម៉ោង​ស្តង់ដារ​​នៅ​ហាវៃ-អាល់ដ្យូសិន",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អ៊ីស្រាអែល",
               "IST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​អ៊ីស្រាអែល",
               "IDT",
               "ម៉ោង​នៅ​អ៊ីស្រាអែល",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "ម៉ោង​នៅ​កូស្រៃ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "ម៉ោង​នៅ​ម៉ៅ​សាន់",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​មូស្គូ",
               "MSK",
               "ម៉ោង​នៅ​មូស្គូ​នារដូវ​ក្ដៅ",
               "MSK",
               "ម៉ោង​នៅ​មូស្គូ",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ម៉ោង​នៅ​ប៉ូណាប់",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "ម៉ោង​នៅ​តាហិទី",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​តៃប៉ិ",
               "CST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​តៃប៉ិ",
               "CDT",
               "ម៉ោង​នៅ​តៃប៉ិ",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "ម៉ោង​នៅ​ទុយវ៉ាលូ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ម៉ោង​នៅ​វ័រស្តុក",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ម៉ោង​នៅ​វ៉ាលីស និងហ្វ៊ុទូណា",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អារ៉ាប់",
               "",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​អារ៉ាប់",
               "",
               "ម៉ោង​នៅ​អារ៉ាប់",
               "",
            };
        final String[] Armenia = new String[] {
               "ម៉ោង​ស្ដង់ដារ​នៅ​អាមេនី",
               "",
               "ម៉ោង​នៅ​អាមេនីនារដូវ​ក្ដៅ​",
               "",
               "ម៉ោង​នៅ​អាមេនី",
               "",
            };
        final String[] Bolivia = new String[] {
               "ម៉ោង​នៅ​បូលីវី",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ចាថាំ",
               "",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​ចាថាំ",
               "",
               "ម៉ោង​នៅ​ចាថាំ",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "ម៉ោងសកលដែលមានការសម្រួល",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ម៉ោង​នៅ​អេក្វាទ័រ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ម៉ោង​នៅ​កាំបៀ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ហ្សកហ្ស៊ី",
               "",
               "ម៉ោង​នៅ​ហ្សកហ្ស៊ីនា​​រដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​ហ្សកហ្ស៊ី",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ម៉ោងស្តង់ដារនៅអៀរគុតស្កិ៍",
               "",
               "ម៉ោងនៅអៀរគុតស្កិ៍នារដូវក្តៅ",
               "",
               "ម៉ោងនៅអៀរគុតស្កិ៍",
               "",
            };
        final String[] Magadan = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ម៉ាហ្កាដាន",
               "",
               "ម៉ោង​នៅ​ម៉ាហ្កាដាន​នារដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​ម៉ាហ្កាដាន",
               "",
            };
        final String[] Myanmar = new String[] {
               "ម៉ោង​នៅ​មីយ៉ាន់ម៉ា",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "ម៉ោង​ស្ដង់ដារ​នៅ​ណ័រហ្វក់",
               "",
               "ម៉ោងនៅ​ណ័រហ្វក់នា​រដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​កោះ​ណ័រហ្វក់",
               "",
            };
        final String[] Noronha = new String[] {
               "ម៉ោង​ស្តង់ដារនៅហ្វ៊ែណាន់ដូ​ដឺណូរ៉ូញ៉ា",
               "",
               "ម៉ោង​នៅហ្វ៊ែណាន់ដូ​ដឺណូរ៉ូញ៉ានារដូវក្តៅ",
               "",
               "ម៉ោង​នៅហ្វ៊ែណាន់ដូ​ដឺណូរ៉ូញ៉ា",
               "",
            };
        final String[] Reunion = new String[] {
               "ម៉ោងនៅរេអ៊ុយ៉ុង",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "ម៉ោង​នៅ​រ៉ូធឺរ៉ា",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "ម៉ោង​នៅ​កោះ​សូឡូម៉ុន",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ម៉ោង​នៅ​តូខេឡៅ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អ៊ុយរូហ្គាយ",
               "",
               "ម៉ោង​នៅ​អ៊ុយរូហ្គាយនា​​រដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​អ៊ុយរូហ្គាយ",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ម៉ោង​​ស្តង់ដារ​នៅ​វ៉ានូទូ",
               "",
               "ម៉ោង​នៅ​វ៉ានូទូនារដូវ​ក្ដៅ​",
               "",
               "ម៉ោង​នៅ​វ៉ានូទូ",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​យ៉ាគុតស្កិ៍",
               "",
               "ម៉ោង​នៅ​យ៉ាគុតស្កិ៍នា​រដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​យ៉ាគុតស្កិ៍",
               "",
            };
        final String[] Atlantic = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អាត្លង់ទិក",
               "AST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​អាត្លង់ទិក",
               "AST",
               "ម៉ោង​នៅ​អាត្លង់ទិក",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ប្រាស៊ីលីយ៉ា",
               "",
               "ម៉ោង​នៅ​ប្រាស៊ីលីយ៉ានា​​រដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​ប្រាស៊ីលីយ៉ា",
               "",
            };
        final String[] Chamorro = new String[] {
               "ម៉ោង​ស្តង់ដារនៅ​ចាំម៉ូរ៉ូ",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​កូឡុំប៊ី",
               "",
               "ម៉ោង​នៅ​កូឡុំប៊ីនា​រដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​កូឡុំប៊ី",
               "",
            };
        final String[] Falkland = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅប្រជុំ​កោះ​ហ្វក់ឡែន",
               "",
               "ម៉ោង​​នៅប្រជុំ​កោះ​ហ្វក់ឡែននារដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​ប្រជុំកោះ​ហ្វក់ឡែន",
               "",
            };
        final String[] Malaysia = new String[] {
               "ម៉ោង​នៅ​ម៉ាឡេស៊ី",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "ម៉ោង​នៅ​ម៉ាល់ឌីវ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អ៊ូឡាន​បាទូ",
               "",
               "ម៉ោងនៅ​អ៊ូឡាន​បាទូនា​រដូវ​ក្ដៅ​",
               "",
               "ម៉ោង​នៅ​អ៊ូឡាន​បាទូ",
               "",
            };
        final String[] Pakistan = new String[] {
               "ម៉ោង​ស្ដង់ដារ​នៅ​ប៉ាគីស្ថាន",
               "PKT",
               "ម៉ោងនៅ​ប៉ាគីស្ថាននា​រដូវ​ក្ដៅ​",
               "PKST",
               "ម៉ោង​នៅ​ប៉ាគីស្ថាន",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ប៉ារ៉ាហ្គាយ",
               "",
               "ម៉ោង​នៅប៉ារ៉ាហ្គាយនា​រដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​ប៉ារ៉ាហ្គាយ",
               "",
            };
        final String[] Pitcairn = new String[] {
               "ម៉ោង​នៅ​ភីឃឺន",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "ម៉ោង​នៅ​សូរីណាម",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ម៉ោងស្តង់ដារ​នៅ​អាហ្សង់ទីន",
               "",
               "ម៉ោង​នៅ​អាហ្សង់ទីននារដូវក្តៅ",
               "",
               "ម៉ោង​នៅ​អាហ្សង់ទីន",
               "",
            };
        final String[] Christmas = new String[] {
               "ម៉ោង​នៅ​កោះ​គ្រីស្មាស",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ម៉ោង​នៅ​កាឡាប៉ាកូស",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ហុងកុង",
               "HKT",
               "ម៉ោងនៅ​ហុងកុងនា​រដូវ​ក្ដៅ​",
               "HKST",
               "ម៉ោង​នៅ​ហុងកុង",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ម៉ោង​នៅ​ឥណ្ឌូចិន",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "ម៉ោងនៅកៀហ្ស៊ីស៊ីស្ថាន",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ឡត​ហៅ",
               "",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​ឡតហៅ",
               "",
               "ម៉ោង​នៅ​ឡតហៅ",
               "",
            };
        final String[] Marquesas = new String[] {
               "ម៉ោង​នៅ​កោះ​ម៉ាគឺសាស់",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ម៉ូរីស",
               "",
               "ម៉ោង​​រដូវ​ក្ដៅនៅ​ម៉ូរីស",
               "",
               "ម៉ោង​នៅ​ម៉ូរីស",
               "",
            };
        final String[] Singapore = new String[] {
               "ម៉ោង​នៅ​សិង្ហបូរី",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ម៉ោង​នៅ​វ៉េណេស៊ុយអេឡា",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អាស៊ែបៃហ្សង់",
               "",
               "ម៉ោង​​នៅ​អាស៊ែបៃហ្សង់នារដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​អាស៊ែបៃហ្សង់",
               "",
            };
        final String[] Bangladesh = new String[] {
               "ម៉ោង​ស្ដង់ដារ​នៅ​បង់ក្លាដែស",
               "",
               "ម៉ោង​​នៅ​បង់ក្លាដែសនារដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​បង់ក្លាដែស",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​កាប់វែរ",
               "",
               "ម៉ោង​​នៅ​កាប់វែរនារដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​កាប់វែរ",
               "",
            };
        final String[] East_Timor = new String[] {
               "ម៉ោង​នៅ​​ទីម័រ​ខាង​កើត",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "ពេលវេលានៅកាហ្សាក់ស្ថាន",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "ម៉ោង​នៅ​សីស្ហែល",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ម៉ោងនៅតាជីគីស្ថាន",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អ៊ូសបេគីស្ថាន",
               "",
               "ម៉ោង​នៅ​អ៊ូសបេគីស្ថាននារដូវ​ក្ដៅ​",
               "",
               "ម៉ោង​នៅ​អ៊ូសបេគីស្ថាន",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ម៉ោង​នៅ​អាហ្វហ្គានីស្ថាន",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ក្រាណូយ៉ាស",
               "",
               "ម៉ោង​នៅ​ក្រាណូយ៉ាសនា​រដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​ក្រាណូយ៉ាស",
               "",
            };
        final String[] New_Zealand = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​នូវែលសេឡង់",
               "NZST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​នូវែលសេឡង់",
               "NZDT",
               "ម៉ោង​នៅ​នូវែលសេឡង់",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ហ្វីលីពីន",
               "PST",
               "ម៉ោង​​នៅ​ហ្វីលីពីននា​រដូវ​ក្ដៅ",
               "PDT",
               "ម៉ោង​នៅ​ហ្វីលីពីន",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​វ៉្លាឌីវ៉ូស្តុក",
               "",
               "ម៉ោង​នៅ​វ៉្លាឌីវ៉ូស្តុកនា​រដូវ​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​វ៉្លាឌីវ៉ូស្តុក",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ម៉ោង​នៅ​មហាសមុទ្រ​ឥណ្ឌា",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "ម៉ោង​នៅ​កោះ​ឡាញ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "ម៉ោង​​ស្តង់ដារ​​នៅ​ញូវហ្វោនឡែន",
               "NST",
               "ម៉ោង​ពេលថ្ងៃ​នៅ​ញូវហ្វោនឡែន",
               "NDT",
               "ម៉ោង​​នៅញូវហ្វោនឡែន",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅតួកម៉េនីស្ថាន",
               "",
               "ម៉ោង​រដូវ​ក្ដៅ​នៅ​តួកម៉េនីស្ថាន​",
               "",
               "ម៉ោង​នៅ​តួកម៉េនីស្ថាន",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ម៉ោង​នៅ​ហ្គីយ៉ាន​បារាំង",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "ម៉ោងស្តង់ដារ​នៅណូវ៉ែលកាឡេដូនៀ",
               "",
               "ម៉ោង​នៅណូវ៉ែលកាឡេដូនៀនារដូវក្តៅ",
               "",
               "ម៉ោង​នៅណូវ៉ែលកាឡេដូនៀ",
               "",
            };
        final String[] South_Georgia = new String[] {
               "ម៉ោង​នៅ​កោះ​ហ្សកហ្ស៊ី",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អ៊ិខាធឺរីនប៊័ក",
               "",
               "ម៉ោង​នៅ​អ៊ិខាធឺរីនប៊័កនា​រដូវ​​ក្ដៅ",
               "",
               "ម៉ោង​នៅ​អ៊ិខាធឺរីនប៊័ក",
               "",
            };
        final String[] Africa_Central = new String[] {
               "ម៉ោង​នៅ​អាហ្វ្រិក​កណ្ដាល",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "ម៉ោង​នៅ​អាហ្វ្រិក​ខាង​កើត",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "ម៉ោង​នៅ​អាហ្វ្រិក​ខាង​លិច",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ម៉ោង​នៅ​ឌុយម៉ុងដឺអ៊ុយវីល",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អឺរ៉ុប​កណ្ដាល",
               "CET",
               "ម៉ោង​នៅ​អឺរ៉ុប​កណ្ដាលនា​រដូវ​ក្ដៅ",
               "CEST",
               "ម៉ោង​នៅ​អឺរ៉ុប​កណ្ដាល",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "ម៉ោង​ស្តង់ដារ​​នៅ​អឺរ៉ុប​​ខាង​កើត​",
               "EET",
               "ម៉ោង​នៅ​អឺរ៉ុប​​ខាង​កើត​នា​រដូវ​ក្ដៅ",
               "EEST",
               "ម៉ោង​នៅ​អឺរ៉ុប​​ខាង​កើត​",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អឺរ៉ុប​ខាង​លិច",
               "WET",
               "ម៉ោង​នៅ​អឺរ៉ុប​ខាង​លិចនារដូវ​ក្ដៅ​",
               "WEST",
               "ម៉ោង​នៅ​អឺរ៉ុប​ខាង​លិច",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "ម៉ោង​ស្តង់ដា​នៅ​ប៉ាស៊ីហ្វិក​ម៉ិកស៊ិក",
               "MST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​ប៉ាស៊ីហ្វិក​ម៉ិកស៊ិក",
               "MDT",
               "ម៉ោង​នៅ​ប៉ាស៊ីហ្វិក​ម៉ិកស៊ិក",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "ម៉ោង​នៅ​អាហ្វ្រិក​ខាង​ត្បូង",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "ម៉ោង​​ស្តង់ដារនៅ​ទ្វីបអាមេរិក​ខាង​ជើងភាគកណ្តាល",
               "CST",
               "ម៉ោង​​ពេលថ្ងៃនៅ​ទ្វីបអាមេរិក​ខាង​ជើងភាគកណ្តាល",
               "CDT",
               "ម៉ោង​​នៅ​ទ្វីបអាមេរិក​ខាង​ជើងភាគកណ្តាល",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ម៉ោងស្តង់ដារនៅទ្វីបអាមេរិកខាងជើងភាគខាងកើត",
               "EST",
               "ម៉ោងពេលថ្ងៃនៅទ្វីបអាមេរិកខាងជើងភាគខាងកើត",
               "EST",
               "ម៉ោងនៅទ្វីបអាមរិកខាងជើងភាគខាងកើត",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "ម៉ោងស្ដង់ដារនៅប៉ាស៊ីហ្វិកអាមេរិក",
               "PST",
               "ម៉ោងពេលថ្ងៃនៅប៉ាស៊ីហ្វិកអាមេរិក",
               "PDT",
               "ម៉ោងនៅប៉ាស៊ីហ្វិកអាមេរិក",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ម៉ោងនៅបារាំងខាងត្បូង និងនៅអង់តាំងទិក",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "ម៉ោង​នៅ​កោះ​កីប៊ឺត",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ម៉ោង​ស្តង់ដារ​​នៅ​ហាវៃ-អាល់ដ្យូសិន",
               "HST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​ហាវៃ-អាល់ដ្យូសិន",
               "HDT",
               "ម៉ោង​​នៅ​ហាវៃ-អាល់ដ្យូសិន",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ម៉ោង​នៅ​កោះ​ផូនីក",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅសង់​ព្យែរ និង​មីគុយឡុង",
               "",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅសង់​ព្យែរ និង​មីគុយឡុង",
               "",
               "ម៉ោង​​​នៅសង់​ព្យែរ និង​មីគុយឡុង",
               "",
            };
        final String[] America_Mountain = new String[] {
               "ម៉ោងស្តង់ដារ​នៅតំបន់ភ្នំនៃទ្វីប​អាមេរិក​​​ខាង​ជើង",
               "MST",
               "ម៉ោង​ពេលថ្ងៃនៅតំបន់ភ្នំនៃទ្វីប​អាមេរិក​​​ខាង​ជើង",
               "MST",
               "ម៉ោង​នៅតំបន់ភ្នំនៃទ្វីប​អាមេរិក​​​ខាង​ជើង",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "ម៉ោង​នៅ​ម៉ាសាល",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "ម៉ោង​នៅប៉ាពូអាស៊ី នូវែលហ្គីណេ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អូស្ត្រាលី​កណ្ដាល",
               "ACST",
               "ម៉ោង​ពេលថ្ងៃ​​​​នៅ​អូស្ត្រាលី​កណ្ដាល",
               "ACDT",
               "ម៉ោង​នៅអូស្ត្រាលី​កណ្ដាល",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​អូស្ត្រាលី​ខាង​កើត",
               "AEST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​អូស្ត្រាលី​ខាង​កើត",
               "AEDT",
               "ម៉ោង​នៅ​អូស្ត្រាលី​ខាង​កើត",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ម៉ោង​​ស្តង់ដារ​នៅ​អូស្ត្រាលី​ខាង​លិច",
               "AWST",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​អូស្ត្រាលី​ខាង​លិច",
               "AWDT",
               "ម៉ោង​​​នៅ​អូស្ត្រាលី​ខាង​លិច",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "ម៉ោង​នៅ​ឥណ្ឌូណេស៊ី​​​កណ្ដាល",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "ម៉ោង​នៅ​ឥណ្ឌូណេស៊ី​​ខាង​កើត",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "ម៉ោង​នៅ​ឥណ្ឌូណេស៊ី​​ខាង​លិច",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ម៉ោង​ស្តង់ដារ​នៅ​ភាគ​ខាង​លិច​នៃ​អូស្ត្រាលី​កណ្ដាល",
               "",
               "ម៉ោង​ពេល​ថ្ងៃ​នៅ​​ភាគ​ខាង​លិច​នៃ​អូស្ត្រាលី​កណ្ដាល",
               "",
               "ម៉ោង​នៅ​​​ភាគ​ខាង​លិច​នៅ​អូស្ត្រាលី​កណ្ដាល",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ម៉ោងនៅគ្រីនវិច",
                    "GMT",
                    "ម៉ោង​រដូវ​ក្ដៅ​​នៅ​ចក្រភព​អង់គ្លេស",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "ម៉ោងសកលដែលមានការសម្រួល",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ម៉ោងនៅគ្រីនវិច",
                    "GMT",
                    "ម៉ោង​រដូវ​ក្ដៅ​នៅ​អៀរឡង់​",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "ម៉ោងសកលដែលមានការសម្រួល",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "ម៉ោងសកលដែលមានការសម្រួល",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ម៉ោងនៅគ្រីនវិច",
                    "GMT",
                    "ម៉ោង​រដូវ​ក្ដៅ​​នៅ​ចក្រភព​អង់គ្លេស",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "ម៉ោងសកលដែលមានការសម្រួល",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "ម៉ោងសកលដែលមានការសម្រួល",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "ម៉ោងសកលដែលមានការសម្រួល",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ម៉ោងនៅគ្រីនវិច",
                    "GMT",
                    "ម៉ោង​រដូវ​ក្ដៅ​នៅ​អៀរឡង់​",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ម៉ោងនៅគ្រីនវិច",
                    "GMT",
                    "ម៉ោង​រដូវ​ក្ដៅ​​នៅ​ចក្រភព​អង់គ្លេស",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ម៉ោងនៅគ្រីនវិច",
                    "GMT",
                    "ម៉ោង​រដូវ​ក្ដៅ​​នៅ​ចក្រភព​អង់គ្លេស",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ម៉ោងនៅគ្រីនវិច",
                    "GMT",
                    "ម៉ោង​រដូវ​ក្ដៅ​​នៅ​ចក្រភព​អង់គ្លេស",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ម៉ោងនៅគ្រីនវិច",
                    "GMT",
                    "ម៉ោង​រដូវ​ក្ដៅ​​នៅ​ចក្រភព​អង់គ្លេស",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ម៉ោងនៅគ្រីនវិច",
                    "GMT",
                    "ម៉ោង​រដូវ​ក្ដៅ​​នៅ​ចក្រភព​អង់គ្លេស",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "អាដែន" },
            { "timezone.excity.Asia/Baku", "បាគូ" },
            { "timezone.excity.Asia/Dili", "ដេលី" },
            { "timezone.excity.Asia/Gaza", "កាសា" },
            { "timezone.excity.Asia/Hovd", "ហូវ" },
            { "timezone.excity.Asia/Omsk", "អូមស្កិ៍" },
            { "timezone.excity.Asia/Oral", "អូរ៉ាល់" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "អាម៉ាន់" },
            { "timezone.excity.Asia/Aqtau", "អាកទូ" },
            { "timezone.excity.Asia/Chita", "ឈីតា" },
            { "timezone.excity.Asia/Dhaka", "ដាក្កា" },
            { "timezone.excity.Asia/Dubai", "ឌុយបៃ" },
            { "timezone.excity.Asia/Kabul", "កាប៊ុល" },
            { "timezone.excity.Asia/Macau", "ម៉ាកាវ" },
            { "timezone.excity.Asia/Qatar", "កាតា" },
            { "timezone.excity.Asia/Seoul", "សេអ៊ូល" },
            { "timezone.excity.Asia/Tokyo", "តូក្យូ" },
            { "timezone.excity.Asia/Tomsk", "ថមស្កិ៍" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ជូបា" },
            { "timezone.excity.Africa/Lome", "ឡូម៉េ" },
            { "timezone.excity.Asia/Almaty", "អាល់ម៉ាទី" },
            { "timezone.excity.Asia/Anadyr", "អាណាឌី" },
            { "timezone.excity.Asia/Aqtobe", "អាកទូប៊ី" },
            { "timezone.excity.Asia/Atyrau", "អាទីរ៉ូ" },
            { "timezone.excity.Asia/Beirut", "បេរូត" },
            { "timezone.excity.Asia/Brunei", "ព្រុយណេ" },
            { "timezone.excity.Asia/Hebron", "ហេបរុន" },
            { "timezone.excity.Asia/Kuwait", "កូវ៉ែត" },
            { "timezone.excity.Asia/Manila", "ម៉ានីល" },
            { "timezone.excity.Asia/Muscat", "ម៉ាស្កាត" },
            { "timezone.excity.Asia/Riyadh", "រីយ៉ាដ" },
            { "timezone.excity.Asia/Saigon", "ហូជីមីញ" },
            { "timezone.excity.Asia/Taipei", "តៃប៉ិ" },
            { "timezone.excity.Asia/Tehran", "តេហេរ៉ង់" },
            { "timezone.excity.Asia/Urumqi", "អ៊ូរាំហ្គី" },
            { "timezone.excity.Etc/Unknown", "ទីក្រុង​មិនស្គាល់" },
            { "timezone.excity.Europe/Kiev", "កៀវ" },
            { "timezone.excity.Europe/Oslo", "អូស្លូ" },
            { "timezone.excity.Europe/Riga", "រីហ្កា" },
            { "timezone.excity.Europe/Rome", "រ៉ូម" },
            { "timezone.excity.Indian/Mahe", "ម៉ាហេ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "អាក្រា" },
            { "timezone.excity.Africa/Cairo", "គែរ" },
            { "timezone.excity.Africa/Ceuta", "ឈៀតា" },
            { "timezone.excity.Africa/Dakar", "ដាកា" },
            { "timezone.excity.Africa/Lagos", "ឡាហ្គូស" },
            { "timezone.excity.Africa/Tunis", "ទុយនីស" },
            { "timezone.excity.America/Adak", "អាដាក" },
            { "timezone.excity.America/Lima", "លីម៉ា" },
            { "timezone.excity.America/Nome", "ណូម" },
            { "timezone.excity.Asia/Baghdad", "បាកដាដ" },
            { "timezone.excity.Asia/Bahrain", "បារ៉ែន" },
            { "timezone.excity.Asia/Bangkok", "បាងកក" },
            { "timezone.excity.Asia/Barnaul", "បានូល" },
            { "timezone.excity.Asia/Bishkek", "ប៊ីស្កេក" },
            { "timezone.excity.Asia/Colombo", "កូឡុំបូ" },
            { "timezone.excity.Asia/Irkutsk", "អៀរគុតស្កិ៍" },
            { "timezone.excity.Asia/Jakarta", "ហ្សាការតា" },
            { "timezone.excity.Asia/Karachi", "ការ៉ាជី" },
            { "timezone.excity.Asia/Kuching", "ឃឺតចីង" },
            { "timezone.excity.Asia/Magadan", "ម៉ាហ្គាដាន" },
            { "timezone.excity.Asia/Nicosia", "នីកូស៊ី" },
            { "timezone.excity.Asia/Rangoon", "រ៉ង់ហ្គូន" },
            { "timezone.excity.Asia/Tbilisi", "ប៊ីលីស៊ី" },
            { "timezone.excity.Asia/Thimphu", "ធីមភូ" },
            { "timezone.excity.Asia/Yakutsk", "យ៉ាគុតស្កិ៍" },
            { "timezone.excity.Asia/Yerevan", "យ៉េរ៉េវ៉ាន់" },
            { "timezone.excity.Europe/Kirov", "គីរ៉ូវ" },
            { "timezone.excity.Europe/Malta", "ម៉ាល់ត៍" },
            { "timezone.excity.Europe/Minsk", "មីនស្កិ៍" },
            { "timezone.excity.Europe/Paris", "ប៉ារីស" },
            { "timezone.excity.Europe/Sofia", "សូហ៊្វីយ៉ា" },
            { "timezone.excity.Europe/Vaduz", "វ៉ាឌូស" },
            { "timezone.excity.Indian/Cocos", "កូកូស" },
            { "timezone.excity.Pacific/Apia", "អាពី" },
            { "timezone.excity.Pacific/Fiji", "ហ្វីជី" },
            { "timezone.excity.Pacific/Guam", "ហ្គាំ" },
            { "timezone.excity.Pacific/Niue", "នីវ៉េ" },
            { "timezone.excity.Pacific/Truk", "ឈូអុក" },
            { "timezone.excity.Pacific/Wake", "វ៉ាគី" },
            { "timezone.excity.Africa/Asmera", "អាស្មារ៉ា" },
            { "timezone.excity.Africa/Bamako", "បាម៉ាកូ" },
            { "timezone.excity.Africa/Bangui", "បង់ហ្គី" },
            { "timezone.excity.Africa/Banjul", "បង់ហ្ស៊ុល" },
            { "timezone.excity.Africa/Bissau", "ប៊ីស្សូ" },
            { "timezone.excity.Africa/Douala", "ឌូអ៊ូឡា" },
            { "timezone.excity.Africa/Harare", "ហារ៉ារ៉េ" },
            { "timezone.excity.Africa/Kigali", "គីហ្គាលី" },
            { "timezone.excity.Africa/Luanda", "លូអង់ដា" },
            { "timezone.excity.Africa/Lusaka", "លូសាកា" },
            { "timezone.excity.Africa/Malabo", "ម៉ាឡាបូ" },
            { "timezone.excity.Africa/Maputo", "ម៉ាពុយតូ" },
            { "timezone.excity.Africa/Maseru", "ម៉ាសេរុយ" },
            { "timezone.excity.Africa/Niamey", "នីញ៉ាម៉េ" },
            { "timezone.excity.America/Aruba", "អារ៉ូបា" },
            { "timezone.excity.America/Bahia", "បាហៀ" },
            { "timezone.excity.America/Belem", "បេឡឹម" },
            { "timezone.excity.America/Boise", "ប៊ូស៊ី" },
            { "timezone.excity.America/Jujuy", "សូសុយ" },
            { "timezone.excity.America/Sitka", "ស៊ីតកា" },
            { "timezone.excity.America/Thule", "ធុឡេ" },
            { "timezone.excity.Asia/Ashgabat", "អាសហ្គាបាត" },
            { "timezone.excity.Asia/Calcutta", "កុលកាតា" },
            { "timezone.excity.Asia/Damascus", "ដាម៉ាស" },
            { "timezone.excity.Asia/Dushanbe", "ឌូស្ហាន់បេ" },
            { "timezone.excity.Asia/Jayapura", "ចាយ៉ាភូរ៉ា" },
            { "timezone.excity.Asia/Katmandu", "កាត់ម៉ាន់ឌូ" },
            { "timezone.excity.Asia/Khandyga", "ខាន់ឌីហ្គា" },
            { "timezone.excity.Asia/Makassar", "ម៉ាកាសសារ" },
            { "timezone.excity.Asia/Qostanay", "កូស្ដេណេ" },
            { "timezone.excity.Asia/Sakhalin", "សាខាលីន" },
            { "timezone.excity.Asia/Shanghai", "សៀងហៃ" },
            { "timezone.excity.Asia/Tashkent", "តាស្កិន" },
            { "timezone.excity.Asia/Ust-Nera", "អូស្តណេរ៉ា" },
            { "timezone.excity.Europe/Athens", "អាថែន" },
            { "timezone.excity.Europe/Berlin", "បែរឡាំង" },
            { "timezone.excity.Europe/Dublin", "ឌុយប្លាំង" },
            { "timezone.excity.Europe/Jersey", "ជេស៊ី" },
            { "timezone.excity.Europe/Lisbon", "លីសបោន" },
            { "timezone.excity.Europe/London", "ឡុងដ៍" },
            { "timezone.excity.Europe/Madrid", "ម៉ាឌ្រីដ" },
            { "timezone.excity.Europe/Monaco", "ម៉ូណាកូ" },
            { "timezone.excity.Europe/Moscow", "មូស្គូ" },
            { "timezone.excity.Europe/Prague", "ប្រាក" },
            { "timezone.excity.Europe/Samara", "សាម៉ារ៉ា" },
            { "timezone.excity.Europe/Skopje", "ស្កុបជេ" },
            { "timezone.excity.Europe/Tirane", "ទីរ៉ាណេ" },
            { "timezone.excity.Europe/Vienna", "វីយែន" },
            { "timezone.excity.Europe/Warsaw", "វ៉ាសូវី" },
            { "timezone.excity.Europe/Zagreb", "សាគ្រែប" },
            { "timezone.excity.Europe/Zurich", "ហ៊្សូរីច" },
            { "timezone.excity.Indian/Chagos", "កាហ្គោ" },
            { "timezone.excity.Indian/Comoro", "កូម័រ" },
            { "timezone.excity.Pacific/Efate", "អ៊ីហ្វាតេ" },
            { "timezone.excity.Pacific/Nauru", "ណូរូ" },
            { "timezone.excity.Pacific/Palau", "ប៉ាឡៅ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "អាប៊ីដ្យាន" },
            { "timezone.excity.Africa/Algiers", "អាល់ហ្សេ" },
            { "timezone.excity.Africa/Conakry", "កូណាគ្រី" },
            { "timezone.excity.Africa/Kampala", "កំប៉ាឡា" },
            { "timezone.excity.Africa/Mbabane", "បាបាន" },
            { "timezone.excity.Africa/Nairobi", "ណៃរ៉ូប៊ី" },
            { "timezone.excity.Africa/Tripoli", "ទ្រីប៉ូលី" },
            { "timezone.excity.America/Belize", "បេលី" },
            { "timezone.excity.America/Bogota", "បូហ្គោតា" },
            { "timezone.excity.America/Cancun", "ខានខុន" },
            { "timezone.excity.America/Cayman", "កៃមែន" },
            { "timezone.excity.America/Cuiaba", "គុយអាបា" },
            { "timezone.excity.America/Dawson", "ដាវសុន" },
            { "timezone.excity.America/Denver", "ដែនវើ" },
            { "timezone.excity.America/Guyana", "ហ្គីយ៉ាន" },
            { "timezone.excity.America/Havana", "ឡាហាវ៉ាន" },
            { "timezone.excity.America/Inuvik", "អ៊ីនូវីក" },
            { "timezone.excity.America/Juneau", "ហ្យូនៀ" },
            { "timezone.excity.America/La_Paz", "ឡាប៉ាស" },
            { "timezone.excity.America/Maceio", "ម៉ាកសេអូ" },
            { "timezone.excity.America/Manaus", "ម៉ាណាអ៊ូស" },
            { "timezone.excity.America/Merida", "ម៉េរីដា" },
            { "timezone.excity.America/Nassau", "ណាស្សូ" },
            { "timezone.excity.America/Panama", "ប៉ាណាម៉ា" },
            { "timezone.excity.America/Recife", "រ៉េស៊ីហ្វី" },
            { "timezone.excity.America/Regina", "រ៉េហ្គីណា" },
            { "timezone.excity.Asia/Famagusta", "ហ្វ៉ាម៉ាហ្គុស្តា" },
            { "timezone.excity.Asia/Hong_Kong", "ហុងកុង" },
            { "timezone.excity.Asia/Jerusalem", "ហ្ស៊េរុយសាឡិម" },
            { "timezone.excity.Asia/Kamchatka", "កាំឆាតកា" },
            { "timezone.excity.Asia/Pontianak", "ប៉ុនទីអាណាក់" },
            { "timezone.excity.Asia/Pyongyang", "ព្យុងយ៉ាង" },
            { "timezone.excity.Asia/Qyzylorda", "គីហ្ស៊ីឡូដា" },
            { "timezone.excity.Asia/Samarkand", "សាម៉ាកាន់" },
            { "timezone.excity.Asia/Singapore", "សិង្ហបូរី" },
            { "timezone.excity.Asia/Vientiane", "វៀងចន្ទន៍" },
            { "timezone.excity.Europe/Andorra", "អង់ដូរ៉ា" },
            { "timezone.excity.Europe/Saratov", "សារ៉ាតាវ" },
            { "timezone.excity.Europe/Tallinn", "តាលិន" },
            { "timezone.excity.Europe/Vatican", "វ៉ាទីកង់" },
            { "timezone.excity.Europe/Vilnius", "វីលនីញូស" },
            { "timezone.excity.Indian/Mayotte", "ម៉ាយុត" },
            { "timezone.excity.Indian/Reunion", "រេអ៊ុយ៉ុង" },
            { "timezone.excity.Pacific/Easter", "អ៊ីស្ទ័រ" },
            { "timezone.excity.Pacific/Kosrae", "កូស្រែ" },
            { "timezone.excity.Pacific/Majuro", "ម៉ាហ្សូរ៉ូ" },
            { "timezone.excity.Pacific/Midway", "មីតវ៉េ" },
            { "timezone.excity.Pacific/Noumea", "ណូមៀ" },
            { "timezone.excity.Pacific/Ponape", "ផុនប៉ី" },
            { "timezone.excity.Pacific/Saipan", "សៃប៉ាន" },
            { "timezone.excity.Pacific/Tahiti", "តាហីទី" },
            { "timezone.excity.Pacific/Tarawa", "តារ៉ាវ៉ា" },
            { "timezone.excity.Pacific/Wallis", "វ៉ាលីស" },
            { "timezone.excity.Africa/Blantyre", "ប្លាំងទីរ៉េ" },
            { "timezone.excity.Africa/Djibouti", "ជីប៊ូទី" },
            { "timezone.excity.Africa/El_Aaiun", "អែល​អ៊ុយញៀន" },
            { "timezone.excity.Africa/Freetown", "ហ្វ្រីថោន" },
            { "timezone.excity.Africa/Gaborone", "ហ្គាបូរ៉ូន" },
            { "timezone.excity.Africa/Khartoum", "ខាទុំ" },
            { "timezone.excity.Africa/Kinshasa", "គីនស្ហាសា" },
            { "timezone.excity.Africa/Monrovia", "ម៉ុងរ៉ូវីយ៉ា" },
            { "timezone.excity.Africa/Ndjamena", "ដ្យាមេណា" },
            { "timezone.excity.Africa/Sao_Tome", "សៅតូម៉េ" },
            { "timezone.excity.Africa/Windhoek", "វីនដុក" },
            { "timezone.excity.America/Antigua", "អង់ទីហ្គា" },
            { "timezone.excity.America/Caracas", "ការ៉ាកាស" },
            { "timezone.excity.America/Cayenne", "កាយ៉េន" },
            { "timezone.excity.America/Chicago", "ស៊ីកាហ្គោ" },
            { "timezone.excity.America/Cordoba", "កូដូបា" },
            { "timezone.excity.America/Creston", "ក្រេស្តុន" },
            { "timezone.excity.America/Curacao", "កូរ៉ាកៅ" },
            { "timezone.excity.America/Detroit", "ដេត្រូអ៊ីត" },
            { "timezone.excity.America/Godthab", "នូក" },
            { "timezone.excity.America/Grenada", "ហ្គ្រើណាដ" },
            { "timezone.excity.America/Halifax", "ហាលីហ្វាក" },
            { "timezone.excity.America/Iqaluit", "អ៊ីកាឡូអ៊ីត" },
            { "timezone.excity.America/Jamaica", "ហ្សាម៉ាអ៊ីក" },
            { "timezone.excity.America/Managua", "ម៉ាណាហ្គា" },
            { "timezone.excity.America/Marigot", "ម៉ារីហ្គុត" },
            { "timezone.excity.America/Mendoza", "ម៉ែនឌូហ្សា" },
            { "timezone.excity.America/Moncton", "ម៉ុងតុន" },
            { "timezone.excity.America/Noronha", "ណូរ៉ុនញ៉ា" },
            { "timezone.excity.America/Ojinaga", "អូជីណាហ្កា" },
            { "timezone.excity.America/Phoenix", "ផូនីក" },
            { "timezone.excity.America/Tijuana", "ទីយ្យូអាណា" },
            { "timezone.excity.America/Toronto", "តូរ៉ុនតូ" },
            { "timezone.excity.America/Tortola", "តូតូឡា" },
            { "timezone.excity.America/Yakutat", "យ៉ាគូតាត" },
            { "timezone.excity.Asia/Phnom_Penh", "ភ្នំពេញ" },
            { "timezone.excity.Atlantic/Azores", "អាសូរ៉េស" },
            { "timezone.excity.Atlantic/Canary", "កាណារី" },
            { "timezone.excity.Atlantic/Faeroe", "ហ្វារ៉ូ" },
            { "timezone.excity.Australia/Eucla", "អ៊ុយក្លា" },
            { "timezone.excity.Australia/Perth", "ភឺធ" },
            { "timezone.excity.Europe/Belgrade", "បែលក្រាដ" },
            { "timezone.excity.Europe/Brussels", "ព្រុចសែល" },
            { "timezone.excity.Europe/Budapest", "ប៊ុយដាប៉ែស" },
            { "timezone.excity.Europe/Busingen", "ប៊ូស៊ីងហ្គែន" },
            { "timezone.excity.Europe/Chisinau", "ជីស៊ីណូ" },
            { "timezone.excity.Europe/Guernsey", "ហ្គេនស៊ី" },
            { "timezone.excity.Europe/Helsinki", "ហែលស៊ិនគី" },
            { "timezone.excity.Europe/Istanbul", "អ៊ីស្តង់ប៊ុល" },
            { "timezone.excity.Europe/Sarajevo", "សារ៉ាយ៉េវ៉ូ" },
            { "timezone.excity.Indian/Maldives", "ម៉ាល់ឌីវ" },
            { "timezone.excity.Pacific/Chatham", "ចាថាំ" },
            { "timezone.excity.Pacific/Fakaofo", "ហ្វាកៅហ្វូ" },
            { "timezone.excity.Pacific/Gambier", "ហ្គាំបៀ" },
            { "timezone.excity.Pacific/Norfolk", "ណ័រហ្វុក" },
            { "timezone.excity.Africa/Bujumbura", "ប៊ូយ៉ាំប៊ូរ៉ា" },
            { "timezone.excity.Africa/Mogadishu", "ម៉ូហ្គាឌីស្យូ" },
            { "timezone.excity.America/Anguilla", "អង់ហ្គីឡា" },
            { "timezone.excity.America/Asuncion", "អាសង់ស្យុង" },
            { "timezone.excity.America/Barbados", "បាបាដុស" },
            { "timezone.excity.America/Dominica", "ដូមីនីក" },
            { "timezone.excity.America/Edmonton", "អែតម៉ុងតុង" },
            { "timezone.excity.America/Eirunepe", "អ៊ីរ៉ុយណេភី" },
            { "timezone.excity.America/Mazatlan", "ម៉ាហ្សាតឡង់" },
            { "timezone.excity.America/Miquelon", "មីហ្គីឡុង" },
            { "timezone.excity.America/New_York", "ញូវយ៉ក" },
            { "timezone.excity.America/Resolute", "រ៉េ​ស៊ូឡូត" },
            { "timezone.excity.America/Santarem", "សាន់តារឹម" },
            { "timezone.excity.America/Santiago", "សាន់ទីអេហ្គោ" },
            { "timezone.excity.America/St_Johns", "សាំង​ចន" },
            { "timezone.excity.America/St_Kitts", "សាំង​ឃីត" },
            { "timezone.excity.America/St_Lucia", "សាំង​លូសៀ" },
            { "timezone.excity.America/Winnipeg", "វីនីភិក" },
            { "timezone.excity.Antarctica/Casey", "កាសី" },
            { "timezone.excity.Antarctica/Davis", "ដាវីស" },
            { "timezone.excity.Antarctica/Syowa", "ស៊ីយ៉ូវ៉ា" },
            { "timezone.excity.Antarctica/Troll", "ត្រូល" },
            { "timezone.excity.Asia/Krasnoyarsk", "ក្រាសនុយ៉ាក" },
            { "timezone.excity.Asia/Novosibirsk", "ណូវ៉ូស៊ីប៊ឺក" },
            { "timezone.excity.Asia/Ulaanbaatar", "អ៊ូឡង់បាទ័រ" },
            { "timezone.excity.Asia/Vladivostok", "វ៉្លាដីវ៉ូស្តុក" },
            { "timezone.excity.Atlantic/Bermuda", "ប៉ឺមុយដា" },
            { "timezone.excity.Atlantic/Madeira", "ម៉ាដៀរ៉ា" },
            { "timezone.excity.Atlantic/Stanley", "ស្តង់លី" },
            { "timezone.excity.Australia/Darwin", "ដាវីន" },
            { "timezone.excity.Australia/Hobart", "ហូបាត" },
            { "timezone.excity.Australia/Sydney", "ស៊ីដនី" },
            { "timezone.excity.Europe/Amsterdam", "អាំស្ទែដាំ" },
            { "timezone.excity.Europe/Astrakhan", "អាស្ត្រាខាន់" },
            { "timezone.excity.Europe/Bucharest", "ប៊ុយការ៉េស" },
            { "timezone.excity.Europe/Gibraltar", "ហ្ស៊ីប្រាល់តា" },
            { "timezone.excity.Europe/Ljubljana", "ជូបហ្សាណា" },
            { "timezone.excity.Europe/Mariehamn", "ម៉ារៀហាំ" },
            { "timezone.excity.Europe/Podgorica", "ប៉ូដហ្គោរីកា" },
            { "timezone.excity.Europe/Stockholm", "ស្តុកខុល" },
            { "timezone.excity.Europe/Ulyanovsk", "អុលយ៉ាណូវស្កិ៍" },
            { "timezone.excity.Europe/Volgograd", "វ៉ុលហ្គោហ្គ្រាដ" },
            { "timezone.excity.Indian/Christmas", "គ្រីស្មាស" },
            { "timezone.excity.Indian/Kerguelen", "ឃឺហ្គុយឡែន" },
            { "timezone.excity.Indian/Mauritius", "ម៉ូរីស" },
            { "timezone.excity.Pacific/Auckland", "អកឡែន" },
            { "timezone.excity.Pacific/Funafuti", "ហ៊្វូណាហ៊្វូទី" },
            { "timezone.excity.Pacific/Honolulu", "ហូណូលូលូ" },
            { "timezone.excity.Pacific/Pitcairn", "ភីតខៃរ៉ិន" },
            { "timezone.excity.Africa/Casablanca", "កាសាប្លាំងកា" },
            { "timezone.excity.Africa/Libreville", "លីប្រីវីល" },
            { "timezone.excity.Africa/Lubumbashi", "លូប៊ុមបាស៊ី" },
            { "timezone.excity.Africa/Nouakchott", "ណួកសុត" },
            { "timezone.excity.Africa/Porto-Novo", "ព័រតូណូវ៉ូ" },
            { "timezone.excity.America/Anchorage", "អង់ចូរ៉ាក" },
            { "timezone.excity.America/Araguaina", "អារ៉ាហ្គុយណា" },
            { "timezone.excity.America/Boa_Vista", "បៅ​វីស្តា" },
            { "timezone.excity.America/Catamarca", "កាតាម៉ាកា" },
            { "timezone.excity.America/Chihuahua", "ជីហួហួ" },
            { "timezone.excity.America/Coyhaique", "កូយអៃកេ" },
            { "timezone.excity.America/Fortaleza", "ហ្វ័រតាឡេហ្សារ" },
            { "timezone.excity.America/Glace_Bay", "ក្លាស​បេ" },
            { "timezone.excity.America/Goose_Bay", "កូសេបេ" },
            { "timezone.excity.America/Guatemala", "ក្វាតេម៉ាឡា" },
            { "timezone.excity.America/Guayaquil", "ហ្គុយ៉ាគីល" },
            { "timezone.excity.America/Matamoros", "ម៉ាតាម៉ូរ៉ូស" },
            { "timezone.excity.America/Menominee", "ម៉េណូមីនី" },
            { "timezone.excity.America/Monterrey", "ម៉ុនតេរ៉េ" },
            { "timezone.excity.America/Sao_Paulo", "សៅ​ប៉ូឡូ" },
            { "timezone.excity.America/St_Thomas", "សាំង​តូម៉ាស់" },
            { "timezone.excity.America/Vancouver", "វ៉ាន់កូវើ" },
            { "timezone.excity.Antarctica/Mawson", "ម៉ៅសាន់" },
            { "timezone.excity.Antarctica/Palmer", "ផាល់ម័រ" },
            { "timezone.excity.Antarctica/Vostok", "វ៉ូស្តុក" },
            { "timezone.excity.Asia/Kuala_Lumpur", "កូឡាឡាំពួរ" },
            { "timezone.excity.Asia/Novokuznetsk", "ណូវ៉ូឃូសណេតស្កិ៍" },
            { "timezone.excity.Europe/Bratislava", "ប្រាទីស្លាវ៉ា" },
            { "timezone.excity.Europe/Copenhagen", "កូប៉ិនហាក" },
            { "timezone.excity.Europe/Luxembourg", "លុចសំបួ" },
            { "timezone.excity.Europe/San_Marino", "សាំងម៉ារ៉ាំង" },
            { "timezone.excity.Europe/Simferopol", "ស៊ីមហ្វើរ៉ុប៉ូល" },
            { "timezone.excity.Pacific/Enderbury", "កាន់តុន" },
            { "timezone.excity.Pacific/Galapagos", "ហ្គាឡាប៉ាហ្គោស" },
            { "timezone.excity.Pacific/Kwajalein", "ក្វាហ្សាលៀន" },
            { "timezone.excity.Pacific/Marquesas", "ម៉ាហ្គីសាស" },
            { "timezone.excity.Pacific/Pago_Pago", "ប៉ាហ្គោ ប៉ាហ្គោ" },
            { "timezone.excity.Pacific/Rarotonga", "រ៉ារ៉ូតុងហ្គា" },
            { "timezone.excity.Pacific/Tongatapu", "តុងហ្គាតាពូ" },
            { "timezone.excity.Africa/Addis_Ababa", "អាឌីសអាបេបា" },
            { "timezone.excity.Africa/Brazzaville", "ប្រាស្ហាវីល" },
            { "timezone.excity.Africa/Ouagadougou", "អៅហ្គាឌូហ្គូ" },
            { "timezone.excity.America/Costa_Rica", "កូស្តារីកា" },
            { "timezone.excity.America/Grand_Turk", "ហ្គ្រេន​ទូក" },
            { "timezone.excity.America/Guadeloupe", "ហ្គោដេលូប៉េ" },
            { "timezone.excity.America/Hermosillo", "ហ៊ែម៉ូស៊ីឡូ" },
            { "timezone.excity.America/Kralendijk", "ក្រាលែនឌីក" },
            { "timezone.excity.America/Louisville", "លូអ៊ីវីល" },
            { "timezone.excity.America/Martinique", "ម៉ាទីនីក" },
            { "timezone.excity.America/Metlakatla", "មេត្លា កាត្លា" },
            { "timezone.excity.America/Montevideo", "ម៉ុងតេវីដេអូ" },
            { "timezone.excity.America/Montserrat", "ម៉ុងស៊ែរ៉ាត​" },
            { "timezone.excity.America/Paramaribo", "ប៉ារ៉ាម៉ារីបូ" },
            { "timezone.excity.America/Rio_Branco", "រីយ៉ូប្រានកូ" },
            { "timezone.excity.America/St_Vincent", "សាំង​វីនសេន" },
            { "timezone.excity.America/Whitehorse", "វ៉ាយហស" },
            { "timezone.excity.Antarctica/McMurdo", "ម៉ាក់មុយដូ" },
            { "timezone.excity.Antarctica/Rothera", "រ៉ូធីរ៉ា" },
            { "timezone.excity.Asia/Srednekolymsk", "ស្រីតនីកូលីម" },
            { "timezone.excity.Asia/Yekaterinburg", "យ៉េកាធឺរិនប៊ើក" },
            { "timezone.excity.Atlantic/Reykjavik", "រ៉ៃក្យាវិក" },
            { "timezone.excity.Atlantic/St_Helena", "សាំងហេឡេណា" },
            { "timezone.excity.Australia/Adelaide", "អាដេឡែត" },
            { "timezone.excity.Australia/Brisbane", "ប្រីសប៊ែន" },
            { "timezone.excity.Australia/Lindeman", "លីនឌីម៉ែន" },
            { "timezone.excity.Europe/Isle_of_Man", "អែលអុហ្វម៉ែន" },
            { "timezone.excity.Europe/Kaliningrad", "កាលីនីងហ្រ្គាដ" },
            { "timezone.excity.Pacific/Kiritimati", "គិរីទីម៉ាទិ" },
            { "timezone.excity.Africa/Johannesburg", "ជូហានណេប៊ឺហ្គ" },
            { "timezone.excity.America/El_Salvador", "អែលសាល់វ៉ាឌ័រ" },
            { "timezone.excity.America/Fort_Nelson", "ហ្វតណេលសាន់" },
            { "timezone.excity.America/Los_Angeles", "ឡូអង់ហ្គិឡេស" },
            { "timezone.excity.America/Mexico_City", "ទីក្រុងម៉ិចស៊ីកូ" },
            { "timezone.excity.America/Porto_Velho", "ព័រតូ​វិលហូ" },
            { "timezone.excity.America/Puerto_Rico", "ព័រតូរីកូ" },
            { "timezone.excity.America/Tegucigalpa", "តេហ្គូស៊ីហ្គាល់ប៉ា" },
            { "timezone.excity.Arctic/Longyearbyen", "ឡុង​យ៉ា​ប៊ីយេន" },
            { "timezone.excity.Atlantic/Cape_Verde", "កាប់វែរ" },
            { "timezone.excity.Australia/Lord_Howe", "ឡតហូវ៉េ" },
            { "timezone.excity.Australia/Melbourne", "ម៉េលប៊ន" },
            { "timezone.excity.Indian/Antananarivo", "អង់តាណាណារីវ" },
            { "timezone.excity.Pacific/Guadalcanal", "ហ្គាដាល់ខាណាល់" },
            { "timezone.excity.Africa/Dar_es_Salaam", "ដាអ៊ីសាឡាំ" },
            { "timezone.excity.America/Blanc-Sablon", "ប្លង់​សាប់ឡុង" },
            { "timezone.excity.America/Buenos_Aires", "ប៊ុយណូស៊ែ" },
            { "timezone.excity.America/Campo_Grande", "ខេមប៉ូហ្គ្រង់​" },
            { "timezone.excity.America/Danmarkshavn", "ដានម៉ាកស្ហាវិន" },
            { "timezone.excity.America/Dawson_Creek", "ដាវសុន​ក្រិក" },
            { "timezone.excity.America/Indiana/Knox", "ណុក ឥណ្ឌាណា" },
            { "timezone.excity.America/Indianapolis", "ឥណ្ឌាណាប៉ូលីស" },
            { "timezone.excity.America/Punta_Arenas", "ពុនតា អារ៉េណា" },
            { "timezone.excity.America/Rankin_Inlet", "រ៉ាន់ឃីន​អ៊ីនឡិត" },
            { "timezone.excity.America/Scoresbysund", "អ៊ីតូគ័រតូមីត" },
            { "timezone.excity.Antarctica/Macquarie", "ម៉ាកខ្វារី" },
            { "timezone.excity.Pacific/Bougainville", "បូហ្គែនវីល" },
            { "timezone.excity.Pacific/Port_Moresby", "ព័រម៉ូរេសប៊ី" },
            { "timezone.excity.America/Cambridge_Bay", "ខេមប្រីដបេ" },
            { "timezone.excity.America/Ciudad_Juarez", "ស៊ីអ៊ូដាដ ហ៊ូអារ៉េស" },
            { "timezone.excity.America/Coral_Harbour", "អាទីកូកាន" },
            { "timezone.excity.America/Indiana/Vevay", "វេវ៉ៃ ឥណ្ឌាយ៉ាណា" },
            { "timezone.excity.America/Lower_Princes", "ឡូវើ​ព្រីន​ហ្គ័រទ័រ" },
            { "timezone.excity.America/Port_of_Spain", "ព័រអេស្ប៉ាញ" },
            { "timezone.excity.America/Santo_Domingo", "សាន់ដូម៉ាំង" },
            { "timezone.excity.America/St_Barthelemy", "សាំង​បាធីលីម៉ី" },
            { "timezone.excity.America/Swift_Current", "ស្វីត​ខឺរិន" },
            { "timezone.excity.Australia/Broken_Hill", "ប្រូកខិនហីល" },
            { "timezone.excity.America/Bahia_Banderas", "បាហៀបង់ដេរ៉ាស" },
            { "timezone.excity.America/Port-au-Prince", "ព័រអូប្រ៉ាំង" },
            { "timezone.excity.Atlantic/South_Georgia", "ហ្សកហ្ស៊ី​ខាង​ត្បូង" },
            { "timezone.excity.America/Argentina/Salta", "សាល់តា" },
            { "timezone.excity.America/Indiana/Marengo", "ម៉ារេនកូ ឥណ្ឌាណា" },
            { "timezone.excity.America/Indiana/Winamac", "វីណាម៉ាក់ ឥណ្ឌាណា" },
            { "timezone.excity.America/Argentina/Tucuman", "ទូគូម៉ង់" },
            { "timezone.excity.America/Argentina/Ushuaia", "អ៊ុយសូអៃ" },
            { "timezone.excity.America/Indiana/Tell_City", "ទីក្រុងថែល ឥណ្ឌាណា" },
            { "timezone.excity.America/Indiana/Vincennes", "វិនសេណេស ឥណ្ឌាណា" },
            { "timezone.excity.Antarctica/DumontDUrville", "ឌុយម៉ុងដឺអ៊ុយវីល" },
            { "timezone.excity.America/Argentina/La_Rioja", "ឡារីយ៉ូហា" },
            { "timezone.excity.America/Argentina/San_Juan", "សាំងហ្សង់" },
            { "timezone.excity.America/Argentina/San_Luis", "សាន់លូអ៊ីស" },
            { "timezone.excity.America/Indiana/Petersburg", "ភីធើ​ប៊ឹក ឥណ្ឌាណា" },
            { "timezone.excity.America/Kentucky/Monticello", "ម៉ងទីសេឡូ កេនទូគី" },
            { "timezone.excity.America/North_Dakota/Beulah", "ប៊ឺឡា ដាកូតា​ខាងជើង" },
            { "timezone.excity.America/North_Dakota/Center", "សិនធឺ ដាកូតា​ខាង​ជើង" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "រីយ៉ូហ្គាឡេហ្គូស" },
            { "timezone.excity.America/North_Dakota/New_Salem", "ញូវ​សាឡឹម ដាកូតា​ខាង​ជើង" },
        };
        return data;
    }
}
