/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_nqo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "ߊߐߘ" },
            { "AFN", "ߊߝߊ" },
            { "ALL", "ߊߟߟ" },
            { "AMD", "ߊߡߘ" },
            { "ANG", "ߊ߲ߕߝ" },
            { "AOA", "ߊ߲ߜ߭ߎ" },
            { "AON", "ߊߜ߭ߞ" },
            { "AOR", "ߊߜ߭ߝ" },
            { "ARS", "ߊߖ߭ߔ" },
            { "AUD", "$ߐ" },
            { "AWG", "ߊߥߖ߭" },
            { "AZN", "ߊߖߣ" },
            { "BAM", "ߓߍߡ" },
            { "BBD", "ߓߓߘ" },
            { "BDT", "ߓߘߕ" },
            { "BGN", "ߓߜ߭ߟ" },
            { "BHD", "ߓߤߘ" },
            { "BIF", "ߓߙߝ" },
            { "BMD", "ߓߡߘ" },
            { "BND", "ߓߣߘ" },
            { "BOB", "ߓߏߓ" },
            { "BSD", "ߓߛߘ" },
            { "BTN", "ߓߕߒ" },
            { "BWP", "ߓߥߔ" },
            { "BYN", "ߓߌߙ" },
            { "CDF", "ߞߝ" },
            { "CHF", "ߛߥߝ" },
            { "CLP", "ߛߟߔ" },
            { "CNH", "ߛߦߤ" },
            { "CNY", "ߛߣߦ" },
            { "COP", "ߞߐߔ" },
            { "CRC", "ߞߙߞ" },
            { "CUC", "ߞߎ߳ߞ" },
            { "CUP", "ߞߎ߳ߔ" },
            { "CVE", "ߍߛߞ" },
            { "CZK", "ߗߞߞ" },
            { "DJF", "ߖߓߝ" },
            { "DKK", "ߘߞߞ" },
            { "DOP", "ߘߏߔ" },
            { "DZD", "ߊߟߘ" },
            { "EGP", "ߡߛߔ" },
            { "ERN", "ߋߙߝ" },
            { "ETB", "ߋߗߓ" },
            { "FJD", "$ ߝߖ" },
            { "FKP", "ߝߞߔ" },
            { "GEL", "ߖ߭ߐߟ" },
            { "GHS", "ߜ߭ߛߘ" },
            { "GIP", "ߖ߭ߓߔ£" },
            { "GMD", "ߜ߭ߓߘ" },
            { "GNF", "߿" },
            { "GNS", "ߖߛ߾" },
            { "GQE", "ߕߖߋ" },
            { "GTQ", "ߜ߭ߕߞ" },
            { "GWE", "ߖߓߍ" },
            { "GWP", "ߖߓߔ" },
            { "GYD", "ߜ߭ߎ߳ߘ" },
            { "HKD", "ߤߞߘ" },
            { "HNL", "ߤߘߟ" },
            { "HRK", "ߞߛߞ" },
            { "HTG", "ߤߕߜ߭" },
            { "HUF", "ߤߜ߭ߝ" },
            { "IDR", "ߍ߲ߘߙ" },
            { "IQD", "ߌߞߘ" },
            { "IRR", "ߌߙߙ" },
            { "ISK", "ߌߛߞ" },
            { "JMD", "ߖߡߘ" },
            { "JOD", "ߖߐߘ" },
            { "JPY", "ߗ߭ߔߦ" },
            { "KES", "ߞߋߛ" },
            { "KGS", "ߞߜ߭ߛ" },
            { "KHR", "ߞߓߙ" },
            { "KMF", "ߞߡߝ" },
            { "KPW", "ߞߞߥ" },
            { "KWD", "ߞߥߘ" },
            { "KYD", "ߞߌߘ" },
            { "KZT", "ߞߗ߭ߕ" },
            { "LAK", "ߟߊߞ" },
            { "LBP", "ߟߓ£" },
            { "LKR", "ߟߞߙ" },
            { "LRD", "ߟ߾" },
            { "LSL", "ߟߛߟ" },
            { "LYD", "ߟߓߘ" },
            { "MAD", "ߡߘߤ" },
            { "MAF", "ߡߙߝ" },
            { "MDL", "ߡߘߟ" },
            { "MGA", "ߡߘߙ" },
            { "MGF", "ߡߘߝ" },
            { "MKD", "ߡߞߘ" },
            { "MLF", "ߡߝ" },
            { "MMK", "ߡߡߞ" },
            { "MNT", "ߡߣߕ" },
            { "MOP", "ߡߏߔ" },
            { "MRO", "ߡߙߏ" },
            { "MRU", "ߡߎߜ߭" },
            { "MUR", "ߡߙߔ" },
            { "MVR", "ߡߝ߭ߙ" },
            { "MWK", "ߡߟߞ" },
            { "MXN", "ߡߞ$" },
            { "MYR", "ߡߦߙ" },
            { "MZE", "ߡߖ߭ߋ" },
            { "MZM", "ߡߖߡ" },
            { "MZN", "ߡߖ߭ߡ" },
            { "NAD", "ߣߡߘ" },
            { "NGN", "ߖߣ" },
            { "NIO", "ߣߌߏ" },
            { "NOK", "ߣߐߞ" },
            { "NPR", "ߣߔߙ" },
            { "NZD", "$ߣߖ߭" },
            { "OMR", "ߏߡߙ" },
            { "PAB", "ߔߊߓ" },
            { "PEN", "ߔߋߛ" },
            { "PGK", "ߔߖߞ" },
            { "PKR", "ߔߞߙ" },
            { "PLN", "ߔߟߗ߭" },
            { "PYG", "ߔߙߜ߭" },
            { "QAR", "ߞߊߙ" },
            { "RHD", "ߖ߭ߓߘ" },
            { "RON", "ߙߎߟ" },
            { "RSD", "ߙߛߘ" },
            { "RUB", "ߌߎߙ" },
            { "RWF", "ߙߥߝ" },
            { "SAR", "ߛߊߙ" },
            { "SBD", "ߛߓߘ" },
            { "SCR", "ߛߛߥ" },
            { "SDD", "ߛߘߘ" },
            { "SDG", "ߛߘߜ߭" },
            { "SDP", "ߛߘߔ" },
            { "SEK", "ߛߥߞ" },
            { "SGD", "ߛߜ߭ߘ" },
            { "SHP", "ߛߤߔ" },
            { "SLE", "ߛߙߔ" },
            { "SLL", "ߛߟߟ" },
            { "SOS", "ߛߡߛ" },
            { "SRD", "ߛߎߘ" },
            { "SSP", "ߛߛߔ" },
            { "STD", "ߛߕߘ" },
            { "STN", "ߛߔߘ" },
            { "SYP", "ߛߌߔ" },
            { "SZL", "ߛߖ߭ߟ" },
            { "THB", "ߕߘߓ" },
            { "TJS", "ߕߖߛ" },
            { "TMT", "ߕߡߕ" },
            { "TND", "ߕߣߘ" },
            { "TOP", "ߕߏߔ" },
            { "TRY", "ߕߎߟ" },
            { "TTD", "ߕߕߘ" },
            { "TWD", "ߕߥߘ" },
            { "TZS", "ߕߖ߭ߛ" },
            { "UAH", "ߌߞߤ" },
            { "UGS", "ߎߜ߭ߥ" },
            { "UGX", "ߎߜ߭ߛ" },
            { "USD", "ߊߞߘ$" },
            { "UYU", "ߎ߳ߔ" },
            { "UZS", "ߎߗ߭ߛ" },
            { "VES", "ߝ߭ߋߓ" },
            { "VUV", "ߝ߭ߕߝ߭" },
            { "WST", "$ߥߛ" },
            { "XAF", "ߝߛߝ" },
            { "XCD", "ߛߟߘ" },
            { "XOF", "߾" },
            { "XPF", "߾ ߝߛߝ" },
            { "YER", "ߦߡߙ" },
            { "ZAR", "ߥߝߙ" },
            { "ZMK", "ߖ߭ߓߞ" },
            { "ZMW", "ߖ߭ߓߥ" },
            { "ZRN", "ߖ߭ߙ" },
            { "ZRZ", "ߖ߭ߙߖ߭" },
            { "ZWD", "ߖ߭ߥߘ" },
            { "ZWL", "ߖ߭ߥߟ" },
            { "ZWR", "ߖ߭ߥߙ" },
            { "aed", "ߊߙߊߓߎߟߊ߫ ߡߊ߲߬ߛߊ߬ߙߋ߬ߠߊ ߟߊߘߍ߬ߣߍ߲ ߘߌ߬ߙߑߤߊߡ" },
            { "afn", "ߊߝߎߜ߭ߊߣߌߛߑߕߊ߲߫ ߊߝߑߜ߭ߊߣߌߛ" },
            { "all", "ߊߟߑߓߊߣߌ߫ ߟߍߞ" },
            { "amd", "ߊߙߑߡߋߣߌ߫ ߘߌ߬ߙߑߤߊߡ" },
            { "ang", "ߞߎߙߊߛߊߥߏ߫ ߊ߲ߕߌ߫ ߝߑߟߏߙߌ߲ߛ" },
            { "aoa", "ߊ߲ߜ߭ߏߟߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߊ߲ߖ߭ߊ" },
            { "aok", "ߊ߲ߜ߭ߏߟߊ߫ ߞߎߥߊ߲ߖ߭ߊ ( ߁߉߇߇–߁߉߉߀ )" },
            { "aon", "ߊ߲ߜ߭ߏߟߊ߫ ߞߎߥߊߖ߭ߊ߫ ߞߎߘߊ ( ߁߉߉߀–߂߀߀߀ )" },
            { "aor", "ߊ߲ߜ߭ߏߟߊ߫ ߞߎߥߊߖ߭ߊ ߝߊ߲߬ߞߊߘߏ߲߬ߣߍ߲ ( ߁߉߉߅–߁߉߉߉ )" },
            { "ars", "ߊߙߑߖ߭ߊ߲ߕߌ߲߫ ߔߋߛߏ" },
            { "aud", "ߐߛߑߕߙߊߟߌ߫ ߘߟߊ" },
            { "awg", "ߊߙߎߓߊ߫ ߝߑߟߏߙߌ߲ߛ" },
            { "azn", "ߊߖߍߙߑߓߊߦߌߖߊ߲߫ ߊߗ߭ߋߙߌ" },
            { "bam", "ߓߐߛߑߣߌ߫ ߍߙߑߗ߭ߋߜ߭ߏߝ߭ߌߣ ߡߊߙߞ ߝߊ߬ߟߋ߲߬ߕߊ" },
            { "bbd", "ߓߊߙߑߓߊߘߐߛ ߘߟߊ" },
            { "bdt", "ߓߊ߲ߜ߭ߑߟߊߘߍߛ ߕߞߊ" },
            { "bgn", "ߓߎ߳ߟߑߜ߭ߊߙߌ߫ ߟߍߝ߭" },
            { "bhd", "ߓߤߊ߬ߙߊߦߌߣ ߘߌ߬ߣߊߙ" },
            { "bif", "ߓߎߙߎ߲ߘߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲" },
            { "bmd", "ߓߍߙߑߡߎߘߊ߫ ߘߟߊ" },
            { "bnd", "ߓߙߎߣߌ߫ ߘߟߊ" },
            { "bob", "ߓߏߟߝ߭ߌ߫ ߓߏߟߝ߭ߌߦߊߣߏ߬" },
            { "brl", "ߓߙߋߖ߭ߌߟ ߙߋߦߊߟ" },
            { "bsd", "ߓߤߊߡߊߛ ߘߟߊ" },
            { "btn", "ߓߎߕߊ߲߫ ߒߜ߭ߎߟߑߕߙߎߡ" },
            { "bwp", "ߓߐߛߎߥߣߊߞߊ ߟߎ߬ ߟߊ߫ ߔߎߟߊ" },
            { "byn", "ߓߌߟߏߙߌߛ ߙߓߎߟ" },
            { "bzd", "ߓߙߋߖ߭ߌߟ ߘߟߊ" },
            { "cdf", "ߞߏ߲߬ߜ߭ߏ߬ߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲" },
            { "chf", "ߛߎߥߌߛ ߝߊߙߊ߲" },
            { "clp", "ߛ߭ߟߌ߫ ߔߋߛߏ" },
            { "cnh", "ߛߌߣ ߦߎߥߊߣ (ߝߊ߲߬ߕߙߊ ߖߌߘߊ)" },
            { "cny", "ߦߎߥߊߣ ߙߊ߲ߡߌ߲ߓߌ߫" },
            { "cop", "ߞߐߟߐ߲ߓߌ߫ ߔߋߛߏ" },
            { "crc", "ߞߐߛߑߕߊߙߌߞߊ߫ ߞߐߟߐߣ" },
            { "cuc", "ߞߎ߳ߓߊ߫ ߔߋߛߏ߫ ߝߊ߬ߟߋ߲߬ߕߊ" },
            { "cup", "ߞߎ߳ߓߊ߫ ߔߋߛߏ߫߫" },
            { "cve", "ߜߙߋߞߎ߲߫ ߝߙߌߛߌߞߊ ߟߎ߬ ߍߛߑߞߎߘߐߛ" },
            { "czk", "ߗߋߞߏߛߟߏߝ߭ߊߞߌ߫ ߞߎߙߐߣ" },
            { "djf", "ߖߌߓߎߕߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲" },
            { "dkk", "ߘߊߣߌߡߊߙߞ ߞߎߙߐߣ" },
            { "dop", "ߘߏߡߣߌߞ ߞߊ߲ߓߍ߲ ߔߋߛߏ" },
            { "dzd", "ߊߟߌߖ߭ߋߙߌߞߊ ߟߎ߬ ߟߊ߫ ߘߌ߬ߣߊ߯ߙߌ" },
            { "egp", "ߡߌߛߌߙߊ߲ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬" },
            { "ern", "ߋߙߌߕߙߋߞߊ ߟߎ߬ ߟߊ߫ ߣߊߝߑߞߊ" },
            { "etb", "ߋߗߏߔߌߞߊ ߟߎ߬ ߟߊ߫ ߓߌߙߑߛ" },
            { "eur", "ߋߙߏ" },
            { "fjd", "ߝߖߌ߫ ߘߟߊ" },
            { "fkp", "ߝߊߟߞߑߟߊ߲ߘ ߌߛߑߟߊ߲ߘ ߔߐߣߌ߬" },
            { "gbp", "ߡߊ߬ߛߊ߬ߟߊ߫-ߘߍ߬ߣߍ߲ ߔߐߣߌ߬" },
            { "gel", "ߖ߭ߐߙߑߖߌ߫ ߟߊߙߌ" },
            { "ghc", "ߛߘߌ" },
            { "ghs", "ߜ߭ߊ߯ߣߊ߫ ߛߘߌ" },
            { "gip", "ߖ߭ߌߓߑߙߊߟߑߕߊ߫ ߔߐߣߌ߬" },
            { "gmd", "ߜ߭ߊ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߘߟߊߛߌ߫" },
            { "gnf", "ߖߌ߬ߣߍ߬ߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲" },
            { "gns", "ߖߌ߬ߣߍ߬ߞߊ ߟߎ߬ ߟߊ߫ ߛߟߌ" },
            { "gqe", "ߕߍߡߊߓߊ߲߮ ߖߌ߬ߣߍ߬ߞߊ ߟߎ߬ ߟߊ߫ ߋߞߥߋߟߋ" },
            { "gtq", "ߜ߭ߎߥߊߕߋߡߟߊ߫ ߞߋߕߑߗ߭ߊߟ" },
            { "gwe", "ߖߌߣߍ߫ ߓߌߛߊߥߏߞߊ ߟߎ߬ ߟߊ߫ ߍߛߑߞߎߘߐߛ" },
            { "gwp", "ߖߌߣߍ߫ ߓߌߛߊߥߏߞߊ ߟߎ߬ ߟߊ߫ ߔߋߖ߭ߏ" },
            { "gyd", "ߜ߭ߎ߳ߦߊߣ ߘߟߊ" },
            { "hkd", "ߤߐ߲ߞߐ߲߫ ߘߟߊ" },
            { "hnl", "ߤߐ߲ߘߎߙߊ߫ ߟߋ߲ߔߌߙߊ" },
            { "hrk", "ߞߙߏߥߊߛߌ߫ ߞߎߣߊ߬" },
            { "htg", "ߤߊߦߕߌ߫ ߜ߭ߎߙߑߘ" },
            { "huf", "ߢߐ߲ߜ߭ߙߌ߫ ߝߏߙߍ߲ߕ" },
            { "idr", "ߍ߲ߘߣߏߛߌ߫ ߙߎߔߌ" },
            { "ils", "ߌߛߑߙߊߍߟ ߛߌߞߍߟ ߞߎߘߊ" },
            { "inr", "ߤߌ߲ߘߎ߬ ߙߎߔߌ" },
            { "iqd", "ߌߙߊߞߌ߬ ߘߌ߬ߣߊߙ" },
            { "irr", "ߌߙߊ߲߫ ߙߌ߬ߦߊߟ" },
            { "isk", "ߌߛߑߟߊ߲ߘ ߞߎߙߐߣ" },
            { "jmd", "ߖߡߊߦߌߞ ߘߟߊ" },
            { "jod", "ߖߐߙߑߘߊߣߌ߫ ߘߌ߬ߣߊߙ" },
            { "jpy", "ߣߌߔߐ߲߫ ߦߍߣ" },
            { "kes", "ߝߋߣߌߦߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭" },
            { "kgs", "ߞߌߙߜ߭ߌߛߑߕߊ߲߫ ߛߐߡ" },
            { "khr", "ߞߊ߲ߓߐߘߑߖ ߙߌߦߍߟ" },
            { "kmf", "ߞߐߡ߲߯ߙߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲" },
            { "kpw", "ߞߐ߬ߘߎ߮-ߞߏߙߋ߫ ߥߐߣ" },
            { "krw", "ߥߙߏ߬ߘߎ߮-ߞߏߙߋ߫ ߥߐߣ" },
            { "kwd", "ߞߎ߬ߥߍߕ ߘߌ߬ߣߊߙ" },
            { "kyd", "ߞߊߦߌߡߊ߲߫ ߌߛߑߟߊ߲ߘ ߘߟߊ" },
            { "kzt", "ߞߗ߭ߊߞߌߛߑߕߊ߲߫ ߕߊ߲ߖ߭" },
            { "lak", "ߟߊߏߕߌ߫ ߞߌߔ" },
            { "lbp", "ߟߌߓߊ߲߫ ߔߐߣߌ߬" },
            { "lkr", "ߛߙߌ߫ ߟߊ߲ߞߊ߫ ߙߎߔߌ" },
            { "lrd", "ߟߌߓߋߙߌߦߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊߙ" },
            { "lsl", "ߟߋߛߕߏߞߊ ߟߎ߬ ߟߊ߫ ߟߏߕߌ" },
            { "lyd", "ߟߓߌ߫ ߘߌ߬ߣߊ߯ߙ" },
            { "mad", "ߡߊ߬ߙߐߞߎ߬ ߘߌ߬ߙߑߤߊߡ" },
            { "maf", "ߡߊ߬ߙߐ߬ߞߎߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲" },
            { "mdl", "ߝߐߟߑߘߊߝ߭ߌ߫ ߟߋ߳" },
            { "mga", "ߡߘߊߜ߭ߊߛߑߞߊ߯ߙߌߞߊ ߟߎ߬ ߟߊ߫ ߊߙߌߦߊߙߌ" },
            { "mgf", "ߡߘߊߜ߭ߊߑߞߊ߯ߙߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲" },
            { "mkd", "ߡߊߛߋߘߏߣߌ߫ ߘߋߣߊߙ" },
            { "mlf", "ߡߊߟߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲" },
            { "mmk", "ߡߌߦߊ߲ߡߊߙ ߞߌߦߊߕ" },
            { "mnt", "ߡߐ߲ߜ߭ߐߟߌ߫ ߕߎߜ߭ߙߌߞ" },
            { "mop", "ߡߞߊߥߏ߫ ߔߕߊߞߊ߫" },
            { "mro", "ߡߏߙߌߕߊߣߌߞߊ ߟߎ߬ ߟߊ߫ ߎ߬ߜ߭ߌߦߊ ( ߁߉߇߃–߂߀߁߇ )" },
            { "mru", "ߡߏߙߌߕߊߣߌߞߊ ߟߎ߬ ߟߊ߫ ߎ߬ߜ߭ߌߦߊ" },
            { "mur", "ߡߏߙߛߌߞߊ ߟߎ߬ ߟߊ߫ ߙߔߎ" },
            { "mvr", "ߡߊߟߑߘߝ߭ߌ߫ ߙߎߝߌߦߊ" },
            { "mwk", "ߡߟߊߥߌߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߛߊ" },
            { "mxn", "ߡߍߞߑߛߌߞ ߔߋߛߏ" },
            { "myr", "ߡߊߟߍߘߎ߯ ߙߌ߲ߖ߭ߌ" },
            { "mze", "ߡߏߖ߭ߊ߲ߓߞߌߞߊ ߟߎ߬ ߟߊ߫ ߍߛߑߞߎߘߏߛ" },
            { "mzm", "ߡߏߖ߭ߊ߲ߓߞߌߞߊ ߟߎ߬ ߟߊ߫ ߡߋߕߌߞ ( ߁߉߈߀–߂߀߀߆ )" },
            { "mzn", "ߡߏߖ߭ߊ߲ߓߞߌߞߊ ߟߎ߬ ߟߊ߫ ߡߋߕߌߞߊߟ" },
            { "nad", "ߣߊߡߌ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ" },
            { "ngn", "ߖߋ߬ߟߌ߬ߓߊ߬ߞߊ ߟߎ߬ ߟߊ߫ ߣߍߙߊ" },
            { "nio", "ߣߌߞߙߊߜ߭ߎߥߊ߫ ߞߐߙߑߘߏߓߊ߫ ߏߙߏ߫" },
            { "nok", "ߣߐߙߑߝ߭ߍߛ ߞߎߙߐߣ" },
            { "npr", "ߣߋߔߊߟ ߙߎߔߌ" },
            { "nzd", "ߣߌߦߎߖ߭ߌߟߊ߲ߘߌ߫ ߘߟߊ" },
            { "omr", "ߏߡߊߣ ߙߌ߬ߦߊߟ" },
            { "pab", "ߔߣߊߡߊ߫ ߓߊߟߑߓߏߥߊ߫" },
            { "pen", "ߔߋߙߎ߫ ߛߐߟ" },
            { "pgk", "ߔߊߔߎߥߊ߫ ߖߌ߬ߣߍ߬ ߞߎߘߊ߫ ߞߌߣߊ" },
            { "php", "ߝߟߌߔߌߣ ߔߋߛߏ" },
            { "pkr", "ߔߊߞߌߛߑߕߊ߲߫ ߙߎߔߌ" },
            { "pln", "ߔߏߟߐߢ ߗ߭ߑߟߏߕߌ߫" },
            { "pyg", "ߔߙߊߜ߭ߏߦߋ߫ ߜ߭ߎߙߊߣߊߛ" },
            { "qar", "ߞߕߊߙ ߙߌ߬ߦߊߟ" },
            { "rhd", "ߖ߭ߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ" },
            { "ron", "ߙߎߡߊߣߌ߫ ߟߋ߳" },
            { "rsd", "ߛߍߙߑߓߌ߫ ߘߋߣߊߙ" },
            { "rub", "ߌ߬ߙߌ߬ߛߌ߫ ߙߎߓߎߟ" },
            { "rwf", "ߙߎߥߊ߲ߘߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲" },
            { "sar", "ߛߎ߰ߘߎ߬ߟߊ߫ ߙߌ߬ߦߊߟ" },
            { "sbd", "ߛߟߏ߬ߡߣߊ߬ ߕߌ߲ ߠߎ߬ ߘߟߊ" },
            { "scr", "ߛߋߦߌߛߍߟߌߞߊ ߟߎ߬ ߟߊ߫ ߙߎߔߌ" },
            { "sdd", "ߛߎ߬ߘߊ߲߬ߞߊ ߟߎ߬ ߘߌ߬ߣߊ߯ߙ ( ߁߉߉߂–߂߀߀߇ )" },
            { "sdg", "ߛߎߘߊ߲ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬" },
            { "sdp", "ߛߎ߬ߘ߲ߊ߬ߞߊ ߟߊ߫ ߔߐߣߌ߬ ( ߁߉߅߆–߂߀߀߇ )" },
            { "sek", "ߛߎߥߍߘ ߞߎߙߐߣ" },
            { "sgd", "ߛߍ߲ߜ߭ߊߔߎߙ ߘߟߊ" },
            { "shp", "ߛߍ߲ߕ ߤߌߟߋߣߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬" },
            { "sle", "ߛߙߊ߬ߟߏ߲߬ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬" },
            { "sll", "ߛߙߊ߬ߟߏ߲߬ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬ - 1964-2022" },
            { "sos", "ߛߏߡߊߟߌߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭" },
            { "srd", "ߛߎߙߌߣߊߡߍߛ ߘߟߊ" },
            { "ssp", "ߛߎ߬ߘߊ߲߬ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬" },
            { "std", "ߛߊߏߕߏߡߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߓߙߊߛ ( ߁߉߇߇– ߂߀߁߇ )" },
            { "stn", "ߛߊߏߕߏߡߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߓߙߊߛ" },
            { "syp", "ߛߌ߯ߙߌ߫ ߔߐߣߌ߬" },
            { "szl", "ߛߑߥߊߕߣߞߊ ߟߎ߬ ߟߌߟߊ߲ߖ߭ߋߣߌߛ" },
            { "thb", "ߕߊߦߌߘߎ߯ ߓߊߘ" },
            { "tjs", "ߕߊߖߞߌߛߑߕߊ߲߫ ߛߡߏߣߌ" },
            { "tmt", "ߕߎߙߑߞߌߡߋߣߌߛߑߕߊ߲߫ ߡߣߊ߫ ߞߎߘߊ" },
            { "tnd", "ߕߎߣߛߌߞߊ ߟߎ߬ ߟߊ߫ ߘߌ߬ߣߊ߯ߙ" },
            { "top", "ߕߏ߲ߜ߭ߊ߲߫ ߓߊ߲ߜ߭ߊ߫" },
            { "try", "ߕߎߙߑߞߌ߫ ߟߌߙߊ߬" },
            { "ttd", "ߕߙߌߘߊߘ ߣߌ߫ ߕߏߓߊߜ߭ߏ߫ ߘߟߊ" },
            { "twd", "ߕߊߦߌߥߊ߲߫ ߘߟߊ߫ ߞߎߘߊ" },
            { "tzs", "ߕߊ߲ߖ߭ߊ߯ߣߌߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭" },
            { "uah", "ߌߞߑߙߍߣ ߤߙߌߝ߭ߣߌߦߊߛ" },
            { "ugs", "ߎߜ߭ߊ߲ߘߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭ ( ߁߉߆߆–߁߉߈߇ )" },
            { "ugx", "ߎߜ߭ߊ߲ߘߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭" },
            { "usd", "ߊߡߋߙߌߞߌ߬߬ ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲ ߘߟߊ" },
            { "uyu", "ߎ߳ߜ߭ߋߦߌ߫ ߔߋߛߏ" },
            { "uzs", "ߎߗ߭ߑߓߋߞߌߛߑߕߊ߲߫ ߛߎߡ" },
            { "ves", "ߝ߭ߣߋߗ߭ߎߦߋߟߊ߫ ߓߏߟߌߝ߭ߊߙ" },
            { "vnd", "ߝ߭ߌߦߍߕߑߣߊߡ ߘߐ߲ߜ߭" },
            { "vuv", "ߝ߭ߊߣߎߦߊߕߎ߫ ߝ߭ߊߕߎ" },
            { "wst", "ߛߊߡߏߥߊ߲߫ ߕߟߊ" },
            { "xaf", "ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߊ߲ߓߊ߲ ߠߎ߬ ߝߊߙߊ߲߫ ߛߍߝߊ" },
            { "xcd", "ߛߍߕ ߟߎߛߌߦߊ߫" },
            { "xof", "ߝߊߙߊ߲߫ ߛߍߝߊ" },
            { "xpf", "ߝߑߙߊ߲߫ ߛߍߝߊ" },
            { "xxx", "ߝߊ߬ߘߊ߲߬ߞߊ߫ ߟߐ߲ߓߊߟߌ" },
            { "yer", "ߦߡߊߣߌ߲߫ ߙߌ߬ߦߊߟ" },
            { "zar", "ߥߙߏ߬ߘߎ߮ ߝߘߊ߬ߝߌ߲߬ߠߞߊ ߟߎ߬ ߟߊ߫ ߙߊ߲ߘ" },
            { "zmk", "ߖ߭ߊ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߛߊ ( ߁߉߆߈–߂߀߁߂ )" },
            { "zmw", "ߖ߭ߊ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߛߊ" },
            { "zrn", "ߖ߭ߊ߬ߦߌ߬ߞߊ ߟߎ߬ ߟߊ߫ ߖ߭ߊ߬ߦߌߙ ( ߁߉߉߃–߁߉߉߈ )" },
            { "zrz", "ߖ߭ߊߦߙߌߞߊ ߟߎ߫ ߟߊ߫ ߖ߭ߊ߬ߦߌߙ ( ߁߉߇߁–߁߉߉߃ )" },
            { "zwd", "ߖߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ (߁߉߈߀–߂߀߀߈ )" },
            { "zwl", "ߖ߭ߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ ( ߂߀߀߉ )" },
            { "zwr", "ߖ߭ߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ ( ߂߀߀߈ )" },
        };
        return data;
    }
}
