/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage.decompressor;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jdk.internal.jimage.decompressor.CompressedResourceHeader;
import jdk.internal.jimage.decompressor.ResourceDecompressor;
import jdk.internal.jimage.decompressor.ResourceDecompressorRepository;

public final class Decompressor {
    private final Map<Integer, ResourceDecompressor> pluginsCache = new HashMap<Integer, ResourceDecompressor>();

    public byte[] decompressResource(ByteOrder order, ResourceDecompressor.StringsProvider provider, byte[] content) throws IOException {
        CompressedResourceHeader header;
        Objects.requireNonNull(order);
        Objects.requireNonNull(provider);
        Objects.requireNonNull(content);
        do {
            if ((header = CompressedResourceHeader.readFromResource(order, content)) == null) continue;
            ResourceDecompressor decompressor = this.pluginsCache.get(header.getDecompressorNameOffset());
            if (decompressor == null) {
                String pluginName = provider.getString(header.getDecompressorNameOffset());
                if (pluginName == null) {
                    throw new IOException("Plugin name not found");
                }
                decompressor = ResourceDecompressorRepository.newResourceDecompressor(pluginName);
                if (decompressor == null) {
                    throw new IOException("Plugin not found: " + pluginName);
                }
                this.pluginsCache.put(header.getDecompressorNameOffset(), decompressor);
            }
            try {
                content = decompressor.decompress(provider, content, CompressedResourceHeader.getSize(), header.getUncompressedSize());
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        } while (header != null);
        return content;
    }
}

