/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.publisher.CloudNotificationPublisher;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerContext;
import org.eclipse.kura.cloudconnection.request.RequestHandlerContextConstants;
import org.eclipse.kura.cloudconnection.request.RequestHandlerMessageConstants;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.deployment.CloudDeploymentHandlerOptions;
import org.eclipse.kura.core.deployment.CloudDeploymentHandlerV2Options;
import org.eclipse.kura.core.deployment.DeploymentPackageOptions;
import org.eclipse.kura.core.deployment.DownloadStatus;
import org.eclipse.kura.core.deployment.download.DeploymentPackageDownloadOptions;
import org.eclipse.kura.core.deployment.download.DownloadCountingOutputStream;
import org.eclipse.kura.core.deployment.download.DownloadFileUtilities;
import org.eclipse.kura.core.deployment.download.impl.DownloadImpl;
import org.eclipse.kura.core.deployment.hook.DeploymentHookManager;
import org.eclipse.kura.core.deployment.install.DeploymentPackageInstallOptions;
import org.eclipse.kura.core.deployment.install.InstallImpl;
import org.eclipse.kura.core.deployment.uninstall.DeploymentPackageUninstallOptions;
import org.eclipse.kura.core.deployment.uninstall.UninstallImpl;
import org.eclipse.kura.core.deployment.xml.XmlBundle;
import org.eclipse.kura.core.deployment.xml.XmlBundleInfo;
import org.eclipse.kura.core.deployment.xml.XmlBundles;
import org.eclipse.kura.core.deployment.xml.XmlDeploymentPackage;
import org.eclipse.kura.core.deployment.xml.XmlDeploymentPackages;
import org.eclipse.kura.data.DataTransportService;
import org.eclipse.kura.deployment.hook.DeploymentHook;
import org.eclipse.kura.marshalling.Marshaller;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.eclipse.kura.ssl.SslManagerService;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.util.service.ServiceUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudDeploymentHandlerV2
implements ConfigurableComponent,
RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(CloudDeploymentHandlerV2.class);
    public static final String APP_ID = "DEPLOY-V2";
    public static final String RESOURCE_PACKAGES = "packages";
    public static final String RESOURCE_BUNDLES = "bundles";
    public static final String RESOURCE_DOWNLOAD = "download";
    public static final String RESOURCE_INSTALL = "install";
    public static final String RESOURCE_UNINSTALL = "uninstall";
    public static final String RESOURCE_CANCEL = "cancel";
    public static final String RESOURCE_START = "start";
    public static final String RESOURCE_STOP = "stop";
    public static final String METRIC_DOWNLOAD_STATUS = "download.status";
    public static final String METRIC_REQUESTER_CLIENT_ID = "requester.client.id";
    private static final String MESSAGE_TYPE_KEY = "messageType";
    private static final String REQUESTOR_CLIENT_ID_KEY = "requestorClientId";
    private static final String APP_ID_KEY = "appId";
    private static String pendingPackageUrl = null;
    private static DownloadImpl downloadImplementation;
    private static UninstallImpl uninstallImplementation;
    public static InstallImpl installImplementation;
    private CloudDeploymentHandlerV2Options componentOptions;
    private SslManagerService sslManagerService;
    private DeploymentAdmin deploymentAdmin;
    private SystemService systemService;
    private DeploymentHookManager deploymentHookManager;
    private static ExecutorService executor;
    private Future<?> downloaderFuture;
    private Future<?> installerFuture;
    private BundleContext bundleContext;
    private DataTransportService dataTransportService;
    private DeploymentPackageDownloadOptions downloadOptions;
    private boolean isInstalling = false;
    private DeploymentPackageInstallOptions installOptions;
    private String pendingUninstPackageName;
    private String installVerificationDir;
    private CloudNotificationPublisher cloudNotificationPublisher;
    private ServiceTrackerCustomizer<CloudNotificationPublisher, CloudNotificationPublisher> cloudPublisherTrackerCustomizer;
    private ServiceTracker<CloudNotificationPublisher, CloudNotificationPublisher> cloudPublisherTracker;

    static {
        executor = Executors.newSingleThreadExecutor();
    }

    public void setSslManagerService(SslManagerService sslManagerService) {
        this.sslManagerService = sslManagerService;
    }

    public void unsetSslManagerService(SslManagerService sslManagerService) {
        this.sslManagerService = null;
    }

    protected void setDeploymentAdmin(DeploymentAdmin deploymentAdmin) {
        this.deploymentAdmin = deploymentAdmin;
    }

    protected void unsetDeploymentAdmin(DeploymentAdmin deploymentAdmin) {
        this.deploymentAdmin = null;
    }

    public void setDataTransportService(DataTransportService dataTransportService) {
        this.dataTransportService = dataTransportService;
    }

    public void unsetDataTransportService(DataTransportService dataTransportService) {
        this.dataTransportService = null;
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.systemService = null;
    }

    public void setDeploymentHookManager(DeploymentHookManager deploymentHookManager) {
        this.deploymentHookManager = deploymentHookManager;
    }

    public void unsetDeploymentHookManager(DeploymentHookManager deploymentHookManager) {
        this.deploymentHookManager = null;
    }

    public void setRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.registerRequestHandler(APP_ID, (RequestHandler)this);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register cloudlet {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    public void unsetRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.unregister(APP_ID);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register cloudlet {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.info("Cloud Deployment v2 is starting");
        this.bundleContext = componentContext.getBundleContext();
        CloudDeploymentHandlerOptions options = new CloudDeploymentHandlerOptions(this.systemService.getProperties());
        String dpaConfPath = options.getDpaConfigurationFilePath();
        String packagesPath = options.getPackagesPath();
        String kuraDataDir = options.getKuraDataDir();
        installImplementation = new InstallImpl(this, kuraDataDir);
        installImplementation.setPackagesPath(packagesPath);
        installImplementation.setDpaConfPath(dpaConfPath);
        installImplementation.setDeploymentAdmin(this.deploymentAdmin);
        this.cloudPublisherTrackerCustomizer = new CloudNotificationPublisherTrackerCustomizer();
        this.initCloudPublisherTracking();
        this.updated(properties);
    }

    protected void updated(Map<String, Object> properties) {
        this.componentOptions = new CloudDeploymentHandlerV2Options(properties);
        Properties associations = new Properties();
        try {
            associations.load(new StringReader(this.componentOptions.getHookAssociations()));
        }
        catch (Exception e) {
            logger.warn("failed to parse hook associations from configuration", (Throwable)e);
        }
        this.deploymentHookManager.updateAssociations(associations);
        this.installVerificationDir = installImplementation.getVerificationDirectory();
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("Bundle {} is deactivating!", (Object)APP_ID);
        if (this.downloaderFuture != null) {
            this.downloaderFuture.cancel(true);
        }
        if (this.installerFuture != null) {
            this.installerFuture.cancel(true);
        }
        if (Objects.nonNull(this.cloudPublisherTracker)) {
            this.cloudPublisherTracker.close();
        }
        this.bundleContext = null;
    }

    public void publishMessage(DeploymentPackageOptions options, KuraPayload messagePayload, String messageType) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(APP_ID_KEY, APP_ID);
            properties.put(MESSAGE_TYPE_KEY, messageType);
            properties.put(REQUESTOR_CLIENT_ID_KEY, options.getRequestClientId());
            KuraMessage message = new KuraMessage(messagePayload, properties);
            CloudNotificationPublisher notificationPublisher = options.getNotificationPublisher();
            if (notificationPublisher != null) {
                notificationPublisher.publish(message);
            }
        }
        catch (KuraException e) {
            logger.error("Error publishing response for command {}", (Object)messageType, (Object)e);
        }
    }

    public KuraMessage doGet(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        KuraPayload resPayload;
        Object requestObject = reqMessage.getProperties().get(RequestHandlerMessageConstants.ARGS_KEY.value());
        if (!(requestObject instanceof List)) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        List resources = (List)requestObject;
        if (resources.isEmpty()) {
            logger.error("Bad request topic: {}", (Object)resources);
            logger.error("Expected one resource but found none");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (((String)resources.get(0)).equals(RESOURCE_DOWNLOAD)) {
            resPayload = this.doGetDownload();
        } else if (((String)resources.get(0)).equals(RESOURCE_INSTALL)) {
            resPayload = this.doGetInstall();
        } else if (((String)resources.get(0)).equals(RESOURCE_PACKAGES)) {
            resPayload = this.doGetPackages();
        } else if (((String)resources.get(0)).equals(RESOURCE_BUNDLES)) {
            resPayload = this.doGetBundles();
        } else {
            logger.error("Bad request topic: {}", (Object)resources);
            logger.error("Cannot find resource with name: {}", resources.get(0));
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        return new KuraMessage(resPayload);
    }

    public KuraMessage doExec(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        KuraPayload resPayload;
        Object requestObject = reqMessage.getProperties().get(RequestHandlerMessageConstants.ARGS_KEY.value());
        if (!(requestObject instanceof List)) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        List resources = (List)requestObject;
        if (resources.isEmpty()) {
            logger.error("Bad request topic: {}", (Object)resources);
            logger.error("Expected one resource but found none");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        KuraPayload reqPayload = reqMessage.getPayload();
        if (((String)resources.get(0)).equals(RESOURCE_DOWNLOAD)) {
            resPayload = this.doExecDownload(requestContext, reqPayload);
        } else if (((String)resources.get(0)).equals(RESOURCE_INSTALL)) {
            resPayload = this.doExecInstall(requestContext, reqPayload);
        } else if (((String)resources.get(0)).equals(RESOURCE_UNINSTALL)) {
            resPayload = this.doExecUninstall(requestContext, reqPayload);
        } else if (((String)resources.get(0)).equals(RESOURCE_START)) {
            String bundleId = resources.size() >= 2 ? (String)resources.get(1) : null;
            resPayload = this.doExecStartStopBundle(true, bundleId);
        } else if (((String)resources.get(0)).equals(RESOURCE_STOP)) {
            String bundleId = resources.size() >= 2 ? (String)resources.get(1) : null;
            resPayload = this.doExecStartStopBundle(false, bundleId);
        } else {
            logger.error("Bad request topic: {}", (Object)resources);
            logger.error("Cannot find resource with name: {}", resources.get(0));
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        return new KuraMessage(resPayload);
    }

    public KuraMessage doDel(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        Object requestObject = reqMessage.getProperties().get(RequestHandlerMessageConstants.ARGS_KEY.value());
        if (!(requestObject instanceof List)) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        List resources = (List)requestObject;
        if (resources.isEmpty()) {
            logger.error("Bad request topic: {}", (Object)resources);
            logger.error("Expected one resource but found none");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (!((String)resources.get(0)).equals(RESOURCE_DOWNLOAD)) {
            logger.error("Bad request topic: {}", (Object)resources);
            logger.error("Cannot find resource with name: {}", resources.get(0));
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        KuraPayload resPayload = this.doDelDownload();
        return new KuraMessage(resPayload);
    }

    protected DownloadImpl createDownloadImpl(DeploymentPackageDownloadOptions options) {
        DownloadImpl downloadImplementation = new DownloadImpl(options, this);
        return downloadImplementation;
    }

    protected UninstallImpl createUninstallImpl() {
        return new UninstallImpl(this, this.deploymentAdmin);
    }

    protected File getDpDownloadFile(DeploymentPackageInstallOptions options) throws IOException {
        return DownloadFileUtilities.getDpDownloadFile(options);
    }

    private void initCloudPublisherTracking() {
        String filterString = String.format("(%s=%s)", "objectClass", CloudNotificationPublisher.class.getName());
        Filter filter = null;
        try {
            filter = this.bundleContext.createFilter(filterString);
        }
        catch (InvalidSyntaxException e) {
            logger.error("Filter setup exception ", (Throwable)e);
        }
        this.cloudPublisherTracker = new ServiceTracker(this.bundleContext, filter, this.cloudPublisherTrackerCustomizer);
        this.cloudPublisherTracker.open();
    }

    private KuraPayload doDelDownload() throws KuraException {
        try {
            DownloadCountingOutputStream downloadHelper = downloadImplementation.getDownloadHelper();
            if (downloadHelper != null) {
                downloadHelper.cancelDownload();
                downloadImplementation.deleteDownloadedFile();
            }
        }
        catch (Exception ex) {
            String errMsg = "Error cancelling download!";
            logger.warn(errMsg, (Throwable)ex);
            throw new KuraException(KuraErrorCode.PROCESS_EXECUTION_ERROR);
        }
        return new KuraResponsePayload(200);
    }

    private void checkHook(DeploymentPackageInstallOptions options) {
        if (options.getRequestType() != null && options.getDeploymentHook() == null) {
            throw new IllegalStateException("No DeploymentHook is currently associated to request type " + options.getRequestType() + ", aborting operation");
        }
    }

    private KuraPayload doExecDownload(RequestHandlerContext requestContext, KuraPayload request) throws KuraException {
        DeploymentPackageDownloadOptions options;
        KuraResponsePayload response = new KuraResponsePayload(200);
        try {
            options = new DeploymentPackageDownloadOptions(request, this.deploymentHookManager, this.componentOptions.getDownloadsDirectory());
            options.setClientId(this.dataTransportService.getClientId());
        }
        catch (Exception exception) {
            logger.info("Malformed download request!");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        this.downloadOptions = options;
        try {
            this.checkHook(this.downloadOptions);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage());
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (pendingPackageUrl != null) {
            logger.info("Another request seems for the same URL is pending: {}.", (Object)pendingPackageUrl);
            response.setResponseCode(500);
            response.setTimestamp(new Date());
            response.addMetric(METRIC_DOWNLOAD_STATUS, (Object)DownloadStatus.IN_PROGRESS.getStatusString());
            try {
                response.setBody("Another resource is already in download".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            return response;
        }
        downloadImplementation = this.createDownloadImpl(options);
        boolean alreadyDownloaded = false;
        try {
            alreadyDownloaded = downloadImplementation.isAlreadyDownloaded();
        }
        catch (KuraException ex) {
            response.setResponseCode(500);
            response.setException((Throwable)ex);
            response.setTimestamp(new Date());
            try {
                response.setBody("Error checking download status".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            return response;
        }
        logger.info("About to download and install package at URL {}", (Object)options.getDeployUri());
        try {
            DeploymentHook deploymentHook = options.getDeploymentHook();
            if (deploymentHook != null) {
                try {
                    deploymentHook.preDownload(options.getHookRequestContext(), options.getHookProperties());
                }
                catch (Exception e) {
                    logger.warn("DeploymentHook cancelled operation at preDownload phase");
                    throw e;
                }
            }
            pendingPackageUrl = options.getDeployUri();
            downloadImplementation.setSslManager(this.sslManagerService);
            downloadImplementation.setAlreadyDownloadedFlag(alreadyDownloaded);
            downloadImplementation.setVerificationDirectory(this.installVerificationDir);
            Map requestProperties = requestContext.getContextProperties();
            String notificationPublisherPid = (String)requestProperties.get(RequestHandlerContextConstants.NOTIFICATION_PUBLISHER_PID.name());
            options.setNotificationPublisher(requestContext.getNotificationPublisher());
            options.setNotificationPublisherPid(notificationPublisherPid);
            logger.info("Downloading package from URL: {}", (Object)options.getDeployUri());
            this.downloaderFuture = executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            downloadImplementation.downloadDeploymentPackageInternal();
                        }
                        catch (KuraException e) {
                            logger.warn("deployment package download failed", (Throwable)e);
                            try {
                                File dpFile = CloudDeploymentHandlerV2.this.getDpDownloadFile(options);
                                if (dpFile != null) {
                                    dpFile.delete();
                                }
                            }
                            catch (IOException iOException) {}
                            pendingPackageUrl = null;
                        }
                    }
                    finally {
                        pendingPackageUrl = null;
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("Failed to download and install package at URL {}: {}", (Object)options.getDeployUri(), (Object)e);
            pendingPackageUrl = null;
            throw new KuraException(KuraErrorCode.PROCESS_EXECUTION_ERROR);
        }
        return response;
    }

    private KuraPayload doExecInstall(RequestHandlerContext requestContext, KuraPayload request) throws KuraException {
        DeploymentPackageInstallOptions options;
        try {
            options = new DeploymentPackageInstallOptions(request, this.deploymentHookManager, this.componentOptions.getDownloadsDirectory());
            options.setClientId(this.dataTransportService.getClientId());
        }
        catch (Exception exception) {
            logger.error("Malformed install request!");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        this.installOptions = options;
        try {
            this.checkHook(this.installOptions);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage());
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        boolean alreadyDownloaded = false;
        try {
            alreadyDownloaded = downloadImplementation.isAlreadyDownloaded();
        }
        catch (KuraException kuraException) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (alreadyDownloaded && !this.isInstalling) {
            try {
                DeploymentHook hook = options.getDeploymentHook();
                if (hook != null) {
                    try {
                        hook.postDownload(options.getHookRequestContext(), options.getHookProperties());
                    }
                    catch (Exception e) {
                        logger.warn("DeploymentHook cancelled operation at postDownload phase");
                        throw e;
                    }
                }
                this.isInstalling = true;
                final File dpFile = this.getDpDownloadFile(options);
                installImplementation.setOptions(options);
                Map requestProperties = requestContext.getContextProperties();
                String notificationPublisherPid = (String)requestProperties.get(RequestHandlerContextConstants.NOTIFICATION_PUBLISHER_PID.name());
                options.setNotificationPublisher(requestContext.getNotificationPublisher());
                options.setNotificationPublisherPid(notificationPublisherPid);
                this.installerFuture = executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                CloudDeploymentHandlerV2.this.installDownloadedFile(dpFile, CloudDeploymentHandlerV2.this.installOptions);
                            }
                            catch (KuraException kuraException) {
                                logger.error("Impossible to send an exception message to the cloud platform");
                                if (dpFile != null) {
                                    dpFile.delete();
                                }
                                CloudDeploymentHandlerV2.this.installOptions = null;
                                CloudDeploymentHandlerV2.this.isInstalling = false;
                            }
                        }
                        finally {
                            CloudDeploymentHandlerV2.this.installOptions = null;
                            CloudDeploymentHandlerV2.this.isInstalling = false;
                        }
                    }
                });
            }
            catch (Exception exception) {
                throw new KuraException(KuraErrorCode.BAD_REQUEST);
            }
        }
        throw new KuraException(KuraErrorCode.BAD_REQUEST);
        return new KuraResponsePayload(200);
    }

    private KuraPayload doExecUninstall(RequestHandlerContext requestContext, KuraPayload request) throws KuraException {
        DeploymentPackageUninstallOptions options;
        try {
            options = new DeploymentPackageUninstallOptions(request);
            options.setClientId(this.dataTransportService.getClientId());
        }
        catch (Exception exception) {
            logger.error("Malformed uninstall request!");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        final String packageName = options.getDpName();
        if (!this.isInstalling && this.pendingUninstPackageName != null) {
            logger.info("Another request seems still pending: {}. Checking if stale...", (Object)this.pendingUninstPackageName);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        logger.info("About to uninstall package {}", (Object)packageName);
        try {
            try {
                this.isInstalling = true;
                this.pendingUninstPackageName = packageName;
                uninstallImplementation = this.createUninstallImpl();
                Map requestProperties = requestContext.getContextProperties();
                String notificationPublisherPid = (String)requestProperties.get(RequestHandlerContextConstants.NOTIFICATION_PUBLISHER_PID.name());
                options.setNotificationPublisher(requestContext.getNotificationPublisher());
                options.setNotificationPublisherPid(notificationPublisherPid);
                logger.info("Uninstalling package...");
                this.installerFuture = executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                uninstallImplementation.uninstaller(options, packageName);
                            }
                            catch (Exception e) {
                                try {
                                    uninstallImplementation.uninstallFailedAsync(options, packageName, e);
                                }
                                catch (KuraException kuraException) {}
                                CloudDeploymentHandlerV2.this.installOptions = null;
                                CloudDeploymentHandlerV2.this.isInstalling = false;
                            }
                        }
                        finally {
                            CloudDeploymentHandlerV2.this.installOptions = null;
                            CloudDeploymentHandlerV2.this.isInstalling = false;
                        }
                    }
                });
            }
            catch (Exception e) {
                logger.error("Failed to uninstall package {}: {}", (Object)packageName, (Object)e);
                throw new KuraException(KuraErrorCode.BAD_REQUEST);
            }
        }
        finally {
            this.isInstalling = false;
            this.pendingUninstPackageName = null;
        }
        return new KuraResponsePayload(200);
    }

    private KuraPayload doExecStartStopBundle(boolean start, String bundleId) throws KuraException {
        if (bundleId == null) {
            logger.info("EXEC start/stop bundle: null bundle ID");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        Long id = null;
        try {
            id = Long.valueOf(bundleId);
        }
        catch (NumberFormatException e) {
            logger.error("EXEC start/stop bundle: bad bundle ID format: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (id != null) {
            logger.info("Executing command {}", (Object)(start ? RESOURCE_START : RESOURCE_STOP));
            Bundle bundle = this.bundleContext.getBundle(id.longValue());
            if (bundle == null) {
                logger.error("Bundle ID {} not found", (Object)id);
                throw new KuraException(KuraErrorCode.BAD_REQUEST);
            }
            try {
                if (start) {
                    bundle.start();
                } else {
                    bundle.stop();
                }
                logger.info("{} bundle ID {} ({})", new Object[]{start ? "Started" : "Stopped", id, bundle.getSymbolicName()});
            }
            catch (BundleException e) {
                logger.error("Failed to {} bundle {}: {}", new Object[]{start ? RESOURCE_START : RESOURCE_STOP, id, e});
                throw new KuraException(KuraErrorCode.BAD_REQUEST);
            }
        }
        return new KuraResponsePayload(200);
    }

    private KuraPayload doGetInstall() {
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        if (this.isInstalling) {
            installImplementation.installInProgressSyncMessage(respPayload);
        } else {
            installImplementation.installIdleSyncMessage(respPayload);
        }
        return respPayload;
    }

    private KuraPayload doGetDownload() {
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        if (pendingPackageUrl != null) {
            DownloadCountingOutputStream downloadHelper = downloadImplementation.getDownloadHelper();
            DownloadImpl.downloadInProgressSyncMessage(respPayload, downloadHelper, this.downloadOptions);
        } else {
            DownloadImpl.downloadAlreadyDoneSyncMessage(respPayload);
        }
        return respPayload;
    }

    private KuraPayload doGetPackages() {
        DeploymentPackage[] dps = this.deploymentAdmin.listDeploymentPackages();
        XmlDeploymentPackages xdps = new XmlDeploymentPackages();
        XmlDeploymentPackage[] axdp = new XmlDeploymentPackage[dps.length];
        int i = 0;
        while (i < dps.length) {
            DeploymentPackage dp = dps[i];
            XmlDeploymentPackage xdp = new XmlDeploymentPackage();
            xdp.setName(dp.getName());
            xdp.setVersion(dp.getVersion().toString());
            BundleInfo[] bis = dp.getBundleInfos();
            XmlBundleInfo[] axbi = new XmlBundleInfo[bis.length];
            int j = 0;
            while (j < bis.length) {
                BundleInfo bi = bis[j];
                XmlBundleInfo xbi = new XmlBundleInfo();
                xbi.setName(bi.getSymbolicName());
                xbi.setVersion(bi.getVersion().toString());
                axbi[j] = xbi;
                ++j;
            }
            xdp.setBundleInfos(axbi);
            axdp[i] = xdp;
            ++i;
        }
        xdps.setDeploymentPackages(axdp);
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        try {
            String s = this.marshal(xdps);
            respPayload.setTimestamp(new Date());
            respPayload.setBody(s.getBytes("UTF-8"));
        }
        catch (Exception e) {
            logger.error("Error getting resource {}: {}", (Object)RESOURCE_PACKAGES, (Object)e);
        }
        return respPayload;
    }

    private KuraPayload doGetBundles() {
        Bundle[] bundles = this.bundleContext.getBundles();
        XmlBundles xmlBundles = new XmlBundles();
        XmlBundle[] axb = new XmlBundle[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            XmlBundle xmlBundle = new XmlBundle();
            xmlBundle.setName(bundle.getSymbolicName());
            xmlBundle.setVersion(bundle.getVersion().toString());
            xmlBundle.setId(bundle.getBundleId());
            int state = bundle.getState();
            switch (state) {
                case 1: {
                    xmlBundle.setState("UNINSTALLED");
                    break;
                }
                case 2: {
                    xmlBundle.setState("INSTALLED");
                    break;
                }
                case 4: {
                    xmlBundle.setState("RESOLVED");
                    break;
                }
                case 8: {
                    xmlBundle.setState("STARTING");
                    break;
                }
                case 16: {
                    xmlBundle.setState("STOPPING");
                    break;
                }
                case 32: {
                    xmlBundle.setState("ACTIVE");
                    break;
                }
                default: {
                    xmlBundle.setState(String.valueOf(state));
                }
            }
            axb[i] = xmlBundle;
            ++i;
        }
        xmlBundles.setBundles(axb);
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        try {
            String s = this.marshal(xmlBundles);
            respPayload.setTimestamp(new Date());
            respPayload.setBody(s.getBytes("UTF-8"));
        }
        catch (Exception e) {
            logger.error("Error getting resource {}", (Object)RESOURCE_BUNDLES, (Object)e);
        }
        return respPayload;
    }

    public void installDownloadedFile(File dpFile, DeploymentPackageInstallOptions options) throws KuraException {
        try {
            if (options.getSystemUpdate().booleanValue()) {
                installImplementation.installSh(options, dpFile);
            } else {
                installImplementation.installDp(options, dpFile);
            }
            DeploymentHook hook = options.getDeploymentHook();
            if (hook != null) {
                hook.postInstall(options.getHookRequestContext(), options.getHookProperties());
            }
        }
        catch (Exception e) {
            logger.info("Install exception");
            installImplementation.installFailedAsync(options, dpFile.getName(), e);
        }
    }

    private ServiceReference<Marshaller>[] getXmlMarshallers() {
        String filterString = String.format("(&(kura.service.pid=%s))", "org.eclipse.kura.xml.marshaller.unmarshaller.provider");
        return ServiceUtil.getServiceReferences((BundleContext)this.bundleContext, Marshaller.class, (String)filterString);
    }

    private void ungetServiceReferences(ServiceReference<?>[] refs) {
        ServiceUtil.ungetServiceReferences((BundleContext)this.bundleContext, refs);
    }

    protected String marshal(Object object) {
        String result = null;
        ServiceReference<Marshaller>[] marshallerSRs = this.getXmlMarshallers();
        try {
            try {
                ServiceReference<Marshaller>[] serviceReferenceArray = marshallerSRs;
                int n = marshallerSRs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference<Marshaller> marshallerSR = serviceReferenceArray[n2];
                    Marshaller marshaller = (Marshaller)this.bundleContext.getService(marshallerSR);
                    result = marshaller.marshal(object);
                    if (result != null) {
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to marshal configuration.");
                this.ungetServiceReferences(marshallerSRs);
            }
        }
        finally {
            this.ungetServiceReferences(marshallerSRs);
        }
        return result;
    }

    private final class CloudNotificationPublisherTrackerCustomizer
    implements ServiceTrackerCustomizer<CloudNotificationPublisher, CloudNotificationPublisher> {
        private CloudNotificationPublisherTrackerCustomizer() {
        }

        public CloudNotificationPublisher addingService(ServiceReference<CloudNotificationPublisher> reference) {
            CloudDeploymentHandlerV2.this.cloudNotificationPublisher = (CloudNotificationPublisher)CloudDeploymentHandlerV2.this.bundleContext.getService(reference);
            String notificationPublisherPid = (String)reference.getProperty("kura.service.pid");
            installImplementation.sendInstallConfirmations(notificationPublisherPid, CloudDeploymentHandlerV2.this.cloudNotificationPublisher);
            return CloudDeploymentHandlerV2.this.cloudNotificationPublisher;
        }

        public void modifiedService(ServiceReference<CloudNotificationPublisher> reference, CloudNotificationPublisher service) {
        }

        public void removedService(ServiceReference<CloudNotificationPublisher> reference, CloudNotificationPublisher service) {
            CloudDeploymentHandlerV2.this.cloudNotificationPublisher = null;
        }
    }
}

