/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.cloud;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.eclipse.kura.camel.cloud.KuraCloudEndpoint;
import org.eclipse.kura.camel.internal.cloud.CloudClientCache;
import org.eclipse.kura.camel.internal.cloud.CloudClientCacheImpl;
import org.eclipse.kura.camel.internal.utils.KuraServiceFactory;
import org.eclipse.kura.cloud.CloudService;

public class KuraCloudComponent
extends DefaultComponent {
    public static final String DEFAULT_NAME = "kura-cloud";
    private CloudService cloudService;
    private CloudClientCache cache;

    public KuraCloudComponent() {
    }

    public KuraCloudComponent(CamelContext context) {
        super(context);
    }

    public KuraCloudComponent(CamelContext context, CloudService cloudService) {
        super(context);
        this.cloudService = cloudService;
    }

    protected void doStart() throws Exception {
        CloudService cloudService = this.lookupCloudService();
        if (cloudService == null) {
            throw new IllegalStateException("'cloudService' is not set and not found in Camel context service registry");
        }
        this.cache = new CloudClientCacheImpl(cloudService);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.cache != null) {
            this.cache.close();
            this.cache = null;
        }
    }

    protected Endpoint createEndpoint(String uri, String remain, Map<String, Object> parameters) throws Exception {
        KuraCloudEndpoint kuraCloudEndpoint = new KuraCloudEndpoint(uri, this, this.cache);
        String[] res = remain.split("/", 2);
        if (res.length < 2) {
            throw new IllegalArgumentException("Wrong kura-cloud URI format. Should be: kura-cloud:app/topic");
        }
        parameters.put("applicationId", res[0]);
        parameters.put("topic", res[1]);
        this.setProperties((Object)kuraCloudEndpoint, parameters);
        return kuraCloudEndpoint;
    }

    protected CloudService lookupCloudService() {
        if (this.cloudService == null) {
            this.cloudService = KuraServiceFactory.retrieveService(CloudService.class, this.getCamelContext().getRegistry());
        }
        return this.cloudService;
    }
}

