/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth;

import org.eclipse.kura.bluetooth.BluetoothConnector;
import org.eclipse.kura.bluetooth.BluetoothDevice;
import org.eclipse.kura.bluetooth.BluetoothGatt;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.linux.bluetooth.BluetoothServiceImpl;
import org.eclipse.kura.linux.bluetooth.le.BluetoothGattImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class BluetoothDeviceImpl
implements BluetoothDevice {
    public static final int DEVICE_TYPE_DUAL = 3;
    public static final int DEVICE_TYPE_LE = 2;
    public static final int DEVICE_TYPE_UNKNOWN = 0;
    private final String name;
    private final String address;
    private final CommandExecutorService executorService;

    public BluetoothDeviceImpl(String address, String name, CommandExecutorService executorService) {
        this.address = address;
        this.name = name;
        this.executorService = executorService;
    }

    public String getName() {
        return this.name;
    }

    public String getAdress() {
        return this.address;
    }

    public int getType() {
        return 0;
    }

    public BluetoothConnector getBluetoothConnector() {
        ServiceReference sr;
        BluetoothConnector bluetoothConnector = null;
        BundleContext bundleContext = BluetoothServiceImpl.getBundleContext();
        if (bundleContext != null && (sr = bundleContext.getServiceReference(BluetoothConnector.class)) != null) {
            bluetoothConnector = (BluetoothConnector)bundleContext.getService(sr);
        }
        return bluetoothConnector;
    }

    public BluetoothGatt getBluetoothGatt() {
        return new BluetoothGattImpl(this.address, this.executorService);
    }
}

