/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.submatrix;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.dsm.Group;
import org.eclipse.escet.common.dsm.submatrix.ParentGroupNode;
import org.eclipse.escet.common.dsm.submatrix.SingleParentNode;
import org.eclipse.escet.common.dsm.submatrix.SubNode;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;

public class SubMatrixFunctions {
    private SubMatrixFunctions() {
    }

    public static SubNode[] makeSubNodes(List<Group> prevGroups, BitSet availParentNodes) {
        int subSize = prevGroups.size() + availParentNodes.cardinality();
        SubNode[] subNodes = new SubNode[subSize];
        int subIndex = 0;
        for (Group grp : prevGroups) {
            Assert.check((!availParentNodes.intersects(grp.members) ? 1 : 0) != 0);
            subNodes[subIndex++] = new ParentGroupNode(grp);
        }
        Iterator<Group> iterator = BitSets.iterateTrueBits((BitSet)availParentNodes).iterator();
        while (iterator.hasNext()) {
            int parentNode = (Integer)((Object)iterator.next());
            subNodes[subIndex++] = new SingleParentNode(parentNode);
        }
        Assert.check((subIndex == subSize ? 1 : 0) != 0);
        return subNodes;
    }

    public static RealMatrix fillSubMatrix(RealMatrix parentMatrix, SubNode[] subNodes) {
        int subSize = subNodes.length;
        BlockRealMatrix subMatrix = new BlockRealMatrix(subSize, subSize);
        int si = 0;
        while (si < subSize) {
            int sj = 0;
            while (sj < subSize) {
                if (si == sj) {
                    subMatrix.setEntry(sj, sj, 0.0);
                } else {
                    double total = 0.0;
                    int pi = subNodes[si].firstParentNode(0);
                    while (pi >= 0) {
                        int pj = subNodes[sj].firstParentNode(0);
                        while (pj >= 0) {
                            total += parentMatrix.getEntry(pi, pj);
                            pj = subNodes[sj].firstParentNode(pj + 1);
                        }
                        pi = subNodes[si].firstParentNode(pi + 1);
                    }
                    subMatrix.setEntry(si, sj, total);
                }
                ++sj;
            }
            ++si;
        }
        return subMatrix;
    }

    public static List<Group> convertSubGroups(SubNode[] subNodes, List<BitSet> subSets, Group.GroupType groupType) {
        List groups = Lists.listc((int)subSets.size());
        BitSet usedSubNodes = new BitSet(subNodes.length);
        for (BitSet subSet : subSets) {
            BitSet parentNodes = new BitSet();
            List prevGroups = Lists.list();
            Iterator iterator = BitSets.iterateTrueBits((BitSet)subSet).iterator();
            while (iterator.hasNext()) {
                int subNodeIndex = (Integer)iterator.next();
                Assert.check((!usedSubNodes.get(subNodeIndex) ? 1 : 0) != 0);
                usedSubNodes.set(subNodeIndex);
                Group prevGroup = subNodes[subNodeIndex].getGroup();
                if (prevGroup != null) {
                    prevGroups.add(prevGroup);
                    continue;
                }
                int parentNodeIndex = SubMatrixFunctions.getSingleNode(subNodes[subNodeIndex]);
                parentNodes.set(parentNodeIndex);
            }
            Group newGroup = !parentNodes.isEmpty() ? new Group(groupType, parentNodes, prevGroups) : new Group(groupType, null, prevGroups);
            groups.add(newGroup);
        }
        int subNodeIndex = 0;
        while (subNodeIndex < subNodes.length) {
            Group prevGroup;
            if (!usedSubNodes.get(subNodeIndex) && (prevGroup = subNodes[subNodeIndex].getGroup()) != null) {
                groups.add(prevGroup);
            }
            ++subNodeIndex;
        }
        return groups;
    }

    public static BitSet computeAvailNodes(SubNode[] subNodes, List<BitSet> subSets) {
        BitSet groupedNodes = new BitSet();
        for (BitSet subSet : subSets) {
            groupedNodes.or(subSet);
        }
        BitSet newAvail = new BitSet();
        int subIndex = 0;
        while (subIndex < subNodes.length) {
            SubNode subNode;
            if (!groupedNodes.get(subIndex) && (subNode = subNodes[subIndex]).getGroup() == null) {
                int parentNode = SubMatrixFunctions.getSingleNode(subNode);
                newAvail.set(parentNode);
            }
            ++subIndex;
        }
        return newAvail;
    }

    private static int getSingleNode(SubNode subNode) {
        Assert.check((subNode.getGroup() == null ? 1 : 0) != 0);
        int parentNodeIndex = subNode.firstParentNode(0);
        Assert.check((parentNodeIndex >= 0 ? 1 : 0) != 0);
        Assert.check((subNode.firstParentNode(parentNodeIndex + 1) < 0 ? 1 : 0) != 0);
        return parentNodeIndex;
    }
}

