/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.events.KeyEvent;

public class CompartmentCollapseTracker
extends AbstractTool
implements DragTracker {
    private IResizableCompartmentEditPart compartmentEditPart;

    public CompartmentCollapseTracker(IResizableCompartmentEditPart compartmentEditPart) {
        this.compartmentEditPart = compartmentEditPart;
    }

    protected List createOperationSet() {
        ArrayList<IResizableCompartmentEditPart> list = new ArrayList<IResizableCompartmentEditPart>(1);
        list.add(this.compartmentEditPart);
        return list;
    }

    protected Command getCommand(Boolean expand) {
        ChangePropertyValueRequest request = new ChangePropertyValueRequest(DiagramUIMessages.PropertyDescriptorFactory_CollapseCompartment, Properties.ID_COLLAPSED, expand);
        return this.compartmentEditPart.getCommand(request);
    }

    protected String getCommandName() {
        return "Collapse Compartment";
    }

    protected String getDebugName() {
        return "Collapse Compartment Tool";
    }

    protected boolean handleButtonDown(int button) {
        DrawerStyle style;
        View view = this.compartmentEditPart.getNotationView();
        if (view != null && (style = (DrawerStyle)view.getStyle(NotationPackage.eINSTANCE.getDrawerStyle())) != null) {
            Boolean newValue = style.isCollapsed() ? Boolean.FALSE : Boolean.TRUE;
            this.setCurrentCommand(this.getCommand(newValue));
            this.executeCurrentCommand();
            return true;
        }
        return false;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (e.keyCode == 0x1000004 || e.keyCode == 0x1000003) {
            Boolean b = e.keyCode == 0x1000004 ? Boolean.FALSE : Boolean.TRUE;
            this.setCurrentCommand(this.getCommand(b));
            this.executeCurrentCommand();
            return true;
        }
        return false;
    }
}

