/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p2layers;

import org.eclipse.elk.alg.layered.ILayoutPhase;
import org.eclipse.elk.alg.layered.ILayoutPhaseFactory;
import org.eclipse.elk.alg.layered.p2layers.CoffmanGrahamLayerer;
import org.eclipse.elk.alg.layered.p2layers.InteractiveLayerer;
import org.eclipse.elk.alg.layered.p2layers.LongestPathLayerer;
import org.eclipse.elk.alg.layered.p2layers.MinWidthLayerer;
import org.eclipse.elk.alg.layered.p2layers.NetworkSimplexLayerer;
import org.eclipse.elk.alg.layered.p2layers.StretchWidthLayerer;

public enum LayeringStrategy implements ILayoutPhaseFactory
{
    NETWORK_SIMPLEX,
    LONGEST_PATH,
    COFFMAN_GRAHAM,
    INTERACTIVE,
    EXP_STRETCH_WIDTH,
    EXP_MIN_WIDTH;


    @Override
    public ILayoutPhase create() {
        switch (this) {
            case NETWORK_SIMPLEX: {
                return new NetworkSimplexLayerer();
            }
            case LONGEST_PATH: {
                return new LongestPathLayerer();
            }
            case COFFMAN_GRAHAM: {
                return new CoffmanGrahamLayerer();
            }
            case INTERACTIVE: {
                return new InteractiveLayerer();
            }
            case EXP_STRETCH_WIDTH: {
                return new StretchWidthLayerer();
            }
            case EXP_MIN_WIDTH: {
                return new MinWidthLayerer();
            }
        }
        throw new IllegalArgumentException("No implementation is available for the layerer " + this.toString());
    }
}

