/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.runtime.io;

import java.util.List;
import java.util.Locale;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFResourceException;
import org.eclipse.escet.common.emf.ResourceManager;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.typechecker.SemanticProblem;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;
import org.eclipse.escet.common.typechecker.TypeChecker;
import org.eclipse.escet.setext.runtime.DebugMode;
import org.eclipse.escet.setext.runtime.Parser;
import org.eclipse.escet.setext.runtime.SyntaxWarning;

public abstract class BaseReader<T extends BaseReader<?, ?, ?, ?, ?>, TAst, TRslt, TParser extends Parser<TAst>, TChk extends TypeChecker<TAst, TRslt>> {
    private final Class<TRslt> rsltClass;
    private String path;
    private String absPath;
    private boolean debugParser;
    public boolean suppressWarnings;
    private TChk tchecker;

    public BaseReader(Class<TRslt> rsltClass) {
        this.rsltClass = rsltClass;
    }

    protected abstract TParser createParser();

    protected abstract TChk createTypeChecker();

    protected abstract String getLangName();

    protected abstract String getXmiFileExt();

    public String getAbsFilePath() {
        if (this.absPath == null) {
            throw new IllegalStateException();
        }
        return this.absPath;
    }

    public String getAbsDirPath() {
        if (this.absPath == null) {
            throw new IllegalStateException();
        }
        return Paths.getAbsFilePathDir((String)this.absPath);
    }

    public T init() {
        return this.init(InputFileOption.getPath(), Paths.resolve((String)InputFileOption.getPath()), false);
    }

    public T init(String path, String absPath, boolean debugParser) {
        if (this.path != null) {
            throw new IllegalStateException("Already initialized.");
        }
        this.path = path;
        this.absPath = absPath;
        this.debugParser = debugParser;
        return (T)this;
    }

    public TRslt read() {
        if (this.path == null) {
            throw new IllegalStateException("Not yet initialized.");
        }
        String xmiFileExt = this.getXmiFileExt();
        if (xmiFileExt != null && this.path.toLowerCase(Locale.US).endsWith("." + xmiFileExt)) {
            try {
                return (TRslt)ResourceManager.loadObject((String)this.path, this.rsltClass);
            }
            catch (EMFResourceException e) {
                throw new InvalidInputException(Strings.fmt((String)"Failed to load %s file \"%s\".", (Object[])new Object[]{this.getLangName(), this.path}), (Throwable)e);
            }
        }
        DebugMode debugMode = this.debugParser ? DebugMode.PARSER : DebugMode.NONE;
        TParser parser = this.createParser();
        Object ast = ((Parser)parser).parseFile(this.absPath, this.path, debugMode);
        if (!this.suppressWarnings) {
            for (SyntaxWarning warning : ((Parser)parser).getWarnings()) {
                OutputProvider.warn((String)warning.toString());
            }
        }
        return this.tcheck(ast);
    }

    public TRslt read(String fileText) {
        if (this.path == null) {
            throw new IllegalStateException("Not yet initialized.");
        }
        String xmiFileExt = this.getXmiFileExt();
        Assert.check((xmiFileExt == null || !this.path.toLowerCase(Locale.US).endsWith("." + xmiFileExt) ? 1 : 0) != 0);
        DebugMode debugMode = this.debugParser ? DebugMode.PARSER : DebugMode.NONE;
        String src = Strings.fmt((String)"File \"%s\": ", (Object[])new Object[]{this.path});
        TParser parser = this.createParser();
        Object ast = ((Parser)parser).parseString(fileText, this.absPath, src, debugMode);
        if (!this.suppressWarnings) {
            for (SyntaxWarning warning : ((Parser)parser).getWarnings()) {
                OutputProvider.warn((String)warning.toString());
            }
        }
        return this.tcheck(ast);
    }

    private TRslt tcheck(TAst ast) {
        this.tchecker = this.createTypeChecker();
        this.tchecker.setSourceFilePath(this.absPath);
        Object spec = this.tchecker.typeCheck(ast);
        List problems = this.tchecker.getProblems();
        boolean fatal = false;
        for (SemanticProblem problem : problems) {
            if (problem.severity == SemanticProblemSeverity.WARNING) {
                if (this.suppressWarnings) continue;
                OutputProvider.warn((String)problem.toString());
                continue;
            }
            Assert.check((problem.severity == SemanticProblemSeverity.ERROR ? 1 : 0) != 0);
            OutputProvider.err((String)("ERROR: " + problem.toString()));
            fatal = true;
        }
        if (fatal) {
            String msg = Strings.fmt((String)"Failed to load %s file \"%s\": the file has errors.", (Object[])new Object[]{this.getLangName(), this.path});
            throw new InvalidInputException(msg);
        }
        return (TRslt)spec;
    }

    public TChk getTypeChecker() {
        if (this.tchecker == null) {
            throw new IllegalStateException("Type checker not available.");
        }
        return this.tchecker;
    }
}

