/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.core;

import java.io.FileDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.Permission;
import java.util.PropertyPermission;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.ant.internal.core.InternalCoreAntMessages;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class AntSecurityManager
extends SecurityManager {
    private SecurityManager fSecurityManager = null;
    private Thread fRestrictedThread = null;
    private static final PropertyPermission fgPropertyPermission = new PropertyPermission("*", "write");
    private boolean fAllowSettingSystemProperties = true;

    public AntSecurityManager(SecurityManager securityManager, Thread restrictedThread, boolean allowSettingProperties) {
        this.fSecurityManager = securityManager;
        this.fRestrictedThread = restrictedThread;
        this.fAllowSettingSystemProperties = allowSettingProperties;
    }

    public AntSecurityManager(SecurityManager securityManager, Thread restrictedThread) {
        this(securityManager, restrictedThread, true);
    }

    @Override
    public void checkExit(int status) {
        if (Thread.currentThread() == this.fRestrictedThread) {
            throw new AntSecurityException();
        }
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkExit(status);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        if (!this.fAllowSettingSystemProperties && fgPropertyPermission.implies(perm) && this.fRestrictedThread == Thread.currentThread()) {
            throw new AntSecurityException();
        }
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPermission(perm);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkAccept(host, port);
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkAccess(g);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkConnect(host, port);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkCreateClassLoader();
        }
    }

    @Override
    public void checkDelete(String file) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkDelete(file);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkLink(lib);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkListen(port);
        }
    }

    @Override
    @Deprecated
    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (this.fSecurityManager != null) {
            Object host = maddr.getHostAddress();
            if (!((String)host).startsWith("[") && ((String)host).indexOf(58) != -1) {
                host = "[" + (String)host + "]";
            }
            this.checkPermission(new SocketPermission((String)host, "accept,connect"));
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkMulticast(maddr);
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPermission(perm, context);
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPrintJobAccess();
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPropertiesAccess();
        }
        super.checkPropertiesAccess();
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPropertyAccess(key);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkRead(fd);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkRead(file, context);
        }
    }

    @Override
    public void checkRead(String file) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkRead(file);
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkSecurityAccess(target);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkSetFactory();
        }
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkWrite(fd);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkWrite(file);
        }
    }

    @Override
    public Object getSecurityContext() {
        if (this.fSecurityManager != null) {
            return this.fSecurityManager.getSecurityContext();
        }
        return super.getSecurityContext();
    }

    @Override
    public ThreadGroup getThreadGroup() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.getThreadGroup();
        }
        return super.getThreadGroup();
    }

    @Deprecated
    public void checkAwtEventQueueAccess() {
        if (this.fSecurityManager != null) {
            try {
                Method m = this.fSecurityManager.getClass().getMethod("checkAwtEventQueueAccess", new Class[0]);
                m.invoke((Object)this.fSecurityManager, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                AntSecurityManager.logDeprecatedAccess(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                AntSecurityManager.logException(e);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                AntSecurityManager.logException(e);
            }
        }
    }

    @Deprecated
    public void checkMemberAccess(Class<?> clazz, int which) {
        if (this.fSecurityManager != null) {
            try {
                Method m = this.fSecurityManager.getClass().getMethod("checkMemberAccess", Class.class, Integer.TYPE);
                m.invoke((Object)this.fSecurityManager, clazz, which);
            }
            catch (NoSuchMethodException e) {
                AntSecurityManager.logDeprecatedAccess(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                AntSecurityManager.logException(e);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                AntSecurityManager.logException(e);
            }
        }
    }

    @Deprecated
    public void checkSystemClipboardAccess() {
        if (this.fSecurityManager != null) {
            try {
                Method m = this.fSecurityManager.getClass().getMethod("checkSystemClipboardAccess", new Class[0]);
                m.invoke((Object)this.fSecurityManager, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                AntSecurityManager.logDeprecatedAccess(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                AntSecurityManager.logException(e);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                AntSecurityManager.logException(e);
            }
        }
    }

    @Deprecated
    public boolean checkTopLevelWindow(Object window) {
        try {
            if (this.fSecurityManager != null) {
                Method m = this.fSecurityManager.getClass().getMethod("checkTopLevelWindow", Object.class);
                return (Boolean)m.invoke((Object)this.fSecurityManager, window);
            }
            Method m = SecurityManager.class.getMethod("checkTopLevelWindow", Object.class);
            return (Boolean)m.invoke((Object)new SecurityManager(), window);
        }
        catch (NoSuchMethodException e) {
            AntSecurityManager.logDeprecatedAccess(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            AntSecurityManager.logException(e);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            AntSecurityManager.logException(e);
        }
        return false;
    }

    @Deprecated
    public boolean getInCheck() {
        try {
            if (this.fSecurityManager != null) {
                Method m = this.fSecurityManager.getClass().getMethod("getInCheck", new Class[0]);
                return (Boolean)m.invoke((Object)this.fSecurityManager, new Object[0]);
            }
            Method m = SecurityManager.class.getMethod("getInCheck", new Class[0]);
            return (Boolean)m.invoke((Object)new SecurityManager(), new Object[0]);
        }
        catch (NoSuchMethodException e) {
            AntSecurityManager.logDeprecatedAccess(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            AntSecurityManager.logException(e);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            AntSecurityManager.logException(e);
        }
        return false;
    }

    private static void logDeprecatedAccess(Throwable e) {
        ILog.of((Bundle)AntCorePlugin.getPlugin().getBundle()).log((IStatus)new Status(2, "org.eclipse.ant.core", InternalCoreAntMessages.AntSecurityManager_0, e));
    }

    private static void logException(Throwable e) {
        ILog.of((Bundle)AntCorePlugin.getPlugin().getBundle()).log((IStatus)new Status(4, "org.eclipse.ant.core", e.getLocalizedMessage(), e));
    }
}

