/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm;

import java.util.BitSet;
import java.util.List;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.dsm.Group;
import org.eclipse.escet.common.dsm.MarkovClustering;
import org.eclipse.escet.common.dsm.MatrixHelper;
import org.eclipse.escet.common.dsm.submatrix.SubMatrixFunctions;
import org.eclipse.escet.common.dsm.submatrix.SubNode;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class ClusterComputing {
    private ClusterComputing() {
    }

    public static Group hierarchicalClustering(RealMatrix parentAdjacencies, BitSet parentAvailable, double evap, int stepCount, double inflation, double epsilon, Group.GroupType topLevelGroupType, DebugNormalOutput dbg) {
        if (parentAvailable.isEmpty()) {
            return null;
        }
        List<Group> groups = Lists.list();
        BitSet availableNodes = BitSets.copy((BitSet)parentAvailable);
        while (true) {
            SubNode[] subNodes = SubMatrixFunctions.makeSubNodes(groups, parentAvailable);
            RealMatrix subAdjacencies = SubMatrixFunctions.fillSubMatrix(parentAdjacencies, subNodes);
            dbg.line();
            dbg.line("subjAdjacencies:");
            dbg.line(subAdjacencies.toString());
            ProbabilityData probData = ClusterComputing.convertAdjacencyToProbabilities(subAdjacencies, evap);
            dbg.line();
            dbg.line("probData:");
            dbg.line(probData.probabilities.toString());
            List<BitSet> clusters = MarkovClustering.markovClustering(probData.probabilities, stepCount, inflation, probData.pruningLimits, epsilon, dbg);
            groups = SubMatrixFunctions.convertSubGroups(subNodes, clusters, clusters.size() == 1 ? topLevelGroupType : Group.GroupType.CLUSTER);
            BitSet newNodes = SubMatrixFunctions.computeAvailNodes(subNodes, clusters);
            if (newNodes.isEmpty()) {
                if (groups.size() == 1) {
                    return groups.get(0);
                }
                return new Group(topLevelGroupType, null, groups);
            }
            if (newNodes.cardinality() >= availableNodes.cardinality()) {
                return new Group(topLevelGroupType, newNodes, groups);
            }
            availableNodes = newNodes;
        }
    }

    private static ProbabilityData convertAdjacencyToProbabilities(RealMatrix m, double evap) {
        int n = m.getRowDimension();
        Assert.check((boolean)m.isSquare());
        double[] kins = new double[n];
        int j = 0;
        while (j < n) {
            double sum = 0.0;
            int i = 0;
            while (i < n) {
                sum += m.getEntry(i, j);
                ++i;
            }
            kins[j] = sum > 0.0 ? sum : 1.0;
            ++j;
        }
        DiagonalMatrix winMat = new DiagonalMatrix(kins);
        double[] kouts = new double[n];
        int i = 0;
        while (i < n) {
            double sum = 0.0;
            int j2 = 0;
            while (j2 < n) {
                sum += m.getEntry(i, j2);
                ++j2;
            }
            kouts[i] = sum > 0.0 ? sum : 1.0;
            ++i;
        }
        DiagonalMatrix woutMat = new DiagonalMatrix(kouts);
        double[] b1s = new double[n];
        int i2 = 0;
        while (i2 < n) {
            b1s[i2] = 1.0 / (kouts[i2] * evap);
            ++i2;
        }
        DiagonalMatrix matB1 = new DiagonalMatrix(b1s, false);
        b1s = null;
        double[] b2s = new double[n];
        int i3 = 0;
        while (i3 < n) {
            b2s[i3] = 1.0 / (kins[i3] * evap);
            ++i3;
        }
        DiagonalMatrix matB2 = new DiagonalMatrix(b2s, false);
        b2s = null;
        RealMatrix rimMat = MatrixUtils.inverse((RealMatrix)m.multiply((RealMatrix)matB1).subtract((RealMatrix)winMat)).scalarMultiply(-1.0);
        rimMat = rimMat.subtract(MatrixUtils.inverse((RealMatrix)winMat));
        RealMatrix rdmMat = MatrixUtils.inverse((RealMatrix)m.transpose().multiply((RealMatrix)matB2).subtract((RealMatrix)woutMat)).scalarMultiply(-1.0);
        rdmMat = rdmMat.subtract(MatrixUtils.inverse((RealMatrix)woutMat));
        MatrixHelper.normalizeColumns(rimMat, false);
        MatrixHelper.normalizeColumns(rdmMat, false);
        double[] pruningLimits = new double[n];
        int idx = 0;
        while (idx < n) {
            double v = evap * (kouts[idx] + kins[idx]);
            Assert.check((v != 0.0 ? 1 : 0) != 0);
            pruningLimits[idx] = 1.0 / (v * v);
            ++idx;
        }
        BlockRealMatrix matP = new BlockRealMatrix(n, n);
        double[] column = new double[n];
        int j3 = 0;
        while (j3 < n) {
            int i4 = 0;
            while (i4 < n) {
                column[i4] = rimMat.getEntry(i4, j3) + rdmMat.getEntry(i4, j3);
                ++i4;
            }
            MatrixHelper.normalizeArray(column);
            matP.setColumn(j3, column);
            ++j3;
        }
        MatrixHelper.prune((RealMatrix)matP, pruningLimits);
        int idx2 = 0;
        while (idx2 < n) {
            double max = MatrixHelper.getColumnMax((RealMatrix)matP, idx2);
            if (Double.isNaN(max) || max <= 0.0) {
                max = 1.0;
            }
            matP.setEntry(idx2, idx2, max);
            ++idx2;
        }
        MatrixHelper.normalizeColumns((RealMatrix)matP, false);
        return new ProbabilityData((RealMatrix)matP, pruningLimits);
    }

    private static class ProbabilityData {
        public final RealMatrix probabilities;
        public final double[] pruningLimits;

        public ProbabilityData(RealMatrix probabilities, double[] pruningLimits) {
            this.probabilities = probabilities;
            this.pruningLimits = pruningLimits;
        }
    }
}

