/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.contributions.ui.wizard;

import common.CommonFactory;
import common.Import;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.lsat.contributions.ui.Activator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

abstract class AbstractNewWizard<T extends EObject>
extends Wizard
implements INewWizard {
    private final String itsModelName;
    private NewModelCreationPage itsNewModelCreationPage;
    private IWorkbench itsWorkbench;
    private IStructuredSelection itsSelection;

    public AbstractNewWizard(String modelName) {
        this.itsModelName = modelName;
        this.setWindowTitle("New");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.itsWorkbench = workbench;
        this.itsSelection = selection;
        this.itsNewModelCreationPage = new NewModelCreationPage(((Object)((Object)this)).getClass().getSimpleName() + "_NewModelCreationPage", selection);
    }

    protected String baseName(IResource resource) {
        String baseName = resource.getName();
        String extension = resource.getFileExtension();
        if (extension != null) {
            baseName = baseName.substring(0, baseName.length() - 1 - extension.length());
        }
        return baseName;
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    protected abstract Collection<String> getFileExtensions();

    protected abstract T createModel(IFile var1, Collection<Import> var2);

    public void addPages() {
        this.addPage((IWizardPage)this.itsNewModelCreationPage);
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.itsNewModelCreationPage.getModelFile();
            final URI modelURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
            final ArrayList<Import> imports = new ArrayList<Import>(this.itsSelection.size());
            Object[] objectArray = this.itsSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                if (selected instanceof IFile) {
                    Import _import = CommonFactory.eINSTANCE.createImport();
                    URI importUri = URI.createPlatformResourceURI((String)((IFile)selected).getFullPath().toString(), (boolean)true);
                    _import.setImportURI(importUri.deresolve(modelURI).toString());
                    imports.add(_import);
                }
                ++n2;
            }
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSet resourceSet = AbstractNewWizard.this.createResourceSet();
                            Resource resource = resourceSet.createResource(modelURI);
                            Object model = AbstractNewWizard.this.createModel(modelFile, imports);
                            resource.getContents().add(model);
                            resource.save(Collections.emptyMap());
                        }
                        catch (Exception exception) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.lsat.contributions.ui", "Failed to create model", (Throwable)exception));
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.itsWorkbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.itsWorkbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Failed to open editor", (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.lsat.contributions.ui", "Failed to create model", (Throwable)exception));
            return false;
        }
    }

    protected class NewModelCreationPage
    extends WizardNewFileCreationPage {
        public NewModelCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
            this.setTitle(String.format("%s Model", AbstractNewWizard.this.itsModelName));
            this.setDescription(String.format("Create a new %s model", AbstractNewWizard.this.itsModelName));
            this.setFileName(this.getFileNameSuggestion(selection));
        }

        private String getFileNameSuggestion(IStructuredSelection selection) {
            String fileName = AbstractNewWizard.this.itsModelName.replace(' ', '_').toLowerCase();
            String fileExtension = AbstractNewWizard.this.getFileExtensions().iterator().next();
            String newPath = fileName + "." + fileExtension;
            if (!selection.isEmpty()) {
                IResource selected = (IResource)selection.getFirstElement();
                fileName = AbstractNewWizard.this.baseName(selected);
                newPath = fileName + "." + fileExtension;
                int counter = 1;
                while (selected.getParent().findMember(newPath) != null) {
                    newPath = fileName + "_" + counter++ + "." + fileExtension;
                }
            }
            return newPath;
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !AbstractNewWizard.this.getFileExtensions().contains(extension)) {
                    this.setErrorMessage("Please specify a valid file extension for this type of model.");
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

