/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.common.ui;

import java.math.BigDecimal;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class BigDecimalCellEditor
extends TextCellEditor
implements ICellEditorValidator {
    public BigDecimalCellEditor() {
        this.setValidator(this);
    }

    public BigDecimalCellEditor(Composite parent) {
        super(parent);
        this.setValidator(this);
    }

    public BigDecimalCellEditor(Composite parent, int style) {
        super(parent, style);
        this.setValidator(this);
    }

    public String isValid(Object value) {
        try {
            new BigDecimal(String.valueOf(value));
            return null;
        }
        catch (NumberFormatException e) {
            return String.format("Not a valid number %s: %s", value, e.getMessage());
        }
    }

    protected boolean isCorrect(Object value) {
        boolean corect = super.isCorrect(value);
        this.setValueValid(corect);
        return corect;
    }

    protected void valueChanged(boolean oldValidState, boolean newValidState) {
        super.valueChanged(oldValidState, newValidState);
    }

    protected Object doGetValue() {
        Object value = super.doGetValue();
        try {
            if (value instanceof String) {
                value = new BigDecimal((String)value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    protected void doSetValue(Object value) {
        super.doSetValue((Object)(value == null ? null : value.toString()));
    }
}

