/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DynamicCompletionRegistrationTest
extends AbstractTestWithProject {
    private LSContentAssistProcessor contentAssistProcessor;

    @Before
    public void setup() {
        this.contentAssistProcessor = new LSContentAssistProcessor(true, false);
    }

    @Test
    public void testDynamicCompletionRegistrationProvidesProposalsAndTriggers() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        TestUtils.waitForAndAssertCondition(5000, () -> !MockLanguageServer.INSTANCE.getRemoteProxies().isEmpty());
        LanguageClient client = this.getMockClient();
        Assert.assertNotNull((Object)client);
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        CompletionItem item = new CompletionItem();
        item.setLabel("Alpha");
        item.setKind(CompletionItemKind.Text);
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "Alpha")));
        items.add(item);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        Registration registration = new Registration();
        registration.setId("test-completion-reg");
        registration.setMethod("textDocument/completion");
        CompletionOptions opts = new CompletionOptions();
        opts.setTriggerCharacters(List.of(".", "/", "#"));
        registration.setRegisterOptions((Object)new Gson().toJsonTree((Object)opts));
        client.registerCapability(new RegistrationParams(List.of(registration))).get(2L, TimeUnit.SECONDS);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assert.assertEquals((long)1L, (long)proposals.length);
        Assert.assertEquals((Object)"Alpha", (Object)proposals[0].getDisplayString());
        char[] triggers = this.contentAssistProcessor.getCompletionProposalAutoActivationCharacters();
        String trig = new String(triggers != null ? triggers : new char[]{});
        Assert.assertTrue((trig.indexOf(46) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((trig.indexOf(47) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((trig.indexOf(35) >= 0 ? 1 : 0) != 0);
    }

    private LanguageClient getMockClient() {
        List proxies = MockLanguageServer.INSTANCE.getRemoteProxies();
        Assert.assertEquals((long)1L, (long)proxies.size());
        return (LanguageClient)proxies.get(0);
    }
}

