/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.node;

import org.commonmark.node.Block;
import org.commonmark.node.Visitor;

public class FencedCodeBlock
extends Block {
    private String fenceCharacter;
    private Integer openingFenceLength;
    private Integer closingFenceLength;
    private int fenceIndent;
    private String info;
    private String literal;

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String getFenceCharacter() {
        return this.fenceCharacter;
    }

    public void setFenceCharacter(String fenceCharacter) {
        this.fenceCharacter = fenceCharacter;
    }

    public Integer getOpeningFenceLength() {
        return this.openingFenceLength;
    }

    public void setOpeningFenceLength(Integer openingFenceLength) {
        if (openingFenceLength != null && openingFenceLength < 3) {
            throw new IllegalArgumentException("openingFenceLength needs to be >= 3");
        }
        FencedCodeBlock.checkFenceLengths(openingFenceLength, this.closingFenceLength);
        this.openingFenceLength = openingFenceLength;
    }

    public Integer getClosingFenceLength() {
        return this.closingFenceLength;
    }

    public void setClosingFenceLength(Integer closingFenceLength) {
        if (closingFenceLength != null && closingFenceLength < 3) {
            throw new IllegalArgumentException("closingFenceLength needs to be >= 3");
        }
        FencedCodeBlock.checkFenceLengths(this.openingFenceLength, closingFenceLength);
        this.closingFenceLength = closingFenceLength;
    }

    public int getFenceIndent() {
        return this.fenceIndent;
    }

    public void setFenceIndent(int fenceIndent) {
        this.fenceIndent = fenceIndent;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getLiteral() {
        return this.literal;
    }

    public void setLiteral(String literal) {
        this.literal = literal;
    }

    @Deprecated
    public char getFenceChar() {
        return this.fenceCharacter != null && !this.fenceCharacter.isEmpty() ? this.fenceCharacter.charAt(0) : (char)'\u0000';
    }

    @Deprecated
    public void setFenceChar(char fenceChar) {
        this.fenceCharacter = fenceChar != '\u0000' ? String.valueOf(fenceChar) : null;
    }

    @Deprecated
    public int getFenceLength() {
        return this.openingFenceLength != null ? this.openingFenceLength : 0;
    }

    @Deprecated
    public void setFenceLength(int fenceLength) {
        this.openingFenceLength = fenceLength != 0 ? Integer.valueOf(fenceLength) : null;
    }

    private static void checkFenceLengths(Integer openingFenceLength, Integer closingFenceLength) {
        if (openingFenceLength != null && closingFenceLength != null && closingFenceLength < openingFenceLength) {
            throw new IllegalArgumentException("fence lengths required to be: closingFenceLength >= openingFenceLength");
        }
    }
}

