/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.eclipse.lyo.core.query.CompoundTerm;
import org.eclipse.lyo.core.query.NestedProperty;
import org.eclipse.lyo.core.query.OrderByClause;
import org.eclipse.lyo.core.query.OslcOrderByParser;
import org.eclipse.lyo.core.query.OslcPrefixParser;
import org.eclipse.lyo.core.query.OslcSearchTermsParser;
import org.eclipse.lyo.core.query.OslcSelectParser;
import org.eclipse.lyo.core.query.OslcWhereParser;
import org.eclipse.lyo.core.query.PName;
import org.eclipse.lyo.core.query.ParseException;
import org.eclipse.lyo.core.query.Properties;
import org.eclipse.lyo.core.query.PropertiesClause;
import org.eclipse.lyo.core.query.Property;
import org.eclipse.lyo.core.query.SearchTermsClause;
import org.eclipse.lyo.core.query.SelectClause;
import org.eclipse.lyo.core.query.SortTerms;
import org.eclipse.lyo.core.query.WhereClause;
import org.eclipse.lyo.core.query.impl.CompoundTermInvocationHandler;
import org.eclipse.lyo.core.query.impl.PropertiesInvocationHandler;
import org.eclipse.lyo.core.query.impl.SortTermsInvocationHandler;
import org.eclipse.lyo.oslc4j.core.NestedWildcardProperties;
import org.eclipse.lyo.oslc4j.core.OSLC4JConstants;
import org.eclipse.lyo.oslc4j.core.SingletonWildcardProperties;

public class QueryUtils {
    public static final Properties WILDCARD_PROPERTY_LIST = (Properties)Proxy.newProxyInstance(Properties.class.getClassLoader(), new Class[]{Properties.class}, (InvocationHandler)new PropertiesInvocationHandler());

    public static Map<String, String> parsePrefixes(String prefixExpression) throws ParseException {
        if (prefixExpression == null) {
            return new HashMap<String, String>();
        }
        OslcPrefixParser parser = new OslcPrefixParser(prefixExpression);
        try {
            CommonTree rawTree = parser.oslc_prefixes().getTree();
            QueryUtils.checkErrors(parser.getErrors());
            PrefixMap prefixMap = new PrefixMap(rawTree.getChildCount());
            for (int index = 0; index < rawTree.getChildCount(); ++index) {
                Tree rawPrefix = rawTree.getChild(index);
                if (rawPrefix.getType() == 0) {
                    throw ((CommonErrorNode)rawPrefix).trappedException;
                }
                String pn = rawPrefix.getChild(0).getText();
                String uri = rawPrefix.getChild(1).getText();
                uri = uri.substring(1, uri.length() - 1);
                prefixMap.put(pn, uri);
            }
            return prefixMap;
        }
        catch (RecognitionException e) {
            throw new ParseException(e);
        }
    }

    public static WhereClause parseWhere(String whereExpression, Map<String, String> prefixMap) throws ParseException {
        OslcWhereParser parser = new OslcWhereParser(whereExpression);
        try {
            OslcWhereParser.oslc_where_return resultTree = parser.oslc_where();
            QueryUtils.checkErrors(parser.getErrors());
            CommonTree rawTree = resultTree.getTree();
            Tree child = rawTree.getChild(0);
            if (child.getType() == 0) {
                throw ((CommonErrorNode)child).trappedException;
            }
            return (WhereClause)Proxy.newProxyInstance(CompoundTerm.class.getClassLoader(), new Class[]{CompoundTerm.class, WhereClause.class}, (InvocationHandler)new CompoundTermInvocationHandler((Tree)rawTree, true, prefixMap));
        }
        catch (RecognitionException e) {
            throw new ParseException(e);
        }
    }

    public static SelectClause parseSelect(String selectExpression, Map<String, String> prefixMap) throws ParseException {
        OslcSelectParser parser = new OslcSelectParser(selectExpression);
        try {
            OslcSelectParser.oslc_select_return resultTree = parser.oslc_select();
            QueryUtils.checkErrors(parser.getErrors());
            CommonTree rawTree = resultTree.getTree();
            if (rawTree.getType() == 0) {
                throw ((CommonErrorNode)rawTree).trappedException;
            }
            return (SelectClause)Proxy.newProxyInstance(SelectClause.class.getClassLoader(), new Class[]{SelectClause.class, Properties.class}, (InvocationHandler)new PropertiesInvocationHandler(resultTree.getTree(), prefixMap));
        }
        catch (RecognitionException e) {
            throw new ParseException(e);
        }
    }

    public static PropertiesClause parseProperties(String propertiesExpression, Map<String, String> prefixMap) throws ParseException {
        OslcSelectParser parser = new OslcSelectParser(propertiesExpression);
        try {
            OslcSelectParser.oslc_select_return resultTree = parser.oslc_select();
            QueryUtils.checkErrors(parser.getErrors());
            CommonTree rawTree = resultTree.getTree();
            if (rawTree.getType() == 0) {
                throw ((CommonErrorNode)rawTree).trappedException;
            }
            return (PropertiesClause)Proxy.newProxyInstance(PropertiesClause.class.getClassLoader(), new Class[]{PropertiesClause.class, Properties.class}, (InvocationHandler)new PropertiesInvocationHandler(resultTree.getTree(), prefixMap));
        }
        catch (RecognitionException e) {
            throw new ParseException(e);
        }
    }

    public static OrderByClause parseOrderBy(String orderByExpression, Map<String, String> prefixMap) throws ParseException {
        OslcOrderByParser parser = new OslcOrderByParser(orderByExpression);
        try {
            OslcOrderByParser.oslc_order_by_return resultTree = parser.oslc_order_by();
            QueryUtils.checkErrors(parser.getErrors());
            CommonTree rawTree = resultTree.getTree();
            Tree child = rawTree.getChild(0);
            if (child.getType() == 0) {
                throw ((CommonErrorNode)child).trappedException;
            }
            return (OrderByClause)Proxy.newProxyInstance(OrderByClause.class.getClassLoader(), new Class[]{OrderByClause.class, SortTerms.class}, (InvocationHandler)new SortTermsInvocationHandler((Tree)rawTree, prefixMap));
        }
        catch (RecognitionException e) {
            throw new ParseException(e);
        }
    }

    public static Map<String, Object> invertSelectedProperties(Properties properties) {
        List<Property> children = properties.children();
        HashMap result = new HashMap(children.size());
        for (Property property : children) {
            String propertyName = null;
            if (!property.isWildcard()) {
                PName pname = property.identifier();
                propertyName = pname.namespace + pname.local;
            }
            switch (property.type()) {
                case IDENTIFIER: {
                    if (property.isWildcard()) {
                        if (result instanceof SingletonWildcardProperties) break;
                        if (result instanceof NestedWildcardProperties) {
                            result = new BothWildcardPropertiesImpl((NestedWildcardPropertiesImpl)result);
                            break;
                        }
                        result = new SingletonWildcardPropertiesImpl();
                        break;
                    }
                    if (result instanceof SingletonWildcardProperties) break;
                    result.put((String)propertyName, (Object)OSLC4JConstants.OSL4J_PROPERTY_SINGLETON);
                    break;
                }
                case NESTED_PROPERTY: {
                    if (property.isWildcard()) {
                        if (!(result instanceof NestedWildcardProperties)) {
                            result = result instanceof SingletonWildcardProperties ? new BothWildcardPropertiesImpl() : new NestedWildcardPropertiesImpl(result);
                            ((NestedWildcardPropertiesImpl)result).commonNestedProperties = QueryUtils.invertSelectedProperties((NestedProperty)property);
                            break;
                        }
                        QueryUtils.mergePropertyMaps(((NestedWildcardProperties)result).commonNestedProperties(), QueryUtils.invertSelectedProperties((NestedProperty)property));
                        break;
                    }
                    result.put((String)propertyName, QueryUtils.invertSelectedProperties((NestedProperty)property));
                }
            }
        }
        if (!(result instanceof NestedWildcardProperties)) {
            return result;
        }
        Map commonNestedProperties = ((NestedWildcardProperties)result).commonNestedProperties();
        for (Map.Entry propertyMapping : result.entrySet()) {
            Map nestedProperties = (Map)propertyMapping.getValue();
            if (nestedProperties == OSLC4JConstants.OSL4J_PROPERTY_SINGLETON) {
                result.put((String)propertyMapping.getKey(), commonNestedProperties);
                continue;
            }
            QueryUtils.mergePropertyMaps(nestedProperties, commonNestedProperties);
        }
        return result;
    }

    public static SearchTermsClause parseSearchTerms(String searchTermsExpression) throws ParseException {
        OslcSearchTermsParser parser = new OslcSearchTermsParser(searchTermsExpression);
        try {
            OslcSearchTermsParser.oslc_search_terms_return resultTree = parser.oslc_search_terms();
            QueryUtils.checkErrors(parser.getErrors());
            CommonTree rawTree = resultTree.getTree();
            Tree child = rawTree.getChild(0);
            if (child.getType() == 0) {
                throw ((CommonErrorNode)child).trappedException;
            }
            StringList stringList = new StringList(rawTree.getChildCount());
            for (int index = 0; index < rawTree.getChildCount(); ++index) {
                Tree string = rawTree.getChild(index);
                String rawString = string.getText();
                stringList.add(rawString.substring(1, rawString.length() - 1));
            }
            return stringList;
        }
        catch (RecognitionException e) {
            throw new ParseException(e);
        }
    }

    private static void mergePropertyMaps(Map<String, Object> lhs, Map<String, Object> rhs) {
        for (String propertyName : rhs.keySet()) {
            Map rhsNestedProperties;
            Map lhsNestedProperties = (Map)lhs.get(propertyName);
            if (lhsNestedProperties == (rhsNestedProperties = (Map)rhs.get(propertyName))) continue;
            if (lhsNestedProperties == null || lhsNestedProperties == OSLC4JConstants.OSL4J_PROPERTY_SINGLETON) {
                lhs.put(propertyName, rhsNestedProperties);
                continue;
            }
            QueryUtils.mergePropertyMaps(lhsNestedProperties, rhsNestedProperties);
        }
    }

    private static void checkErrors(List<String> errors) throws ParseException {
        if (errors.isEmpty()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (String error : errors) {
            if (first) {
                first = false;
            } else {
                buffer.append('\n');
            }
            buffer.append(error);
        }
        throw new ParseException(buffer.toString());
    }

    private static class PrefixMap
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1943909246265711359L;

        public PrefixMap(int size) {
            super(size);
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            Iterator keys = this.keySet().iterator();
            boolean first = true;
            while (keys.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                String key = (String)keys.next();
                buffer.append(key);
                buffer.append('=');
                buffer.append('<');
                buffer.append((String)this.get(key));
                buffer.append('>');
            }
            return buffer.toString();
        }
    }

    private static class BothWildcardPropertiesImpl
    extends NestedWildcardPropertiesImpl
    implements SingletonWildcardProperties {
        private static final long serialVersionUID = 654939845613307220L;

        public BothWildcardPropertiesImpl() {
        }

        public BothWildcardPropertiesImpl(NestedWildcardPropertiesImpl accumulated) {
            this();
            this.commonNestedProperties = accumulated.commonNestedProperties();
        }
    }

    private static class NestedWildcardPropertiesImpl
    extends HashMap<String, Object>
    implements NestedWildcardProperties {
        protected Map<String, Object> commonNestedProperties = new HashMap<String, Object>();
        private static final long serialVersionUID = -938983371894966574L;

        public NestedWildcardPropertiesImpl(Map<String, Object> accumulated) {
            super(accumulated);
        }

        protected NestedWildcardPropertiesImpl() {
            super(0);
        }

        public Map<String, Object> commonNestedProperties() {
            return this.commonNestedProperties;
        }
    }

    private static class SingletonWildcardPropertiesImpl
    extends HashMap<String, Object>
    implements SingletonWildcardProperties {
        private static final long serialVersionUID = -5490896670186283412L;

        public SingletonWildcardPropertiesImpl() {
            super(0);
        }
    }

    private static class StringList
    extends ArrayList<String>
    implements SearchTermsClause {
        private static final long serialVersionUID = 1943909246265711359L;

        public StringList(int size) {
            super(size);
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            boolean first = true;
            for (String string : this) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append('\"');
                buffer.append(string);
                buffer.append('\"');
            }
            return buffer.toString();
        }
    }
}

