/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.figure;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.BorderItemContainerFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ImageFigureWithAlpha;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.util.OpaquePixelFinder;

public class AlphaBasedSlidableImageAnchor
extends SlidableAnchor {
    public AlphaBasedSlidableImageAnchor() {
    }

    public AlphaBasedSlidableImageAnchor(IFigure f) {
        super(f);
    }

    public AlphaBasedSlidableImageAnchor(IFigure f, PrecisionPoint p) {
        super(f, p);
    }

    private ImageFigureWithAlpha getImageFigure() {
        ImageFigureWithAlpha ret = null;
        if (ret == null) {
            IFigure root = this.getOwner().getParent() == null ? this.getOwner() : this.getOwner().getParent();
            ret = AlphaBasedSlidableImageAnchor.getImageFigure(root);
        }
        return ret;
    }

    private static ImageFigureWithAlpha getImageFigure(IFigure root) {
        ImageFigureWithAlpha ret = null;
        if (!(root instanceof BorderItemContainerFigure)) {
            if (root instanceof ImageFigureWithAlpha) {
                ret = (ImageFigureWithAlpha)root;
            }
            UnmodifiableIterator iterChilren = Iterators.filter(root.getChildren().iterator(), IFigure.class);
            while (iterChilren.hasNext() && ret == null) {
                ret = AlphaBasedSlidableImageAnchor.getImageFigure((IFigure)iterChilren.next());
            }
        }
        return ret;
    }

    protected IFigure getContainer() {
        return this.getOwner();
    }

    protected Point getLocation(Point ownReference, Point foreignReference) {
        return this.getLocation(ownReference, foreignReference, 0);
    }

    protected Point getLocation(Point ownReference, Point foreignReference, int orientation) {
        Point anchorFromSuper = super.getLocation(ownReference, foreignReference);
        ImageFigureWithAlpha imageFigure = this.getImageFigure();
        if (!(imageFigure instanceof IFigure && ((IFigure)imageFigure).getBorder() != null || imageFigure == null || anchorFromSuper == null)) {
            Rectangle box = this.getBox();
            return new OpaquePixelFinder().searchFirstOpaquePoint(orientation, anchorFromSuper, imageFigure, box);
        }
        return anchorFromSuper;
    }

    public Point getOrthogonalLocation(Point orthoReference) {
        PrecisionPoint ownReference = new PrecisionPoint(this.getReferencePoint());
        PrecisionRectangle bounds = new PrecisionRectangle(FigureUtilities.getAnchorableFigureBounds((IFigure)this.getOwner()));
        this.getOwner().translateToAbsolute((Translatable)bounds);
        bounds.expand(1.0E-6, 1.0E-6);
        PrecisionPoint preciseOrthoReference = new PrecisionPoint(orthoReference);
        int orientation = 0;
        if (bounds.contains((Point)preciseOrthoReference)) {
            int side = AlphaBasedSlidableImageAnchor.getClosestSide((Point)ownReference, (Rectangle)bounds);
            switch (side) {
                case 1: 
                case 4: {
                    ownReference.setPreciseY(preciseOrthoReference.preciseY());
                    orientation = 64;
                    break;
                }
                case 8: 
                case 32: {
                    ownReference.setPreciseX(preciseOrthoReference.preciseX());
                    orientation = 128;
                    break;
                }
            }
        } else if (preciseOrthoReference.preciseX() >= bounds.preciseX() && preciseOrthoReference.preciseX() <= bounds.preciseX() + bounds.preciseWidth()) {
            ownReference.setPreciseX(preciseOrthoReference.preciseX());
            orientation = 128;
        } else if (preciseOrthoReference.preciseY() >= bounds.preciseY() && preciseOrthoReference.preciseY() <= bounds.preciseY() + bounds.preciseHeight()) {
            ownReference.setPreciseY(preciseOrthoReference.preciseY());
            orientation = 64;
        }
        Point location = this.getLocation((Point)ownReference, (Point)preciseOrthoReference, orientation);
        if (location == null) {
            location = this.getLocation(orthoReference);
            orientation = 0;
        }
        if (orientation != 0) {
            PrecisionPoint loc = new PrecisionPoint(location);
            if (orientation == 128) {
                loc.setPreciseX(preciseOrthoReference.preciseX());
            } else {
                loc.setPreciseY(preciseOrthoReference.preciseY());
            }
            location = loc;
        }
        return location;
    }

    private static int getClosestSide(Point p, Rectangle r) {
        double diff = Math.abs(r.preciseX() + r.preciseWidth() - p.preciseX());
        int side = 4;
        double currentDiff = Math.abs(r.preciseX() - p.preciseX());
        if (currentDiff < diff) {
            diff = currentDiff;
            side = 1;
        }
        if ((currentDiff = Math.abs(r.preciseY() + r.preciseHeight() - p.preciseY())) < diff) {
            diff = currentDiff;
            side = 32;
        }
        if ((currentDiff = Math.abs(r.preciseY() - p.preciseY())) < diff) {
            diff = currentDiff;
            side = 8;
        }
        return side;
    }
}

