/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.synchronize.GlobalRefreshElementSelectionPage;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;
import org.eclipse.team.ui.synchronize.WorkingSetScope;
import org.eclipse.team.ui.synchronize.WorkspaceScope;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class GlobalRefreshResourceSelectionPage
extends GlobalRefreshElementSelectionPage {
    private List resources;

    public GlobalRefreshResourceSelectionPage(IResource[] resources) {
        super(TeamUIMessages.GlobalRefreshResourceSelectionPage_1);
        this.resources = Arrays.asList(resources);
        this.setDescription(TeamUIMessages.GlobalRefreshResourceSelectionPage_2);
        this.setTitle(TeamUIMessages.GlobalRefreshResourceSelectionPage_3);
    }

    @Override
    protected ContainerCheckedTreeViewer createViewer(Composite top) {
        ContainerCheckedTreeViewer fViewer = new ContainerCheckedTreeViewer(top, 2048);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        fViewer.getControl().setLayoutData((Object)data);
        fViewer.setContentProvider((IContentProvider)new MyContentProvider());
        fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new MyLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                GlobalRefreshResourceSelectionPage.this.updateOKStatus();
            }
        });
        fViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        fViewer.setInput((Object)this.resources);
        return fViewer;
    }

    @Override
    protected void checkAll() {
        this.getViewer().setCheckedElements(this.resources.toArray());
    }

    @Override
    protected boolean checkWorkingSetElements() {
        ArrayList allWorkingSetResources = new ArrayList();
        IWorkingSet[] workingSets = this.getWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet set = workingSets[i];
            allWorkingSetResources.addAll(IDE.computeSelectedResources((IStructuredSelection)new StructuredSelection((Object[])set.getElements())));
            ++i;
        }
        this.getViewer().setCheckedElements((Object[])allWorkingSetResources.toArray(new IResource[allWorkingSetResources.size()]));
        return !allWorkingSetResources.isEmpty();
    }

    public IResource[] getRootResources() {
        Object[] objects = this.getRootElement();
        IResource[] resources = new IResource[objects.length];
        int i = 0;
        while (i < resources.length) {
            resources[i] = (IResource)objects[i];
            ++i;
        }
        return resources;
    }

    public ISynchronizeScope getSynchronizeScope() {
        if (this.isWorkingSetSelected()) {
            return new WorkingSetScope(this.getWorkingSets());
        }
        if (this.isWorkspaceSelected()) {
            return new WorkspaceScope();
        }
        return new ResourceScope(this.getRootResources());
    }

    class MyContentProvider
    extends BaseWorkbenchContentProvider {
        MyContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof List) {
                return ((List)element).toArray(new IResource[((List)element).size()]);
            }
            return super.getChildren(element);
        }
    }

    class MyLabelProvider
    extends LabelProvider {
        private LabelProvider workbenchProvider = new WorkbenchLabelProvider();

        MyLabelProvider() {
        }

        public String getText(Object element) {
            IContainer c;
            if (element instanceof IContainer && (c = (IContainer)element).getType() != 4 && GlobalRefreshResourceSelectionPage.this.resources.contains(c)) {
                return c.getFullPath().toString();
            }
            return this.workbenchProvider.getText(element);
        }

        public Image getImage(Object element) {
            return this.workbenchProvider.getImage(element);
        }
    }
}

