/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.plugin;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginObjectNode;

public class PluginLibraryNode
extends PluginObjectNode
implements IPluginLibrary {
    private static final long serialVersionUID = 1L;

    @Override
    public String[] getContentFilters() {
        IDocumentElementNode[] children = this.getChildNodes();
        ArrayList<String> result = new ArrayList<String>();
        IDocumentElementNode[] iDocumentElementNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
            PluginObjectNode node = (PluginObjectNode)childNode;
            if (node.getName().equals("export") && (name = childNode.getXMLAttributeValue("name")) != null && !name.equals("*")) {
                int index = name.indexOf(".*");
                if (index != -1) {
                    name = name.substring(0, index);
                }
                result.add(name);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getPackages() {
        return new String[0];
    }

    @Override
    public boolean isExported() {
        IDocumentElementNode[] children;
        IDocumentElementNode[] iDocumentElementNodeArray = children = this.getChildNodes();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
            PluginObjectNode node = (PluginObjectNode)childNode;
            if (node.getName().equals("export")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isFullyExported() {
        IDocumentElementNode[] children;
        IDocumentElementNode[] iDocumentElementNodeArray = children = this.getChildNodes();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
            PluginObjectNode node = (PluginObjectNode)childNode;
            if (node.getName().equals("export") && (name = childNode.getXMLAttributeValue("name")) != null && name.equals("*")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getType() {
        String type = this.getXMLAttributeValue("type");
        return type != null && type.equals("resource") ? "resource" : "code";
    }

    @Override
    public void setContentFilters(String[] filters) throws CoreException {
    }

    @Override
    public void addContentFilter(String filter) throws CoreException {
        PluginElementNode node = new PluginElementNode();
        node.setXMLTagName("export");
        node.setParentNode(this);
        node.setModel(this.getModel());
        node.setXMLAttribute("name", "*".equals(filter) || filter.endsWith(".*") ? filter : String.valueOf(filter) + ".*");
        this.addContentFilter(node);
    }

    public void addContentFilter(PluginElementNode node) {
        this.addChildNode(node);
        if (this.isInTheModel()) {
            node.setInTheModel(true);
            this.fireStructureChanged(node, 1);
        }
    }

    @Override
    public void removeContentFilter(String filter) throws CoreException {
        IDocumentElementNode[] children;
        if (!filter.endsWith(".*")) {
            filter = String.valueOf(filter) + ".*";
        }
        IDocumentElementNode[] iDocumentElementNodeArray = children = this.getChildNodes();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
            if (childNode.getXMLTagName().equals("export") && filter.equals(childNode.getXMLAttributeValue("name"))) {
                this.removeContentFilter((PluginElementNode)childNode);
            }
            ++n2;
        }
    }

    public void removeContentFilter(PluginElementNode node) {
        this.removeChildNode(node);
        if (this.isInTheModel()) {
            node.setInTheModel(false);
            this.fireStructureChanged(node, 2);
        }
    }

    @Override
    public void setPackages(String[] packages) throws CoreException {
    }

    @Override
    public void setExported(boolean exported) throws CoreException {
        IDocumentElementNode[] children = this.getChildNodes();
        boolean alreadyExported = false;
        int i = 0;
        while (i < children.length) {
            if (children[i].getXMLTagName().equals("export")) {
                if (!"*".equals(children[i].getXMLAttributeValue("name"))) {
                    this.removeContentFilter((PluginElementNode)children[i]);
                } else {
                    alreadyExported = true;
                    if (!exported) {
                        this.removeContentFilter((PluginElementNode)children[i]);
                    }
                }
            }
            ++i;
        }
        if (exported && !alreadyExported) {
            this.addContentFilter("*");
        }
    }

    @Override
    public void setType(String type) throws CoreException {
    }

    @Override
    public String getName() {
        return this.getXMLAttributeValue("name");
    }

    @Override
    public void setName(String name) throws CoreException {
        this.setXMLAttribute("name", name);
    }

    @Override
    public String write(boolean indent) {
        IDocumentElementNode[] children;
        String sep = this.getLineDelimiter();
        StringBuffer buffer = new StringBuffer();
        if (indent) {
            buffer.append(this.getIndent());
        }
        if ((children = this.getChildNodes()).length > 0) {
            buffer.append(String.valueOf(this.writeShallow(false)) + sep);
            IDocumentElementNode[] iDocumentElementNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
                childNode.setLineIndent(this.getLineIndent() + 3);
                buffer.append(String.valueOf(childNode.write(true)) + sep);
                ++n2;
            }
            buffer.append(String.valueOf(this.getIndent()) + "</" + this.getXMLTagName() + ">");
        } else {
            buffer.append(this.writeShallow(true));
        }
        return buffer.toString();
    }

    @Override
    public String writeShallow(boolean terminate) {
        IDocumentAttributeNode[] attrs;
        StringBuffer buffer = new StringBuffer("<" + this.getXMLTagName());
        IDocumentAttributeNode[] iDocumentAttributeNodeArray = attrs = this.getNodeAttributes();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentAttributeNode attrNode = iDocumentAttributeNodeArray[n2];
            this.appendAttribute(buffer, attrNode.getAttributeName());
            ++n2;
        }
        if (terminate) {
            buffer.append("/");
        }
        buffer.append(">");
        return buffer.toString();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

