/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionCommandHandler;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.LegacyHandlerSubmissionExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class CorrectionCommandInstaller {
    private List<IHandlerActivation> fCorrectionHandlerActivations = null;

    public void registerCommands(CompilationUnitEditor editor) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandService = (ICommandService)workbench.getAdapter(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)workbench.getAdapter(IHandlerService.class);
        if (commandService == null || handlerService == null) {
            return;
        }
        if (this.fCorrectionHandlerActivations != null) {
            JavaPlugin.logErrorMessage("correction handler activations not released");
        }
        this.fCorrectionHandlerActivations = new ArrayList<IHandlerActivation>();
        Collection definedCommandIds = commandService.getDefinedCommandIds();
        for (String id : definedCommandIds) {
            if (!id.startsWith("org.eclipse.jdt.ui.correction.")) continue;
            boolean isAssist = id.endsWith(".assist");
            CorrectionCommandHandler handler = new CorrectionCommandHandler(editor, id, isAssist);
            IHandlerActivation activation = handlerService.activateHandler(id, (IHandler)handler, (Expression)new LegacyHandlerSubmissionExpression(null, null, editor.getSite()));
            this.fCorrectionHandlerActivations.add(activation);
        }
    }

    public void deregisterCommands() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        if (handlerService != null && this.fCorrectionHandlerActivations != null) {
            handlerService.deactivateHandlers(this.fCorrectionHandlerActivations);
            this.fCorrectionHandlerActivations = null;
        }
    }
}

