/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedQuery;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameQueryDescriptor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class AcceleoRenameQueryRefactoring
extends Refactoring {
    private static final String QUERY = "query";
    private static final String NEWNAME = "newName";
    private static final String REFERENCES = "references";
    protected String fNewQueryName;
    protected AcceleoPositionedQuery fQuery;
    protected boolean fUpdateReferences = true;
    private Map<IFile, TextFileChange> fChanges;
    private final String title = AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.RenameQueryTitle");
    private String fileName;

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.CheckingPreconditions"), 1);
            if (this.fQuery == null) {
                status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.NoQuerySpecified")));
            }
            this.fQuery.computeOccurrencesOfQuery();
            this.fChanges = new LinkedHashMap<IFile, TextFileChange>();
            if (this.fUpdateReferences) {
                this.putChangesNotInTheCurrentFile();
            }
            this.putChangesOfTheCurrentFile();
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private void putChangesNotInTheCurrentFile() {
        for (Match match : this.fQuery.getQueryMatches()) {
            ReferenceEntry entry;
            if (!(match.getElement() instanceof ReferenceEntry) || (entry = (ReferenceEntry)match.getElement()).getTemplateFile().getName().equals(this.fileName)) continue;
            IFile file = entry.getTemplateFile();
            TextFileChange tfc = null;
            MultiTextEdit edit = null;
            if (this.fChanges.containsKey(file) && this.fChanges.get(file).getEdit() instanceof MultiTextEdit) {
                tfc = this.fChanges.get(file);
                edit = (MultiTextEdit)this.fChanges.get(file).getEdit();
            } else {
                tfc = new TextFileChange(this.title, file);
                edit = new MultiTextEdit();
                tfc.setEdit((TextEdit)edit);
                tfc.setTextType("mtl");
            }
            String str = ((ReferenceEntry)match.getElement()).getMessage();
            int offset = str.lastIndexOf(this.fQuery.getQueryName());
            StringBuffer buf = new StringBuffer(str);
            int offsetTmp = this.computeOffset(buf);
            if (offset != 0 && offsetTmp != 0) {
                offset = offsetTmp;
            }
            edit.addChild((TextEdit)new ReplaceEdit(match.getOffset() + offset, this.fQuery.getQueryName().length(), this.fNewQueryName));
            this.fChanges.put(file, tfc);
        }
    }

    private void putChangesOfTheCurrentFile() {
        for (Match match : this.fQuery.getQueryMatches()) {
            ReferenceEntry entry;
            if (!(match.getElement() instanceof ReferenceEntry) || !(entry = (ReferenceEntry)match.getElement()).getTemplateFile().getName().equals(this.fileName)) continue;
            IFile file = entry.getTemplateFile();
            TextFileChange tfc = null;
            MultiTextEdit edit = null;
            if (this.fChanges.containsKey(file) && this.fChanges.get(file).getEdit() instanceof MultiTextEdit) {
                tfc = this.fChanges.get(file);
                edit = (MultiTextEdit)this.fChanges.get(file).getEdit();
            } else {
                tfc = new TextFileChange(this.title, file);
                edit = new MultiTextEdit();
                tfc.setEdit((TextEdit)edit);
                tfc.setTextType("mtl");
            }
            String str = ((ReferenceEntry)match.getElement()).getMessage();
            int offset = str.lastIndexOf(this.fQuery.getQueryName());
            StringBuffer buf = new StringBuffer(str);
            int offsetTmp = this.computeOffset(buf);
            if (offset != 0 && offsetTmp != 0) {
                offset = offsetTmp;
            }
            edit.addChild((TextEdit)new ReplaceEdit(match.getOffset() + offset, this.fQuery.getQueryName().length(), this.fNewQueryName));
            this.fChanges.put(file, tfc);
        }
    }

    private int computeOffset(StringBuffer buffer) {
        int offset = 0;
        Sequence sequence = null;
        Region region = null;
        switch (this.fQuery.getQuery().getVisibility().getValue()) {
            case 0: {
                sequence = new Sequence(QUERY, "private", this.fQuery.getQueryName());
                region = sequence.search(buffer);
                if (region.e() <= -1) break;
                offset = region.e() - this.fQuery.getQueryName().length();
                break;
            }
            case 1: {
                sequence = new Sequence(QUERY, "protected", this.fQuery.getQueryName());
                region = sequence.search(buffer);
                if (region.e() <= -1) break;
                offset = region.e() - this.fQuery.getQueryName().length();
                break;
            }
            case 2: {
                sequence = new Sequence(QUERY, "public", this.fQuery.getQueryName());
                region = sequence.search(buffer);
                if (region.e() <= -1) break;
                offset = region.e() - this.fQuery.getQueryName().length();
                break;
            }
        }
        return offset;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (AcceleoPositionedQuery.getInput().length == 0) {
            status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.NoQueryInFile")));
        }
        return status;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            CompositeChange change;
            monitor.beginTask(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.CreatingChanges"), 1);
            Collection<TextFileChange> changes = this.fChanges.values();
            CompositeChange compositeChange = change = new CompositeChange(this.getName(), changes.toArray(new Change[changes.size()])){

                public ChangeDescriptor getDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    String project = AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.RefactoringProjectName");
                    String description = String.valueOf(AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.RenamingQuery")) + " " + AcceleoRenameQueryRefactoring.this.fQuery.getQueryName();
                    String comment = AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.RenamingQueryWithNewName", AcceleoRenameQueryRefactoring.this.fQuery.getQueryName(), AcceleoRenameQueryRefactoring.this.fNewQueryName);
                    arguments.put(AcceleoRenameQueryRefactoring.QUERY, AcceleoRenameQueryRefactoring.this.fQuery.getQueryName());
                    arguments.put(AcceleoRenameQueryRefactoring.NEWNAME, AcceleoRenameQueryRefactoring.this.fNewQueryName);
                    arguments.put(AcceleoRenameQueryRefactoring.REFERENCES, Boolean.valueOf(AcceleoRenameQueryRefactoring.this.fUpdateReferences).toString());
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)new AcceleoRenameQueryDescriptor(project, description, comment, arguments));
                }
            };
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getName() {
        return this.title;
    }

    public void setQuery(AcceleoPositionedQuery currentQuery) {
        this.fQuery = currentQuery;
    }

    public AcceleoPositionedQuery getQuery() {
        return this.fQuery;
    }

    public void setUpdateReferences(boolean selection) {
        this.fUpdateReferences = selection;
    }

    public RefactoringStatus setNewQueryName(String text) {
        this.fNewQueryName = text;
        RefactoringStatus status = this.checkQueryName(this.fNewQueryName);
        status.merge(this.checkOverLoading());
        return status;
    }

    private RefactoringStatus checkOverLoading() {
        AcceleoPositionedQuery[] array;
        RefactoringStatus status = new RefactoringStatus();
        AcceleoPositionedQuery[] acceleoPositionedQueryArray = array = AcceleoPositionedQuery.getInput();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            AcceleoPositionedQuery acceleoPositionedQuery = acceleoPositionedQueryArray[n2];
            if (this.fNewQueryName.equals(acceleoPositionedQuery.getQueryName())) {
                EList listOfParametersOfTheCurrentQuery = this.fQuery.getQuery().getParameter();
                EList listOfParametersOfTheQueryWithTheSameName = acceleoPositionedQuery.getQuery().getParameter();
                if (listOfParametersOfTheCurrentQuery.size() == listOfParametersOfTheQueryWithTheSameName.size()) {
                    boolean overloadingError = true;
                    int j = 0;
                    while (j < listOfParametersOfTheCurrentQuery.size()) {
                        if (!((Variable)listOfParametersOfTheCurrentQuery.get(j)).getEType().equals(((Variable)listOfParametersOfTheQueryWithTheSameName.get(j)).getEType())) {
                            overloadingError = false;
                            break;
                        }
                        ++j;
                    }
                    if (overloadingError) {
                        status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.QueryOverloadingError")));
                    }
                }
            }
            ++n2;
        }
        return status;
    }

    private RefactoringStatus checkQueryName(String name) {
        RefactoringStatus status = new RefactoringStatus();
        int i = 0;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.InvalidQueryName")));
                break;
            }
            ++i;
        }
        return status;
    }

    public RefactoringStatus initialize(Map<String, String> arguments) {
        RefactoringStatus status = new RefactoringStatus();
        String value = arguments.get(QUERY);
        value = arguments.get(NEWNAME);
        if (value != null) {
            this.setNewQueryName(value);
        }
        if ((value = arguments.get(REFERENCES)) != null) {
            this.setUpdateReferences(Boolean.valueOf(value));
        }
        return status;
    }
}

