/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import com.google.common.collect.Iterators;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.base.collect.MultipleCollection;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;
import org.eclipse.sirius.viewpoint.description.tool.PasteDescription;

public class DiagramElementMappingQuery {
    private DiagramElementMapping mapping;
    private Collection<EObject> semantics;

    public DiagramElementMappingQuery(DiagramElementMapping mapping) {
        this.mapping = mapping;
    }

    public DiagramElementMappingQuery(EdgeMappingImport mapping) {
        this.mapping = (DiagramElementMapping)new IEdgeMappingQuery(mapping).getEdgeMapping().get();
    }

    public boolean isTypeOf(DMappingBased element) {
        DiagramElementMapping otherMapping = (DiagramElementMapping)element.getMapping();
        return EqualityHelper.areEquals((EObject)this.mapping, (EObject)otherMapping);
    }

    public Collection<ContainerDropDescription> getDropToolsInHierarchy() {
        ArrayList<ContainerDropDescription> descs = new ArrayList<ContainerDropDescription>();
        for (DiagramElementMapping mappingInHier : this.hierachy()) {
            if (!(mappingInHier instanceof DragAndDropTargetDescription)) continue;
            descs.addAll((Collection<ContainerDropDescription>)((DragAndDropTargetDescription)((Object)mappingInHier)).getDropDescriptions());
        }
        if (this.mapping instanceof DragAndDropTargetDescription) {
            descs.addAll((Collection<ContainerDropDescription>)((DragAndDropTargetDescription)((Object)this.mapping)).getDropDescriptions());
        }
        return descs;
    }

    public Collection<ContainerDropDescription> getDropTools() {
        ArrayList<ContainerDropDescription> dropTools = new ArrayList<ContainerDropDescription>();
        if (this.mapping instanceof AbstractMappingImport) {
            if (this.getDropToolsInHierarchy().isEmpty()) {
                if (this.mapping instanceof NodeMappingImport) {
                    dropTools.addAll(new DiagramElementMappingQuery(((NodeMappingImport)this.mapping).getImportedMapping()).getDropTools());
                } else if (this.mapping instanceof ContainerMappingImport) {
                    dropTools.addAll(new DiagramElementMappingQuery(((ContainerMappingImport)this.mapping).getImportedMapping()).getDropTools());
                }
            } else {
                dropTools.addAll(this.getDropToolsInHierarchy());
            }
        } else {
            dropTools.addAll(this.getDropToolsInHierarchy());
        }
        return dropTools;
    }

    private Collection<PasteDescription> getPasteToolsInHierarchy() {
        ArrayList<PasteDescription> descs = new ArrayList<PasteDescription>();
        for (DiagramElementMapping mappingInHier : this.hierachy()) {
            if (!(mappingInHier instanceof DragAndDropTargetDescription)) continue;
            descs.addAll((Collection<PasteDescription>)mappingInHier.getPasteDescriptions());
        }
        descs.addAll((Collection<PasteDescription>)this.mapping.getPasteDescriptions());
        return descs;
    }

    public Collection<PasteDescription> getAllPasteTools() {
        ArrayList<PasteDescription> pasteTools = new ArrayList<PasteDescription>();
        Collection<PasteDescription> pasteToolsInHierarchy = this.getPasteToolsInHierarchy();
        if (this.mapping instanceof AbstractMappingImport) {
            if (pasteToolsInHierarchy.isEmpty()) {
                if (this.mapping instanceof NodeMappingImport) {
                    pasteTools.addAll(new DiagramElementMappingQuery(((NodeMappingImport)this.mapping).getImportedMapping()).getAllPasteTools());
                } else if (this.mapping instanceof ContainerMappingImport) {
                    pasteTools.addAll(new DiagramElementMappingQuery(((ContainerMappingImport)this.mapping).getImportedMapping()).getAllPasteTools());
                }
            } else {
                pasteTools.addAll(pasteToolsInHierarchy);
            }
        } else {
            pasteTools.addAll(pasteToolsInHierarchy);
        }
        return pasteTools;
    }

    public boolean isInstanceOf(DMappingBased element) {
        DiagramElementMapping otherMapping = (DiagramElementMapping)element.getMapping();
        return this.isSuperTypeOf(otherMapping);
    }

    public boolean isSuperTypeOf(DiagramElementMapping otherMapping) {
        boolean isSuperTypeOf = EqualityHelper.areEquals((EObject)this.mapping, (EObject)otherMapping);
        Iterator<DiagramElementMapping> it = new DiagramElementMappingQuery(otherMapping).superTypes();
        while (it.hasNext() && !isSuperTypeOf) {
            if (!EqualityHelper.areEquals((EObject)this.mapping, (EObject)((EObject)it.next()))) continue;
            isSuperTypeOf = true;
        }
        return isSuperTypeOf;
    }

    public boolean isSubTypeOf(DiagramElementMapping superType) {
        boolean isSubTypeOf = false;
        Iterator<DiagramElementMapping> superTypes = this.superTypes();
        while (superTypes.hasNext() && !isSubTypeOf) {
            DiagramElementMapping diagramElementMapping = superTypes.next();
            isSubTypeOf = diagramElementMapping.equals(superType);
        }
        return isSubTypeOf;
    }

    public Iterable<DiagramElementMapping> hierachy() {
        return new SuperTypes(this.mapping);
    }

    public Iterator<DiagramElementMapping> superTypes() {
        return new SuperTypesIterator(this.mapping);
    }

    public boolean areInSameHiearchy(DiagramElementMapping other) {
        boolean isInSameHiearchy = false;
        if (this.mapping == other) {
            isInSameHiearchy = true;
        } else {
            DiagramElementMapping rootMapping2;
            DiagramElementMapping rootMapping1 = this.getRootMapping(this.mapping);
            if (EqualityHelper.areEquals((EObject)rootMapping1, (EObject)(rootMapping2 = this.getRootMapping(other)))) {
                isInSameHiearchy = true;
            }
        }
        return isInSameHiearchy;
    }

    public DiagramElementMapping getRootMapping() {
        return this.getRootMapping(this.mapping);
    }

    private DiagramElementMapping getRootMapping(DiagramElementMapping current) {
        Iterator<DiagramElementMapping> superTypes = new DiagramElementMappingQuery(current).superTypes();
        if (superTypes.hasNext()) {
            return (DiagramElementMapping)Iterators.getLast(superTypes);
        }
        return current;
    }

    public Option<String> getDomainClass() {
        String domainType = null;
        if (this.mapping instanceof AbstractNodeMapping) {
            domainType = ((AbstractNodeMapping)this.mapping).getDomainClass();
        } else if (this.mapping instanceof EdgeMapping && ((EdgeMapping)this.mapping).isUseDomainElement()) {
            domainType = ((EdgeMapping)this.mapping).getDomainClass();
        }
        return Options.newSome((Object)domainType);
    }

    public boolean isSynchronizedAndCreateElement(DDiagram dDiagram) {
        boolean result = dDiagram != null && this.mapping != null;
        result = result && this.mapping.isCreateElements() && (dDiagram.isSynchronized() || this.mapping.isSynchronizationLock());
        return result;
    }

    public boolean isSynchronizedAndCreateElement(DDiagramElement dDiagramElement) {
        return dDiagramElement != null && this.isSynchronizedAndCreateElement(dDiagramElement.getParentDiagram());
    }

    public boolean hasCandidatesExpression() {
        return this.mapping.getSemanticCandidatesExpression() != null && !StringUtil.isEmpty((String)this.mapping.getSemanticCandidatesExpression());
    }

    public Collection<EObject> evaluateCandidateExpression(DSemanticDiagram diagram, IInterpreter interpreter, DragAndDropTarget containerView) {
        EObject rootContent = this.getRootContent(diagram, interpreter, containerView);
        MultipleCollection semanticCandidatesEvaluation = new MultipleCollection();
        if (rootContent != null) {
            interpreter.setVariable("containerView", (Object)containerView);
            interpreter.setVariable("viewpoint", (Object)diagram);
            interpreter.setVariable("viewPoint", (Object)diagram);
            interpreter.setVariable("diagram", (Object)diagram);
            Collection candidates = null;
            try {
                candidates = interpreter.evaluateCollection(rootContent, this.mapping.getSemanticCandidatesExpression());
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DiagramElementMappingQuery_mappingCandidateExpressionEvaluationErrorMsg, this.mapping.getSemanticCandidatesExpression()), (Exception)((Object)e));
            }
            if (candidates != null && !candidates.isEmpty()) {
                semanticCandidatesEvaluation.addAll(candidates);
            }
            interpreter.unSetVariable("diagram");
            interpreter.unSetVariable("viewPoint");
            interpreter.unSetVariable("viewpoint");
            interpreter.unSetVariable("containerView");
        }
        return semanticCandidatesEvaluation;
    }

    private EObject getRootContent(DSemanticDiagram diagram, IInterpreter interpreter, DragAndDropTarget containerView) {
        String rootContentExpression;
        EObject rootContent = ((DSemanticDecorator)containerView).getTarget();
        if (containerView == diagram && !(this.mapping instanceof EdgeMapping) && !StringUtil.isEmpty((String)(rootContentExpression = ((DDiagram)containerView).getDescription().getRootExpression()))) {
            interpreter.setVariable("viewpoint", (Object)diagram);
            interpreter.setVariable("diagram", (Object)diagram);
            EObject computedRoot = null;
            try {
                computedRoot = interpreter.evaluateEObject(rootContent, diagram.getDescription().getRootExpression());
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DiagramElementMappingQuery_diagramRootExpressionEvaluationErrorMsg, diagram.getDescription().getRootExpression()), (Exception)((Object)e));
            }
            interpreter.unSetVariable("diagram");
            interpreter.unSetVariable("viewpoint");
            if (computedRoot != null) {
                rootContent = computedRoot;
            }
        }
        return rootContent;
    }

    public Collection<EObject> getAllCandidates(Session session, ModelAccessor modelAccessor) {
        Option<String> domainClass = this.getDomainClass();
        if (this.semantics == null) {
            this.semantics = new ArrayList<EObject>();
            if (domainClass.some()) {
                for (Resource resource : session.getSemanticResources()) {
                    for (EObject root : resource.getContents()) {
                        this.semantics.addAll(modelAccessor.eAllContents(root, (String)domainClass.get()));
                    }
                }
            }
        }
        return this.semantics;
    }

    private static class SuperTypes
    implements Iterable<DiagramElementMapping> {
        private DiagramElementMapping mapping;

        SuperTypes(DiagramElementMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public Iterator<DiagramElementMapping> iterator() {
            return new SuperTypesIterator(this.mapping);
        }
    }

    private static class SuperTypesIterator
    implements Iterator<DiagramElementMapping> {
        private DiagramElementMapping cur;

        SuperTypesIterator(DiagramElementMapping map) {
            this.cur = map;
        }

        @Override
        public boolean hasNext() {
            return this.doGetNext() != null;
        }

        @Override
        public DiagramElementMapping next() {
            this.cur = this.doGetNext();
            if (this.cur == null) {
                throw new NoSuchElementException();
            }
            return this.cur;
        }

        private DiagramElementMapping doGetNext() {
            DiagramElementMapping next = null;
            if (this.cur instanceof NodeMappingImport) {
                next = ((NodeMappingImport)this.cur).getImportedMapping();
            } else if (this.cur instanceof EdgeMappingImport) {
                IEdgeMappingQuery query = new IEdgeMappingQuery(((EdgeMappingImport)((Object)this.cur)).getImportedMapping());
                next = (DiagramElementMapping)query.getEdgeMapping().get();
            } else if (this.cur instanceof ContainerMappingImport) {
                next = ((ContainerMappingImport)this.cur).getImportedMapping();
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

