/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.settings;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryUtil;

public final class GitSettings {
    private GitSettings() {
    }

    public static int getRemoteConnectionTimeout() {
        return Platform.getPreferencesService().getInt(Activator.getPluginId(), "core_remote_connection_timeout", 60, null);
    }

    public static Path getDefaultRepositoryDir() {
        return Paths.get(RepositoryUtil.getDefaultRepositoryDir(), new String[0]);
    }

    public static Collection<Path> getConfiguredRepositoryDirectories() {
        return Activator.getDefault().getRepositoryUtil().getRepositories().stream().map(string -> Paths.get(string, new String[0])).collect(Collectors.toSet());
    }

    public static void addConfiguredRepository(Path gitDir) throws IllegalArgumentException {
        Activator.getDefault().getRepositoryUtil().addConfiguredRepository(Objects.requireNonNull(gitDir).toFile());
    }
}

