/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.wizard.atlproject;

import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class AtlProjectCreator
extends Wizard
implements INewWizard,
IExecutableExtension {
    private WizardNewProjectCreationPage page;
    private IConfigurationElement configElement;
    private IProject modelProject;

    public AtlProjectCreator() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString("AtlProjectCreator.Title"));
    }

    public void addPages() {
        this.page = new WizardNewProjectCreationPage(Messages.getString("AtlProjectCreator.Page.Name"));
        this.page.setTitle(Messages.getString("AtlProjectCreator.Title"));
        this.page.setDescription(Messages.getString("AtlProjectCreator.Page.Description"));
        this.page.setImageDescriptor(AtlUIPlugin.getImageDescriptor("ATLWizard.png"));
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String projectName = this.page.getProjectName();
        try {
            IWorkspace wks = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot wksroot = wks.getRoot();
            this.modelProject = wksroot.getProject(projectName);
            if (!this.modelProject.exists()) {
                this.modelProject.create(null);
            }
            if (!this.modelProject.isOpen()) {
                this.modelProject.open(null);
            }
            this.addNature(this.modelProject, "org.eclipse.m2m.atl.adt.builder.atlNature");
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addNature(IProject project, String natureId) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }
}

