/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.info;

import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ArrayLoadInstruction;
import com.ibm.wala.shrikeBT.ArrayStoreInstruction;
import com.ibm.wala.shrikeBT.BinaryOpInstruction;
import com.ibm.wala.shrikeBT.CheckCastInstruction;
import com.ibm.wala.shrikeBT.ComparisonInstruction;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.ConversionInstruction;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.InstanceofInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.ShiftInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.UnaryOpInstruction;

public class InstructionTypeCounter
implements MethodData.Results {
    private static final String key = InstructionTypeCounter.class.getName();
    private int countMonitors;
    private int countGets;
    private int countPuts;
    private int countArrayLoads;
    private int countArrayStores;
    private int countInvokes;
    private int countArrayLengths;
    private int countBinaryOps;
    private int countCheckCasts;
    private int countComparisons;
    private int countConditionalBranches;
    private int countConstants;
    private int countConversions;
    private int countDups;
    private int countGotos;
    private int countInstanceOfs;
    private int countLocalLoads;
    private int countLocalStores;
    private int countNews;
    private int countPops;
    private int countReturns;
    private int countShifts;
    private int countSwaps;
    private int countSwitches;
    private int countThrows;
    private int countUnaryOps;

    InstructionTypeCounter(MethodData info) {
        this.recalculateFrom(info.getInstructions());
    }

    private void recalculateFrom(Instruction[] instructions) {
        this.countMonitors = 0;
        this.countGets = 0;
        this.countPuts = 0;
        this.countArrayLoads = 0;
        this.countArrayStores = 0;
        this.countInvokes = 0;
        this.countArrayLengths = 0;
        this.countBinaryOps = 0;
        this.countCheckCasts = 0;
        this.countComparisons = 0;
        this.countConditionalBranches = 0;
        this.countConstants = 0;
        this.countConversions = 0;
        this.countDups = 0;
        this.countGotos = 0;
        this.countInstanceOfs = 0;
        this.countLocalLoads = 0;
        this.countLocalStores = 0;
        this.countNews = 0;
        this.countPops = 0;
        this.countReturns = 0;
        this.countShifts = 0;
        this.countSwaps = 0;
        this.countSwitches = 0;
        this.countThrows = 0;
        this.countUnaryOps = 0;
        Instruction.Visitor visitor = new Instruction.Visitor(){

            public void visitArrayLength(ArrayLengthInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countArrayLengths = instructionTypeCounter.countArrayLengths + 1;
            }

            public void visitBinaryOp(BinaryOpInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countBinaryOps = instructionTypeCounter.countBinaryOps + 1;
            }

            public void visitCheckCast(CheckCastInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countCheckCasts = instructionTypeCounter.countCheckCasts + 1;
            }

            public void visitComparison(ComparisonInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countComparisons = instructionTypeCounter.countComparisons + 1;
            }

            public void visitConditionalBranch(ConditionalBranchInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countConditionalBranches = instructionTypeCounter.countConditionalBranches + 1;
            }

            public void visitConstant(ConstantInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countConstants = instructionTypeCounter.countConstants + 1;
            }

            public void visitConversion(ConversionInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countConversions = instructionTypeCounter.countConversions + 1;
            }

            public void visitDup(DupInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countDups = instructionTypeCounter.countDups + 1;
            }

            public void visitGoto(GotoInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countGotos = instructionTypeCounter.countGotos + 1;
            }

            public void visitInstanceof(InstanceofInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countInstanceOfs = instructionTypeCounter.countInstanceOfs + 1;
            }

            public void visitLocalLoad(LoadInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countLocalLoads = instructionTypeCounter.countLocalLoads + 1;
            }

            public void visitLocalStore(StoreInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countLocalStores = instructionTypeCounter.countLocalStores + 1;
            }

            public void visitNew(NewInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countNews = instructionTypeCounter.countNews + 1;
            }

            public void visitPop(PopInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countPops = instructionTypeCounter.countPops + 1;
            }

            public void visitReturn(ReturnInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countReturns = instructionTypeCounter.countReturns + 1;
            }

            public void visitShift(ShiftInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countShifts = instructionTypeCounter.countShifts + 1;
            }

            public void visitSwap(SwapInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countSwaps = instructionTypeCounter.countSwaps + 1;
            }

            public void visitSwitch(SwitchInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countSwitches = instructionTypeCounter.countSwitches + 1;
            }

            public void visitThrow(ThrowInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countThrows = instructionTypeCounter.countThrows + 1;
            }

            public void visitUnaryOp(UnaryOpInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countUnaryOps = instructionTypeCounter.countUnaryOps + 1;
            }

            public void visitArrayLoad(ArrayLoadInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countArrayLoads = instructionTypeCounter.countArrayLoads + 1;
            }

            public void visitArrayStore(ArrayStoreInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countArrayStores = instructionTypeCounter.countArrayStores + 1;
            }

            public void visitGet(GetInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countGets = instructionTypeCounter.countGets + 1;
            }

            public void visitPut(PutInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countPuts = instructionTypeCounter.countPuts + 1;
            }

            public void visitMonitor(MonitorInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countMonitors = instructionTypeCounter.countMonitors + 1;
            }

            public void visitInvoke(InvokeInstruction instruction) {
                InstructionTypeCounter instructionTypeCounter = InstructionTypeCounter.this;
                instructionTypeCounter.countInvokes = instructionTypeCounter.countInvokes + 1;
            }
        };
        int i = 0;
        while (i < instructions.length) {
            instructions[i].visit(visitor);
            ++i;
        }
    }

    public boolean notifyUpdate(MethodData info, Instruction[] newInstructions, ExceptionHandler[][] newHandlers, int[] newInstructionMap) {
        return true;
    }

    public static int getArrayLoadCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countArrayLoads;
    }

    public static int getArrayStoreCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countArrayStores;
    }

    public static int getGetCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countGets;
    }

    public static int getPutCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countPuts;
    }

    public static int getMonitorCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countMonitors;
    }

    public static int getInvokeCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countInvokes;
    }

    public static int getComparisonCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countComparisons;
    }

    public static int getArrayLengthCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countArrayLengths;
    }

    public static int getConstantCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countConstants;
    }

    public static int getShiftCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countShifts;
    }

    public static int getSwitchesCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countSwitches;
    }

    public static int getSwapCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countSwaps;
    }

    public static int getBinaryOpCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countBinaryOps;
    }

    public static int getCheckCastCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countCheckCasts;
    }

    public static int getThrowCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countThrows;
    }

    public static int getConditionalBranchCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countConditionalBranches;
    }

    public static int getConversionCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countConversions;
    }

    public static int getDupCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countDups;
    }

    public static int getGotoCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countGotos;
    }

    public static int getReturnCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countReturns;
    }

    public static int getInstanceOfCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countInstanceOfs;
    }

    public static int getLocalLoadCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countLocalLoads;
    }

    public static int getLocalStoreCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countLocalStores;
    }

    public static int getNewCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countNews;
    }

    public static int getPopCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countPops;
    }

    public static int getUnaryOpCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countUnaryOps;
    }

    private static InstructionTypeCounter getCounter(MethodData info) {
        InstructionTypeCounter c = (InstructionTypeCounter)info.getInfo(key);
        if (c == null) {
            c = new InstructionTypeCounter(info);
            info.putInfo(key, c);
        }
        return c;
    }
}

