/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.language;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.imp.editor.OutlineContentProviderBase;
import org.eclipse.imp.editor.OutlineLabelProvider;
import org.eclipse.imp.indexing.IndexContributorBase;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IASTAdapter;
import org.eclipse.imp.services.IAnnotationHover;
import org.eclipse.imp.services.IAutoEditStrategy;
import org.eclipse.imp.services.IContentProposer;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.imp.services.IFoldingUpdater;
import org.eclipse.imp.services.IHelpService;
import org.eclipse.imp.services.IHoverHelper;
import org.eclipse.imp.services.ILabelProvider;
import org.eclipse.imp.services.ILanguageActionsContributor;
import org.eclipse.imp.services.ILanguageSyntaxProperties;
import org.eclipse.imp.services.IOccurrenceMarker;
import org.eclipse.imp.services.IOutliner;
import org.eclipse.imp.services.IRefactoringContributor;
import org.eclipse.imp.services.IReferenceResolver;
import org.eclipse.imp.services.ISourceFormatter;
import org.eclipse.imp.services.ISourceHyperlinkDetector;
import org.eclipse.imp.services.ITokenColorer;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.imp.utils.ExtensionException;
import org.eclipse.imp.utils.ExtensionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFactory {
    private static ServiceFactory sInstance;
    static final String AUTO_EDIT_SERVICE = "autoEditStrategy";
    static final String ANNOTATION_HOVER_SERVICE = "annotationHover";
    static final String AST_ADAPTER_SERVICE = "astAdapter";
    static final String CONTENT_PROPOSER_SERVICE = "contentProposer";
    static final String DOCUMENTATION_PROVIDER_SERVICE = "documentationProvider";
    static final String EDITOR_ACTION_SERVICE = "editorActionContributions";
    static final String FOLDING_SERVICE = "foldingUpdater";
    static final String FORMATTER_SERVICE = "formatter";
    static final String HOVER_HELPER_SERVICE = "hoverHelper";
    static final String HYPERLINK_SERVICE = "hyperLink";
    static final String IMAGE_DECORATOR_SERVICE = "imageDecorator";
    static final String INDEX_CONTRIBUTOR_SERVICE = "indexContributor";
    static final String LABEL_PROVIDER_SERVICE = "labelProvider";
    static final String LISTENER_SERVICE = "modelListener";
    static final String MODEL_BUILDER_SERVICE = "modelTreeBuilder";
    static final String OCCURRENCE_MARKER = "markOccurrences";
    static final String OUTLINE_CONTENT_PROVIDER_SERVICE = "outlineContentProvider";
    static final String OUTLINER_SERVICE = "outliner";
    static final String PARSER_SERVICE = "parser";
    static final String PREFERENCES_SERVICE = "preferencesDialog";
    static final String PREFERENCES_SPECIFICATION = "preferencesSpecification";
    static final String REFACTORING_CONTRIBUTIONS_SERVICE = "refactoringContributions";
    static final String REFERENCE_RESOLVER_SERVICE = "referenceResolvers";
    static final String SYNTAX_PROPS = "syntaxProps";
    static final String TOKEN_COLORER_SERVICE = "tokenColorer";
    static final String VIEWER_FILTER_SERVICE = "viewerFilter";
    static final String EDITOR_SERVICE = "editorService";
    static final String CONTEXT_HELPER_SERVICE = "contextHelper";

    protected ServiceFactory() {
    }

    public static ServiceFactory getInstance() {
        if (sInstance == null) {
            sInstance = new ServiceFactory();
        }
        return sInstance;
    }

    public static ServiceFactory otherGetInstance() {
        return sInstance;
    }

    public IContentProposer getContentProposer(Language lang) {
        try {
            return (IContentProposer)this.loadService(lang, CONTENT_PROPOSER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of CONTENT_PROPOSER_SERVICE does not implement IContentProposer", e);
            return null;
        }
    }

    public IHoverHelper getHoverHelper(Language lang) {
        try {
            return (IHoverHelper)this.loadService(lang, HOVER_HELPER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of HOVER_HELPER_SERVICE does not implement IHoverHelper", e);
            return null;
        }
    }

    public ITokenColorer getTokenColorer(Language lang) {
        try {
            return (ITokenColorer)this.loadService(lang, TOKEN_COLORER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of TOKEN_COLORER_SERVICE does not implement ITokenColorer", e);
            return null;
        }
    }

    public IndexContributorBase getIndexContributor(Language lang) {
        try {
            return (IndexContributorBase)this.loadService(lang, INDEX_CONTRIBUTOR_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of INDEX_CONTRIBUTOR_SERVICE does not implement IndexContributorBase", e);
            return null;
        }
    }

    public IParseController getParseController(Language lang) {
        try {
            return (IParseController)this.loadService(lang, PARSER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of PARSER_SERVICE does not implement IParseController", e);
            return null;
        }
    }

    public TreeModelBuilderBase getTreeModelBuilder(Language lang) {
        try {
            return (TreeModelBuilderBase)this.loadService(lang, MODEL_BUILDER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of MODEL_BUILDER_SERVICE does not implement TreeModelBuilderBase", e);
            return null;
        }
    }

    public IModelListener getModelListener(Language lang) {
        try {
            return (IModelListener)this.loadService(lang, LISTENER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of LISTENER_SERVICE does not implement IModelListener", e);
            return null;
        }
    }

    public IAutoEditStrategy getAutoEditStrategy(Language lang) {
        try {
            return (IAutoEditStrategy)this.loadService(lang, AUTO_EDIT_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of AUTO_EDIT_SERVICE does not implement IAutoEditStrategy", e);
            return null;
        }
    }

    public IFoldingUpdater getFoldingUpdater(Language lang) {
        try {
            return (IFoldingUpdater)this.loadService(lang, FOLDING_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of FOLDING_SERVICE does not implement IFoldingUpdater", e);
            return null;
        }
    }

    public IAnnotationHover getAnnotationHover(Language lang) {
        try {
            return (IAnnotationHover)this.loadService(lang, ANNOTATION_HOVER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of ANNOTATION_HOVER_SERVICE does not implement IAnnotationHover", e);
            return null;
        }
    }

    public ISourceFormatter getSourceFormatter(Language lang) {
        try {
            return (ISourceFormatter)this.loadService(lang, FORMATTER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of FORMATTER_SERVICE does not implement ISourceFormatter", e);
            return null;
        }
    }

    public ISourceHyperlinkDetector getSourceHyperlinkDetector(Language lang) {
        try {
            return (ISourceHyperlinkDetector)this.loadService(lang, HYPERLINK_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of HYPERLINK_SERVICE does not implement ISourceHyperlinkDetector", e);
            return null;
        }
    }

    public ILabelProvider getLabelProvider(Language lang) {
        try {
            return (ILabelProvider)this.loadService(lang, LABEL_PROVIDER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of LABEL_PROVIDER_SERVICE does not implement ILabelProvider", e);
            return null;
        }
    }

    public OutlineContentProviderBase getOutlineContentProvider(Language lang) {
        try {
            return (OutlineContentProviderBase)this.loadService(lang, OUTLINE_CONTENT_PROVIDER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of OUTLINE_CONTENT_PROVIDER_SERVICE does not implement OutlineContentProviderBase", e);
            return null;
        }
    }

    public Set<IRefactoringContributor> getRefactoringContributors(Language lang) {
        try {
            Set<ILanguageService> services = this.loadServices(lang, REFACTORING_CONTRIBUTIONS_SERVICE);
            HashSet<IRefactoringContributor> refactoringContribs = new HashSet<IRefactoringContributor>();
            for (ILanguageService s : services) {
                refactoringContribs.add((IRefactoringContributor)s);
            }
            return refactoringContribs;
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of SERVICE does not implement Set<ILanguageSerivice>", e);
            return null;
        }
    }

    public IReferenceResolver getReferenceResolver(Language lang) {
        try {
            return (IReferenceResolver)this.loadService(lang, REFERENCE_RESOLVER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of REFERENCE_RESOLVER_SERVICE does not implement IReferenceResolver", e);
            return null;
        }
    }

    public Set<ILanguageActionsContributor> getLanguageActionsContributors(Language lang) {
        try {
            Set<ILanguageService> services = this.loadServices(lang, EDITOR_ACTION_SERVICE);
            HashSet<ILanguageActionsContributor> actionContributors = new HashSet<ILanguageActionsContributor>();
            for (ILanguageService s : services) {
                actionContributors.add((ILanguageActionsContributor)s);
            }
            return actionContributors;
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of EDITOR_ACTION_SERVICE does not implement ILanguageActionConstributor", e);
            return null;
        }
    }

    public IDocumentationProvider getDocumentationProvider(Language lang) {
        try {
            return (IDocumentationProvider)this.loadService(lang, DOCUMENTATION_PROVIDER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of DOCUMENTATION_PROVIDER_SERVICE does not implement IDocumentationProvider", e);
            return null;
        }
    }

    public IOccurrenceMarker getOccurrenceMarker(Language lang) {
        try {
            return (IOccurrenceMarker)this.loadService(lang, OCCURRENCE_MARKER);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of OCCURRENCE_MARKER does not implement IOccurrenceMarker", e);
            return null;
        }
    }

    public ILanguageSyntaxProperties getSyntaxProperties(Language lang) {
        try {
            return (ILanguageSyntaxProperties)this.loadService(lang, SYNTAX_PROPS);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of SYNTAX_PROPS does not implement ILanguageSyntaxProperties", e);
            return null;
        }
    }

    public OutlineLabelProvider.IElementImageProvider getElementImageProvider(Language lang) {
        try {
            return (OutlineLabelProvider.IElementImageProvider)this.loadService(lang, IMAGE_DECORATOR_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of IMAGE_DECORATOR_SERVICE does not implement IElementImageProvider", e);
            return null;
        }
    }

    public IOutliner getOutliner(Language lang) {
        try {
            return (IOutliner)this.loadService(lang, OUTLINER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of OLD_OUTLINER_SERVICE does not implement IOutliner", e);
            return null;
        }
    }

    public IASTAdapter getASTAdapter(Language lang) {
        try {
            return (IASTAdapter)((Object)this.loadService(lang, AST_ADAPTER_SERVICE));
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of AST_ADAPTER_SERVICE does not implement IASTAdapter", e);
            return null;
        }
    }

    public Set<IModelListener> getEditorServices(Language lang) {
        HashSet<IModelListener> result = new HashSet<IModelListener>();
        for (ILanguageService service : this.createExtensions(lang, EDITOR_SERVICE)) {
            result.add((IModelListener)service);
        }
        return result;
    }

    private ILanguageService createExtension(Language lang, String id) {
        try {
            return ExtensionFactory.createServiceExtension(lang, id);
        }
        catch (ExtensionException e) {
            RuntimePlugin.getInstance().logException("Failed to create extension: " + id, e);
            return null;
        }
    }

    private Set<ILanguageService> createExtensions(Language lang, String id) {
        try {
            return ExtensionFactory.createServiceExtensionSet(lang, id);
        }
        catch (ExtensionException e) {
            RuntimePlugin.getInstance().logException("Failed to create set of extensions for: " + id, e);
            return new HashSet<ILanguageService>();
        }
    }

    private Set<ILanguageService> loadServices(Language lang, String serviceId) {
        return this.createExtensions(lang, serviceId);
    }

    private ILanguageService loadService(Language lang, String name) {
        if (lang == null) {
            RuntimePlugin.getInstance().writeErrorMsg("Null language for service = " + name);
            return null;
        }
        if (name == null) {
            RuntimePlugin.getInstance().writeErrorMsg("Null service for language = " + lang);
            return null;
        }
        return this.createExtension(lang, name);
    }

    public IHelpService getContextHelper(Language lang) {
        try {
            return (IHelpService)this.loadService(lang, CONTEXT_HELPER_SERVICE);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of CONTEXT_HELP_SERVICE does not implement IHelpService", e);
            return null;
        }
    }
}

