/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtcore.environment;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.qvt.declarative.ecore.QVTBase.Function;
import org.eclipse.qvt.declarative.ecore.QVTBase.FunctionParameter;
import org.eclipse.qvt.declarative.ecore.QVTBase.QVTBaseFactory;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.parser.environment.CSTChildEnvironment;
import org.eclipse.qvt.declarative.parser.plugin.QVTParserPlugin;
import org.eclipse.qvt.declarative.parser.qvtcore.cst.QueryCS;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.IQVTcNodeEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcTransformationEnvironment;
import org.eclipse.qvt.declarative.parser.utils.CSTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTcQueryEnvironment
extends QVTcEnvironment<IQVTcNodeEnvironment, QVTcTransformationEnvironment, Function, QueryCS> {
    private final String name;
    private final List<FunctionParameter> parameters = new ArrayList<FunctionParameter>();

    public QVTcQueryEnvironment(QVTcTransformationEnvironment env, QueryCS queryCS) {
        super(env, null, queryCS);
        EList names = queryCS.getPathName().getSequenceOfNames();
        this.name = (String)names.get(names.size() - 1);
    }

    public void addParameter(FunctionParameter parameter) {
        this.parameters.add(parameter);
        this.addElement(parameter.getName(), (Variable)parameter, true);
    }

    protected void addedVariable(String name, Variable<EClassifier, EParameter> variable, boolean isExplicit) {
        if (variable == null) {
            return;
        }
        if (!(variable instanceof FunctionParameter)) {
            QVTParserPlugin.logError((String)("non-derived FunctionParameter in " + this.getClass().getName() + ".addedVariable"), null);
        }
    }

    public Function getQuery() {
        return (Function)this.ast;
    }

    public Function resolveQuery(EClassifier returnType) {
        Transformation transformation = this.getTransformation();
        Function match = this.findMatchingQuery(transformation, this.name, this.parameters);
        if (match == null) {
            this.internalSetAST((Notifier)QVTBaseFactory.eINSTANCE.createFunction());
            this.internalSetAdapter();
            this.rootEnvironment.initASTMapping((Object)this.ast, this.cst);
            ((QueryCS)this.cst).getPathName().setAst((Object)this.ast);
            ((Function)this.ast).setName(this.name);
            ((Function)this.ast).setEType(returnType);
            ((Function)this.ast).getEParameters().addAll(this.parameters);
            transformation.getEOperations().add((Object)((EOperation)this.ast));
            return (Function)this.ast;
        }
        CSTNode cstNode = this.getCSTNode();
        if (match.getEType() != returnType) {
            String message = "Inconsistent return type previously '" + this.formatType(match.getEType()) + "'";
            this.analyzerError(message, "QueryCS", cstNode);
        }
        this.ast = match;
        ((QueryCS)this.cst).setAst(this.ast);
        if (((QueryCS)cstNode).getOclExpression() != null) {
            QueryCS otherQuery = (QueryCS)((QVTcQueryEnvironment)CSTChildEnvironment.getEnvironmentFromAST((Notifier)this.ast, QVTcQueryEnvironment.class)).getCSTNode();
            OCLExpressionCS oclExpression = otherQuery.getOclExpression();
            if (oclExpression != null) {
                String message = "Redefinition of '" + this.formatName(this.ast) + "' ignored";
                this.analyzerError(message, "QueryCS", cstNode);
                CSTUtils.setASTErrorNode((CSTNode)oclExpression, (String)message);
            } else {
                ((Function)this.ast).getEParameters().clear();
                ((Function)this.ast).getEParameters().addAll(this.parameters);
            }
        }
        return null;
    }

    public EClassifier tryLookupClassifier(List<String> names) throws LookupException {
        return ((QVTcTransformationEnvironment)this.getParentEnvironment()).tryLookupClassifier(names);
    }
}

