/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.ConstantTargetCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.MultipleEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NavigableEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NonNullInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.PredicateEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.PredicateNavigationEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.CastEdge;
import org.eclipse.qvtd.pivot.qvtschedule.ComposedNode;
import org.eclipse.qvtd.pivot.qvtschedule.DependencyNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.ErrorNode;
import org.eclipse.qvtd.pivot.qvtschedule.InputNode;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.OperationNode;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PredicateEdge;
import org.eclipse.qvtd.pivot.qvtschedule.RecursionEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.UnknownNode;
import org.eclipse.qvtd.pivot.qvtschedule.util.AbstractExtendingQVTscheduleVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class CheckedConditionAnalysis {
    protected final @NonNull Partition partition;
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ReachabilityForest reachabilityForest;
    private final @Nullable Set<@NonNull Property> allCheckedProperties;
    private final @NonNull List<@NonNull Edge> oldUnconditionalEdges;

    public CheckedConditionAnalysis(@NonNull MappingPartitionAnalysis<?> partitionAnalysis, @NonNull ScheduleManager scheduleManager) {
        this.partition = partitionAnalysis.getPartition();
        this.scheduleManager = scheduleManager;
        this.reachabilityForest = partitionAnalysis.getReachabilityForest();
        this.allCheckedProperties = this.computeCheckedProperties();
        this.oldUnconditionalEdges = this.computeOldUnconditionalEdges();
    }

    public @NonNull Set<@NonNull CheckedCondition> computeCheckedConditions() {
        String name = this.partition.getName();
        if ("mapVariableExp_referredVariable_Helper_qvtr".equals(name)) {
            this.getClass();
        }
        HashSet<@NonNull CheckedCondition> checkedConditions = new HashSet<CheckedCondition>();
        Visitor visitor = new Visitor(checkedConditions);
        visitor.analyze();
        return checkedConditions;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable Set<@NonNull Property> computeCheckedProperties() {
        String name = this.partition.getName();
        HashSet<@NonNull Property> allCheckedProperties = new HashSet<Property>();
        RootDomainUsageAnalysis.DomainUsageConstant anyUsage = this.scheduleManager.getDomainUsageAnalysis().getAnyUsage();
        for (TypedModel typedModel : anyUsage.getTypedModels()) {
            @NonNull Set checkedEdges = this.partition.getCheckedEdges(typedModel);
            if (checkedEdges == null) continue;
            for (NavigableEdge checkedEdge : checkedEdges) {
                Property asProperty = QVTscheduleUtil.getProperty((NavigableEdge)checkedEdge);
                allCheckedProperties.add(asProperty);
                Property asOppositeProperty = asProperty.getOpposite();
                if (asOppositeProperty == null) continue;
                allCheckedProperties.add(asOppositeProperty);
            }
        }
        return allCheckedProperties;
    }

    private @NonNull List<@NonNull Edge> computeOldUnconditionalEdges() {
        ArrayList<@NonNull Edge> oldEdges = new ArrayList<Edge>();
        for (Edge edge : this.partition.getPartialEdges()) {
            Node targetNode;
            Role targetNodeRole;
            Node sourceNode;
            Role sourceNodeRole;
            Role edgeRole = this.partition.getRole(edge);
            if (edgeRole == null || !edgeRole.isOld() || !edge.isUnconditional() || (sourceNodeRole = this.partition.getRole(sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge))) == null || !sourceNodeRole.isOld() || (targetNodeRole = this.partition.getRole(targetNode = QVTscheduleUtil.getTargetNode((Edge)edge))) == null || !targetNodeRole.isOld()) continue;
            oldEdges.add(edge);
        }
        Collections.sort(oldEdges, this.reachabilityForest.getEdgeCostComparator());
        return oldEdges;
    }

    public @NonNull Set<@NonNull Property> getAllCheckedProperties() {
        return (Set)ClassUtil.nonNullState(this.allCheckedProperties);
    }

    public @NonNull Iterable<@NonNull Edge> getOldUnconditionalEdges() {
        return this.oldUnconditionalEdges;
    }

    protected class Visitor
    extends AbstractExtendingQVTscheduleVisitor<Object, Set<CheckedCondition>> {
        private Set<@NonNull NavigableEdge> checkedNavigableEdges;
        protected final @NonNull CompleteModel completeModel;

        public Visitor(Set<CheckedCondition> checkedConditions) {
            super(checkedConditions);
            this.checkedNavigableEdges = null;
            this.completeModel = CheckedConditionAnalysis.this.scheduleManager.getEnvironmentFactory().getMetamodelManager().getCompleteModel();
        }

        public void analyze() {
            String name = CheckedConditionAnalysis.this.partition.getName();
            if ("mapVariableExp_referredVariable_Helper_qvtr".equals(name)) {
                ((Object)((Object)this)).getClass();
            }
            for (Edge edge : CheckedConditionAnalysis.this.oldUnconditionalEdges) {
                edge.accept((org.eclipse.ocl.pivot.util.Visitor)this);
            }
            for (Node node : CheckedConditionAnalysis.this.partition.getPartialNodes()) {
                Role nodeRole = CheckedConditionAnalysis.this.partition.getRole(node);
                if (nodeRole == null || !nodeRole.isOld() || !node.isUnconditional()) continue;
                node.accept((org.eclipse.ocl.pivot.util.Visitor)this);
            }
        }

        private boolean isCheckedNavigation(@NonNull NavigationEdge edge) {
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
            Role sourceNodeRole = CheckedConditionAnalysis.this.partition.getRole(sourceNode);
            assert (sourceNodeRole != null);
            Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
            Role targetNodeRole = CheckedConditionAnalysis.this.partition.getRole(targetNode);
            assert (targetNodeRole != null);
            return targetNodeRole.isConstant() && !sourceNodeRole.isNew();
        }

        public @Nullable Element visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
        }

        public Object visitCastEdge(@NonNull CastEdge castEdge) {
            ((Set)this.context).add(new CastEdgeCheckedCondition((NavigableEdge)castEdge));
            return null;
        }

        public Object visitComposedNode(@NonNull ComposedNode object) {
            return this.visiting((Visitable)object);
        }

        public Object visitDependencyNode(@NonNull DependencyNode object) {
            return this.visiting((Visitable)object);
        }

        public Object visitEdge(@NonNull Edge object) {
            return null;
        }

        public Object visitErrorNode(@NonNull ErrorNode object) {
            return this.visiting((Visitable)object);
        }

        public Object visitInputNode(@NonNull InputNode object) {
            return this.visiting((Visitable)object);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public Object visitNavigableEdge(@NonNull NavigableEdge navigableEdge) {
            CompleteClass targetNodeCompleteClass;
            Role navigableEdgeRole = CheckedConditionAnalysis.this.partition.getRole((Edge)navigableEdge);
            assert (navigableEdgeRole != null);
            NavigableEdge checkedEdge = QVTscheduleUtil.getPrimaryEdge((NavigableEdge)navigableEdge);
            NavigableEdge oppositeEdge = checkedEdge.getOppositeEdge();
            if (oppositeEdge != null) {
                Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)checkedEdge);
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)checkedEdge);
                Integer sourceCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(sourceNode);
                Integer targetCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(targetNode);
                if (sourceCost != null && targetCost != null && targetCost > 0 && targetCost < sourceCost) {
                    checkedEdge = oppositeEdge;
                }
            }
            Property checkedProperty = checkedEdge.getProperty();
            @NonNull Set allCheckedProperties2 = CheckedConditionAnalysis.this.allCheckedProperties;
            if (allCheckedProperties2 != null && allCheckedProperties2.contains(checkedProperty)) {
                if (this.checkedNavigableEdges == null) {
                    this.checkedNavigableEdges = new HashSet<NavigableEdge>();
                }
                if (this.checkedNavigableEdges.add(checkedEdge)) {
                    ((Set)this.context).add(new NavigableEdgeCheckedCondition(checkedEdge));
                }
            }
            Node targetNode = QVTscheduleUtil.getTargetNode((Edge)navigableEdge);
            if (navigableEdgeRole.isPredicated() && targetNode.isConstant()) {
                ((Set)this.context).add(new ConstantTargetCheckedCondition(navigableEdge));
            }
            Property property = QVTscheduleUtil.getProperty((NavigableEdge)navigableEdge);
            CompleteClass edgeTargetCompleteClass = this.completeModel.getCompleteClass(QVTrelationUtil.getType((TypedElement)property));
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)navigableEdge);
            Integer sourceCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(sourceNode);
            Integer targetCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(targetNode);
            assert (sourceCost != null && targetCost != null);
            if (sourceCost < targetCost && !edgeTargetCompleteClass.conformsTo(targetNodeCompleteClass = targetNode.getCompleteClass())) {
                ((Set)this.context).add(new CastEdgeCheckedCondition(navigableEdge));
            }
            return null;
        }

        public Object visitNavigationEdge(@NonNull NavigationEdge navigationEdge) {
            if (this.isCheckedNavigation(navigationEdge)) {
                ((Set)this.context).add(new PredicateNavigationEdgeCheckedCondition(navigationEdge));
                return null;
            }
            return super.visitNavigationEdge(navigationEdge);
        }

        public Object visitNode(@NonNull Node node) {
            Integer targetCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(node);
            assert (targetCost != null);
            Edge firstEdge = null;
            MultipleEdgeCheckedCondition checkedCondition = null;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                Role edgeRole = CheckedConditionAnalysis.this.partition.getRole(edge);
                if (edgeRole == null || !edgeRole.isOld() || edge.isExpression()) continue;
                Integer sourceCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(QVTscheduleUtil.getSourceNode((Edge)edge));
                assert (sourceCost != null);
                if (sourceCost > targetCost) continue;
                if (firstEdge == null) {
                    firstEdge = edge;
                    continue;
                }
                if (checkedCondition == null) {
                    checkedCondition = new MultipleEdgeCheckedCondition(node, firstEdge, edge);
                    ((Set)this.context).add(checkedCondition);
                    continue;
                }
                checkedCondition.addEdge(edge);
            }
            return null;
        }

        public Object visitOperationNode(@NonNull OperationNode operationNode) {
            Element originatingElement = operationNode.basicGetOriginatingElement();
            if (originatingElement instanceof TypedElement) {
                CompleteClass targetCompleteClass;
                Type initializerType;
                CompleteClass initializerCompleteClass;
                TypedElement typedElement = (TypedElement)originatingElement;
                if (operationNode.isRequired() && !typedElement.isIsRequired()) {
                    ((Set)this.context).add(new NonNullInitializerCheckedCondition(operationNode));
                }
                if (!(initializerCompleteClass = this.completeModel.getCompleteClass(initializerType = QVTbaseUtil.getType((TypedElement)typedElement))).conformsTo(targetCompleteClass = operationNode.getCompleteClass())) {
                    ((Set)this.context).add(new CastInitializerCheckedCondition(operationNode));
                }
            }
            return super.visitOperationNode(operationNode);
        }

        public Object visitPredicateEdge(@NonNull PredicateEdge predicateEdge) {
            ((Set)this.context).add(new PredicateEdgeCheckedCondition(predicateEdge));
            return null;
        }

        public Object visitRecursionEdge(@NonNull RecursionEdge object) {
            return this.visiting((Visitable)object);
        }

        public Object visitSuccessEdge(@NonNull SuccessEdge successEdge) {
            assert (this.isCheckedNavigation((NavigationEdge)successEdge));
            Property localSuccessProperty = CheckedConditionAnalysis.this.scheduleManager.basicGetLocalSuccessProperty(QVTscheduleUtil.getSourceNode((Edge)successEdge));
            boolean isLocalSuccess = successEdge.getReferredProperty() == localSuccessProperty;
            ((Set)this.context).add(new ConstantTargetCheckedCondition(successEdge, isLocalSuccess));
            return null;
        }

        public Object visitUnknownNode(@NonNull UnknownNode object) {
            return this.visiting((Visitable)object);
        }
    }
}

