/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParser;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFileUtil;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.WorkspaceMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.IImportResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.ParsedModuleCS;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilationResult;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerKernel;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.SyntaxUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.CSTFactory;
import org.eclipse.m2m.internal.qvt.oml.cst.ImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.LibraryImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtOpLexer;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtCompiler {
    public static final String PROBLEM_MARKER = "org.eclipse.m2m.qvt.oml.qvtProblem";
    private final Map<CFile, ParsedModuleCS> mySyntaxModules = new LinkedHashMap<CFile, ParsedModuleCS>();
    private final Map<ParsedModuleCS, QvtCompilationResult> myCompilationResults = new IdentityHashMap<ParsedModuleCS, QvtCompilationResult>();
    private ImportCompiler importCompiler;
    private final QvtCompilerKernel myKernel;
    private final ResourceSet resourceSet;

    public QvtCompiler(IImportResolver importResolver, IMetamodelRegistryProvider metamodelRegistryProvider) {
        this.myKernel = new QvtCompilerKernel(importResolver, metamodelRegistryProvider);
        this.resourceSet = metamodelRegistryProvider instanceof WorkspaceMetamodelRegistryProvider ? ((WorkspaceMetamodelRegistryProvider)metamodelRegistryProvider).getResolutionResourceSet() : new ResourceSetImpl();
    }

    public QvtCompiler(IImportResolver importResolver) {
        this(importResolver, (IMetamodelRegistryProvider)new WorkspaceMetamodelRegistryProvider());
    }

    public QvtCompilerKernel getKernel() {
        return this.myKernel;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void cleanup() {
        for (Resource res : this.getResourceSet().getResources()) {
            res.unload();
        }
    }

    public QvtCompilationResult compile(CFile source, QvtCompilerOptions options, IProgressMonitor monitor) throws MdaException {
        return this.compile(new CFile[]{source}, options, monitor)[0];
    }

    public QvtCompilationResult[] compile(CFile[] sources, QvtCompilerOptions options, IProgressMonitor monitor) throws MdaException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<ParsedModuleCS> mmaList = new ArrayList<ParsedModuleCS>(sources.length);
        CFile[] cFileArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            CFile source = cFileArray[n2];
            try {
                mmaList.add(this.parse(source));
            }
            catch (IOException e) {
                Throwable cause = e.getCause() != null ? e.getCause() : e;
                throw new MdaException(cause.getMessage(), cause);
            }
            ++n2;
        }
        IdentityHashMap<ParsedModuleCS, List<ParsedModuleCS>> removedImportCycles = new IdentityHashMap<ParsedModuleCS, List<ParsedModuleCS>>();
        for (ParsedModuleCS parsed : mmaList) {
            this.checkRemoveCycles(parsed, removedImportCycles);
        }
        this.importCompiler = new ImportCompiler(removedImportCycles, options);
        ArrayList<QvtCompilationResult> resultList = new ArrayList<QvtCompilationResult>();
        for (ParsedModuleCS parsed : mmaList) {
            QvtCompilationResult qvtCompilationResult = this.analyse(parsed, options);
            resultList.add(qvtCompilationResult);
        }
        this.afterCompileCleanup();
        return resultList.toArray(new QvtCompilationResult[resultList.size()]);
    }

    private void addSourceLineNumberInfo(ParsedModuleCS parsedModuleCS, Module moduleAST) {
        QvtOpLexer lexer = parsedModuleCS.getParser().getLexer();
        if (lexer != null) {
            String fileName = parsedModuleCS.getSource().getName();
            ASTBindingHelper.createModuleSourceBinding((EObject)moduleAST, fileName, new String(lexer.getInputChars()));
        }
    }

    private void checkRemoveCycles(ParsedModuleCS module, Map<ParsedModuleCS, List<ParsedModuleCS>> removedCycles) {
        Object[] cycle;
        while ((cycle = SyntaxUtil.findFirstImportCycle(module)) != null) {
            ParsedModuleCS from = (ParsedModuleCS)cycle[0];
            ParsedModuleCS to = (ParsedModuleCS)cycle[1];
            String fromIdentifier = from.getStringName();
            String toIdentifier = to.getStringName();
            from.getEnvironment().reportError(NLS.bind((String)CompilerMessages.cyclicImportError, (Object)toIdentifier, (Object)fromIdentifier), (CSTNode)from.getModuleCS().getHeaderCS().getPathNameCS());
            if (to != from) {
                to.getEnvironment().reportError(NLS.bind((String)CompilerMessages.cyclicImportError, (Object)fromIdentifier, (Object)toIdentifier), (CSTNode)to.getModuleCS().getHeaderCS().getPathNameCS());
            }
            boolean removed = false;
            Iterator<ParsedModuleCS> impIt = from.getParsedImports().iterator();
            while (impIt.hasNext()) {
                ParsedModuleCS imported = impIt.next();
                if (imported != to) continue;
                impIt.remove();
                removed = true;
                if (!removedCycles.containsKey(from)) {
                    removedCycles.put(from, new ArrayList(3));
                }
                removedCycles.get(from).add(imported);
            }
            assert (removed) : "False cycle: " + Arrays.asList(cycle);
        }
    }

    private ParsedModuleCS parse(CFile source) throws IOException {
        ParsedModuleCS result = this.mySyntaxModules.get(source);
        if (result != null) {
            return result;
        }
        result = this.parseInternal(source);
        assert (result != null);
        this.mySyntaxModules.put(source, result);
        this.parseImportedModules(result);
        return result;
    }

    protected ParsedModuleCS parseInternal(CFile source) throws IOException {
        Reader is = CFileUtil.getReader((CFile)source);
        try {
            QvtOperationalFileEnv env = new QvtOperationalEnvFactory().createEnvironment(null, source, this.myKernel);
            QvtOperationalParser qvtParser = new QvtOperationalParser();
            MappingModuleCS moduleCS = qvtParser.parse(is, source.getName(), env);
            if (moduleCS == null) {
                moduleCS = CSTFactory.eINSTANCE.createMappingModuleCS();
            }
            ParsedModuleCS parsedModuleCS = new ParsedModuleCS(moduleCS, source, qvtParser.getParser());
            return parsedModuleCS;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                Logger.getLogger().log(Logger.SEVERE, "Failed to close " + source, e);
            }
        }
    }

    private void parseImportedModules(ParsedModuleCS module) {
        HashSet<String> importedModules = new HashSet<String>();
        for (ImportCS importCS : module.getModuleCS().getImports()) {
            if (importCS instanceof LibraryImportCS) continue;
            PathNameCS importQName = importCS.getPathNameCS();
            if (importQName == null) {
                module.getEnvironment().reportError(CompilerMessages.emptyImport, 0, 0);
                continue;
            }
            String importString = QvtOperationalParserUtil.getStringRepresentation(importQName, ".");
            if (importedModules.contains(importString)) {
                module.getEnvironment().reportWarning(NLS.bind((String)CompilerMessages.moduleAlreadyImported, (Object)importString), (CSTNode)importQName);
                continue;
            }
            ParsedModuleCS impResult = this.getImportedModule(module.getSource(), importString);
            if (impResult == null) {
                module.getEnvironment().reportError(NLS.bind((String)CompilerMessages.importedModuleNotFound, (Object)importString), (CSTNode)importQName);
                continue;
            }
            module.addParsedImport(impResult, importQName);
            importedModules.add(importString);
        }
    }

    public QvtCompilationResult analyse(ParsedModuleCS mma, QvtCompilerOptions options) {
        QvtCompilationResult result = this.myCompilationResults.get(mma);
        if (result != null && result.getModule() != null) {
            return result;
        }
        List<CompiledModule> compiledImports = this.importCompiler.compileImports(mma);
        assert (mma.getEnvironment() instanceof QvtOperationalFileEnv);
        QvtOperationalFileEnv moduleEnv = (QvtOperationalFileEnv)mma.getEnvironment();
        for (ParsedModuleCS parsedImport : mma.getParsedImports()) {
            QvtOperationalEnv importEnv = parsedImport.getEnvironment();
            assert (importEnv != null);
            moduleEnv.addSibling(importEnv);
        }
        Module module = this.analyse(mma, options, moduleEnv);
        for (ImportCS importCS : mma.getModuleCS().getImports()) {
            ParsedModuleCS parsedImportCS = mma.getParsedImport(importCS.getPathNameCS());
            if (parsedImportCS == null || !parsedImportCS.getEnvironment().hasErrors()) continue;
            String errMessage = NLS.bind((String)CompilerMessages.importHasCompilationError, (Object)QvtOperationalParserUtil.getStringRepresentation((TypeCS)importCS.getPathNameCS()));
            moduleEnv.reportError(errMessage, importCS.getStartOffset(), importCS.getEndOffset());
        }
        CompiledModule compiledModule = new CompiledModule(module, mma, mma.getSource(), moduleEnv.getAllProblemMessages());
        compiledModule.getCompiledImports().addAll(compiledImports);
        result = new QvtCompilationResult(compiledModule);
        this.myCompilationResults.put(mma, result);
        return result;
    }

    private Module analyse(ParsedModuleCS mma, QvtCompilerOptions options, QvtOperationalFileEnv env) {
        Module module = null;
        if (mma.getStringName() != null) {
            PrintStream out = System.out;
            System.setOut(new PrintStream(new OutputStream(){

                public void write(int b) {
                }
            }));
            try {
                QvtOperationalParser parser = new QvtOperationalParser();
                module = parser.analyze(mma, this, env, options);
            }
            finally {
                System.setOut(out);
            }
        }
        if (module == null) {
            module = this.myKernel.createModule(mma.getModuleCS(), options, env, mma.getSource());
            module.setName("");
        }
        if (options.isSourceLineNumbersEnabled()) {
            this.addSourceLineNumberInfo(mma, module);
        }
        return module;
    }

    private ParsedModuleCS getImportedModule(CFile source, String qualifiedName) {
        CFile importSource = this.myKernel.getImportResolver().resolveImport(qualifiedName);
        if (importSource == null) {
            importSource = this.myKernel.getImportResolver().resolveImport(source, qualifiedName);
        }
        if (importSource == null) {
            return null;
        }
        try {
            ParsedModuleCS parsed = this.parse(importSource);
            return parsed;
        }
        catch (IOException e) {
            Logger.getLogger().log(Logger.SEVERE, "Failed to get module for " + source, e);
            return null;
        }
    }

    public boolean isClass(EClassifier oclType) {
        return oclType instanceof EClass;
    }

    private void afterCompileCleanup() {
        this.importCompiler = null;
        this.myCompilationResults.clear();
        this.mySyntaxModules.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImportCompiler {
        private final Map<ParsedModuleCS, List<ParsedModuleCS>> myRemovedCycles;
        private final QvtCompilerOptions myCompilerOptions;

        ImportCompiler(Map<ParsedModuleCS, List<ParsedModuleCS>> removedCycles, QvtCompilerOptions options) {
            this.myRemovedCycles = removedCycles;
            this.myCompilerOptions = options;
        }

        List<CompiledModule> compileImports(ParsedModuleCS importingModule) {
            List removedImports;
            if (QvtCompiler.this.myCompilationResults.containsKey(importingModule)) {
                return ((QvtCompilationResult)QvtCompiler.this.myCompilationResults.get(importingModule)).getModule().getCompiledImports();
            }
            Collection<ParsedModuleCS> importedModules = importingModule.getParsedImports();
            List<Object> list = removedImports = this.myRemovedCycles.containsKey(importingModule) ? this.myRemovedCycles.get(importingModule) : Collections.emptyList();
            if (this.myRemovedCycles.containsKey(importingModule)) {
                importedModules = new ArrayList<ParsedModuleCS>(importedModules.size() + removedImports.size());
                importedModules.addAll(importingModule.getParsedImports());
                importedModules.addAll(removedImports);
            }
            LinkedList<CompiledModule> directImportsCompiled = new LinkedList<CompiledModule>();
            for (ParsedModuleCS importedModule : importedModules) {
                String importedModuleId = importedModule.getStringName();
                if (importedModuleId == null) continue;
                CompiledModule analyzedModule = null;
                if (importingModule.getStringName().equals(importedModuleId) || removedImports.contains(importedModule)) continue;
                List<CompiledModule> nextCompiledImports = this.compileImports(importedModule);
                analyzedModule = QvtCompiler.this.analyse(importedModule, this.myCompilerOptions).getModule();
                analyzedModule.getCompiledImports().addAll(nextCompiledImports);
                directImportsCompiled.add(analyzedModule);
            }
            return directImportsCompiled;
        }
    }
}

