/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtCompilerFacade;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;

public class WorkspaceQvtModule
extends QvtModule {
    private final IFile myTransformationFile;
    private Module myModule;
    private CompiledUnit myUnit;
    private ResourceSet myResourceSet;

    public WorkspaceQvtModule(IFile transformationFile) {
        this.myTransformationFile = transformationFile;
    }

    protected CompiledUnit loadModule() throws MdaException {
        QvtCompilerOptions options = this.getQvtCompilerOptions();
        if (options == null) {
            options = new QvtCompilerOptions();
        }
        QvtCompilerFacade.CompilationResult result = QvtCompilerFacade.getCompiledModule(this.myTransformationFile, options, null);
        this.myResourceSet = result.getCompiler().getResourceSet();
        return result.getCompiledModule();
    }

    protected ResourceSet getResourceSetImpl() {
        return this.myResourceSet;
    }

    public final Module getModule() throws MdaException {
        if (this.myModule == null) {
            this.myUnit = this.loadModule();
            this.myModule = this.myUnit.getModules().isEmpty() ? null : (Module)this.myUnit.getModules().get(0);
            QvtCompilerOptions options = this.getQvtCompilerOptions();
            if (options == null) {
                options = new QvtCompilerOptions();
            }
            if (!options.isModuleWithErrorAllowed()) {
                this.checkModuleErrors(this.myUnit);
            }
        }
        return this.myModule;
    }

    public CompiledUnit getUnit() throws MdaException {
        this.getModule();
        return this.myUnit;
    }

    public ResourceSet getResourceSet() throws MdaException {
        this.getModule();
        return this.getResourceSetImpl();
    }

    public void cleanup() {
        if (this.getResourceSetImpl() != null) {
            EmfUtil.cleanupResourceSet((ResourceSet)this.getResourceSetImpl());
        }
    }

    public IFile getTransformationFile() {
        return this.myTransformationFile;
    }

    public String toString() {
        return this.myTransformationFile.getFullPath().toString();
    }
}

