/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectHistory;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitHistoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOObjectHistoryImpl
extends CDOCommitHistoryImpl
implements CDOObjectHistory {
    private final CDORevisionManager revisionManager;
    private final CDOObject object;
    private CDORevision loadedRevision;

    public CDOObjectHistoryImpl(CDOObject object) {
        super(object.cdoView().getSession().getCommitInfoManager(), object.cdoRevision().getBranch());
        this.revisionManager = object.cdoView().getSession().getRevisionManager();
        this.object = object;
    }

    @Override
    public CDOObject getCDOObject() {
        return this.object;
    }

    protected boolean filterCommitInfo(CDOCommitInfo commitInfo) {
        if (commitInfo.isCommitDataLoaded()) {
            CDOID id = this.object.cdoID();
            for (CDORevisionKey key : commitInfo.getChangedObjects()) {
                if (!key.getID().equals(id)) continue;
                return false;
            }
            for (CDORevisionKey key : commitInfo.getNewObjects()) {
                if (!key.getID().equals(id)) continue;
                return false;
            }
            for (CDORevisionKey key : commitInfo.getDetachedObjects()) {
                if (!key.getID().equals(id)) continue;
                return false;
            }
            return true;
        }
        return super.filterCommitInfo(commitInfo);
    }

    protected void loadCommitInfos(int loadCount, List<CDOCommitInfo> addedCommitInfos) {
        int i = 0;
        while (i < loadCount) {
            if (this.loadedRevision == null) {
                this.loadedRevision = this.object.cdoRevision();
            } else {
                int version = this.loadedRevision.getVersion();
                if (version > 1) {
                    CDOBranchVersion previous = this.loadedRevision.getBranch().getVersion(version - 1);
                    this.loadedRevision = this.revisionManager.getRevisionByVersion(this.object.cdoID(), previous, -1, true);
                } else {
                    CDOBranchPoint base = this.loadedRevision.getBranch().getBase();
                    if (base.getBranch() == null) {
                        this.setFull();
                        break;
                    }
                    CDORevision revision = this.revisionManager.getRevision(this.object.cdoID(), base, -1, 0, true);
                    if (revision == null) {
                        this.setFull();
                        break;
                    }
                    this.loadedRevision = revision;
                }
            }
            CDOCommitInfoManager manager = this.getManager();
            CDOCommitInfo commitInfo = manager.getCommitInfo(this.loadedRevision.getTimeStamp());
            if (this.addCommitInfo(commitInfo)) {
                addedCommitInfos.add(commitInfo);
            }
            ++i;
        }
    }
}

