/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db.revisioncache;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.common.db.CDOCommonDBUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.tests.revisioncache.AbstractRevisionCacheTest;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public abstract class AbstractDBRevisionCacheTest
extends AbstractRevisionCacheTest {
    private DataSource dataSource;

    protected InternalCDORevisionCache createRevisionCache(CDOSession session) throws Exception {
        DataSource dataSource = this.getDataSource();
        this.clearDb(dataSource);
        IDBAdapter dbAdapter = this.getAdapter();
        CDORevisionCache revisionCache = CDOCommonDBUtil.createDBCache((IDBAdapter)dbAdapter, (IDBConnectionProvider)dbAdapter.createConnectionProvider(dataSource), (CDOListFactory)CDOListFactory.DEFAULT, (CDOPackageRegistry)session.getPackageRegistry(), (CDORevisionFactory)((InternalCDOSession)session).getRevisionManager().getFactory());
        LifecycleUtil.activate((Object)revisionCache);
        return (InternalCDORevisionCache)revisionCache;
    }

    private DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = this.createDataSource();
        }
        return this.dataSource;
    }

    private void clearDb(DataSource dataSource) throws SQLException {
        Connection connection = dataSource.getConnection();
        try {
            this.dropAllTables(connection);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    protected abstract DataSource createDataSource();

    protected abstract void dropAllTables(Connection var1);

    protected abstract IDBAdapter getAdapter();
}

