/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourceFactory;
import org.eclipse.emf.cdo.internal.ui.actions.AbstractViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.ResourceNodeNameInputValidator;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class NewTopLevelResourceNodeAction
extends AbstractViewAction {
    private CDOItemProvider itemProvider;
    private CDOResourceNode selectedNode;
    private Type type;
    private String resourceNodeName;

    public NewTopLevelResourceNodeAction(CDOItemProvider itemProvider, IWorkbenchPage page, CDOView view, CDOResourceNode node, Type type) {
        super(page, String.valueOf(type.getTitle()) + INTERACTIVE, type.getTooltip(), type.getImageDescriptor(), view);
        this.selectedNode = node;
        this.itemProvider = itemProvider;
        this.type = type;
    }

    protected void preRun() throws Exception {
        String initialValue = String.valueOf(this.type == Type.FOLDER ? "folder" : "resource") + (AbstractViewAction.lastResourceNumber + 1);
        InputDialog dialog = new InputDialog(this.getShell(), this.getText(), Messages.getString("NewResourceNodeAction.8"), initialValue, (IInputValidator)new ResourceNodeNameInputValidator(this.selectedNode));
        if (dialog.open() == 0) {
            ++AbstractViewAction.lastResourceNumber;
            this.resourceNodeName = dialog.getValue();
        } else {
            this.cancel();
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        CDOTransaction transaction = this.getTransaction();
        CDOResourceFolder node = null;
        switch (this.type) {
            case FOLDER: {
                node = EresourceFactory.eINSTANCE.createCDOResourceFolder();
                node.setName(this.resourceNodeName);
                if (this.selectedNode instanceof CDOResourceFolder) {
                    ((CDOResourceFolder)this.selectedNode).getNodes().add((Object)node);
                    break;
                }
                ((CDOResource)this.selectedNode).getContents().add((Object)node);
                break;
            }
            case MODEL: {
                if (this.selectedNode instanceof CDOResourceFolder) {
                    node = transaction.createResource(String.valueOf(this.selectedNode.getPath()) + "/" + this.resourceNodeName);
                    break;
                }
                node = transaction.createResource(this.resourceNodeName);
                break;
            }
            case TEXT: {
                if (this.selectedNode instanceof CDOResourceFolder) {
                    node = transaction.createTextResource(String.valueOf(this.selectedNode.getPath()) + "/" + this.resourceNodeName);
                    break;
                }
                node = transaction.createTextResource(this.resourceNodeName);
                break;
            }
            case BINARY: {
                node = this.selectedNode instanceof CDOResourceFolder ? transaction.createBinaryResource(String.valueOf(this.selectedNode.getPath()) + "/" + this.resourceNodeName) : transaction.createBinaryResource(this.resourceNodeName);
            }
        }
        transaction.commit();
        this.itemProvider.refreshViewer(true);
        this.itemProvider.selectElement(node, true);
        if (this.type == Type.MODEL) {
            String resourcePath = node.getPath();
            CDOEditorUtil.openEditor(this.getPage(), (CDOView)transaction, resourcePath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FOLDER(Messages.getString("Title.Folder"), Messages.getString("Tooltip.Folder"), SharedIcons.getDescriptor((String)"etool16/NewCDOResourceFolder.gif")),
        MODEL(Messages.getString("Title.Model"), Messages.getString("Tooltip.Model"), SharedIcons.getDescriptor((String)"etool16/NewCDOResource.gif")),
        TEXT(Messages.getString("Title.Text"), Messages.getString("Tooltip.Text"), SharedIcons.getDescriptor((String)"etool16/NewCDOTextResource.gif")),
        BINARY(Messages.getString("Title.Binary"), Messages.getString("Tooltip.Binary"), SharedIcons.getDescriptor((String)"etool16/NewCDOBinaryResource.gif"));

        private String title;
        private String tooltip;
        private ImageDescriptor imageDescriptor;

        private Type(String title, String tooltip, ImageDescriptor imageDescriptor) {
            this.title = title;
            this.tooltip = tooltip;
            this.imageDescriptor = imageDescriptor;
        }

        public String getTitle() {
            return this.title;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public ImageDescriptor getImageDescriptor() {
            return this.imageDescriptor;
        }
    }
}

