/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.server;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.UserManager;
import org.h2.jdbcx.JdbcDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoConfiguration
extends Lifecycle {
    public static final int NAME_LENGTH = 10;
    private static final String NAME_ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    private Mode mode = Mode.NORMAL;
    private String[] userIDs;
    private transient String name;
    private transient InternalRepository repository;
    private DemoUserManager userManager;
    private transient long lastAccess = System.currentTimeMillis();

    DemoConfiguration(Mode mode, String[] userIDs) {
        this.mode = mode;
        if (userIDs != null && userIDs.length != 0 && StringUtil.isEmpty((String)userIDs[0])) {
            userIDs = null;
        }
        this.userIDs = userIDs;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String[] getUserIDs() {
        return this.userIDs;
    }

    public String getName() {
        return this.name;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public Map<String, char[]> getUsers() {
        if (this.userManager == null) {
            return Collections.emptyMap();
        }
        return this.userManager.getUsers();
    }

    public synchronized long getTimeoutMillis() {
        long idleTime = System.currentTimeMillis() - this.lastAccess;
        long time = 900000L - idleTime;
        if (time < 0L) {
            time = 0L;
        }
        return time;
    }

    public String formatTimeoutMinutes() {
        return MessageFormat.format("{0,time,mm:ss}", this.getTimeoutMillis());
    }

    protected void doActivate() throws Exception {
        this.name = this.createRandomName();
        IDBStore store = this.createStore();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "");
        props.put("supportingAudits", this.mode == Mode.NORMAL ? "false" : "true");
        props.put("supportingBranches", this.mode == Mode.BRANCHING ? "true" : "false");
        this.repository = (InternalRepository)CDOServerUtil.createRepository((String)this.name, (IStore)store, props);
        InternalSessionManager sessionManager = this.createSessionManager();
        if (this.userIDs != null) {
            IAuthenticator authenticator = this.createAuthenticator();
            sessionManager.setAuthenticator(authenticator);
        }
        CDOServerUtil.addRepository((IManagedContainer)IPluginContainer.INSTANCE, (IRepository)this.repository);
    }

    protected void doDeactivate() throws Exception {
        if (this.repository != null) {
            File folder = new File(new File("databases"), this.repository.getName());
            LifecycleUtil.deactivate((Object)this.repository);
            this.repository = null;
            IOUtil.delete((File)folder);
        }
    }

    protected String createRandomName() {
        return DemoConfiguration.createRandomString(10, NAME_ALPHABET);
    }

    protected IDBStore createStore() {
        IMappingStrategy mappingStrategy = this.createMappingStrategy();
        IDBAdapter dbAdapter = DBUtil.getDBAdapter((String)"h2");
        IDBConnectionProvider dbConnectionProvider = dbAdapter.createConnectionProvider(this.createDataSource());
        IDBStore store = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
        return store;
    }

    protected IMappingStrategy createMappingStrategy() {
        switch (this.mode) {
            case NORMAL: {
                return CDODBUtil.createHorizontalMappingStrategy((boolean)false, (boolean)false);
            }
            case AUDITING: {
                return CDODBUtil.createHorizontalMappingStrategy((boolean)true, (boolean)false);
            }
            case BRANCHING: {
                return CDODBUtil.createHorizontalMappingStrategy((boolean)true, (boolean)true);
            }
        }
        throw new IllegalStateException("Invalid mode: " + (Object)((Object)this.mode));
    }

    protected DataSource createDataSource() {
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:databases/" + this.name + "/h2test");
        return dataSource;
    }

    protected InternalSessionManager createSessionManager() {
        InternalSessionManager sessionManager = (InternalSessionManager)CDOServerUtil.createSessionManager();
        this.repository.setSessionManager(sessionManager);
        sessionManager.addListener((IListener)new ContainerEventAdapter<ISession>(){

            protected void onAdded(IContainer<ISession> container, ISession session) {
                ISignalProtocol protocol = (ISignalProtocol)session.getProtocol();
                if (protocol != null) {
                    protocol.addListener(new IListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void notifyEvent(IEvent event) {
                            DemoConfiguration demoConfiguration = DemoConfiguration.this;
                            synchronized (demoConfiguration) {
                                DemoConfiguration.this.lastAccess = System.currentTimeMillis();
                            }
                        }
                    });
                }
            }
        });
        return sessionManager;
    }

    protected IAuthenticator createAuthenticator() {
        this.userManager = new DemoUserManager();
        int i = 0;
        while (i < this.userIDs.length) {
            String userID = this.userIDs[i];
            this.userManager.addUser(userID, ("pw" + (i + 1)).toCharArray());
            ++i;
        }
        this.userManager.activate();
        return this.userManager;
    }

    public static String createRandomString(int length, String alphabet) {
        Random random = new Random(System.currentTimeMillis());
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            int pos = random.nextInt(alphabet.length());
            builder.append(alphabet.charAt(pos));
            ++i;
        }
        return builder.toString();
    }

    public static String createRandomString(int length) {
        return DemoConfiguration.createRandomString(length, NAME_ALPHABET);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DemoUserManager
    extends UserManager {
        public Map<String, char[]> getUsers() {
            return this.users;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        NORMAL,
        AUDITING,
        BRANCHING;

    }
}

