/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db.tests;

import java.io.File;
import javax.sql.DataSource;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.db.tests.AbstractDBTest;
import org.eclipse.net4j.util.io.IOUtil;
import org.h2.jdbcx.JdbcDataSource;

public class H2Test
extends AbstractDBTest {
    private File dbFolder;

    protected IDBAdapter createAdapter() {
        return new H2Adapter();
    }

    protected DataSource createDataSource() {
        this.dbFolder = this.createTempFolder("h2_");
        this.deleteDBFolder();
        H2Test.msg((Object)("Using DB folder: " + this.dbFolder.getAbsolutePath()));
        String url = "jdbc:h2:" + this.dbFolder.getAbsolutePath() + "/h2test";
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL(url);
        H2Adapter.createSchema((DataSource)dataSource, (String)"TEST", (boolean)true);
        dataSource = new JdbcDataSource();
        dataSource.setURL(String.valueOf(url) + ";SCHEMA=" + "TEST");
        return dataSource;
    }

    protected void doTearDown() throws Exception {
        this.deleteDBFolder();
        super.doTearDown();
    }

    private void deleteDBFolder() {
        IOUtil.delete((File)this.dbFolder);
    }
}

