/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.common;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.IBuddyStateEvent;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.common.IMembership;
import org.eclipse.net4j.buddies.common.ISession;
import org.eclipse.net4j.buddies.internal.common.Collaboration;
import org.eclipse.net4j.buddies.internal.common.MembershipContainer;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Buddy
extends MembershipContainer
implements IBuddy {
    private ISession session;
    private IBuddy.State state = IBuddy.State.AVAILABLE;
    private Set<String> facilityTypes;

    public Buddy(ISession session, Set<String> facilityTypes) {
        this.session = session;
        this.facilityTypes = facilityTypes == null ? null : Collections.unmodifiableSet(facilityTypes);
    }

    @Override
    public ISession getSession() {
        return this.session;
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    @Override
    public IBuddy.State getState() {
        return this.state;
    }

    public void setState(IBuddy.State state) {
        if (this.state != state) {
            BuddyStateEvent event = new BuddyStateEvent(this.state, state);
            this.state = state;
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent(event, listeners);
            }
        }
    }

    @Override
    public Set<String> getFacilityTypes() {
        if (this.facilityTypes == null) {
            this.facilityTypes = Collections.unmodifiableSet(this.loadFacilityTypes());
        }
        return this.facilityTypes;
    }

    public IMembership getMembership(Collaboration collaboration) {
        return this.getMembership(this, collaboration);
    }

    public IMembership removeMembership(Collaboration collaboration) {
        return this.removeMembership(this, collaboration);
    }

    @Override
    public ICollaboration getCollaboration(long collaborationID) {
        IMembership[] iMembershipArray = this.getMemberships();
        int n = iMembershipArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMembership membership = iMembershipArray[n2];
            ICollaboration collaboration = membership.getCollaboration();
            if (collaboration.getID() == collaborationID) {
                return collaboration;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ICollaboration[] getCollaborations() {
        ArrayList<ICollaboration> collaborations = new ArrayList<ICollaboration>();
        IMembership[] iMembershipArray = this.getMemberships();
        int n = iMembershipArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMembership membership = iMembershipArray[n2];
            ICollaboration collaboration = membership.getCollaboration();
            collaborations.add(collaboration);
            ++n2;
        }
        return collaborations.toArray(new ICollaboration[collaborations.size()]);
    }

    @Override
    public IMembership initiate() {
        return this.initiate((IBuddy)null);
    }

    @Override
    public IMembership initiate(IBuddy buddy) {
        IMembership[] memberships;
        HashSet<IBuddy> buddies = new HashSet<IBuddy>();
        if (buddy != null) {
            buddies.add(buddy);
        }
        return (memberships = this.initiate(buddies)).length == 0 ? null : memberships[0];
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IBuddy) {
            IBuddy buddy = (IBuddy)obj;
            return ObjectUtil.equals((Object)this.getUserID(), (Object)buddy.getUserID());
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtil.hashCode((Object)this.getUserID());
    }

    public String toString() {
        return MessageFormat.format("{0}[{1}]", this.getClass().getSimpleName(), this.getUserID());
    }

    protected Set<String> loadFacilityTypes() {
        throw new UnsupportedOperationException();
    }

    private final class BuddyStateEvent
    extends Event
    implements IBuddyStateEvent {
        private static final long serialVersionUID = 1L;
        private IBuddy.State oldState;
        private IBuddy.State newState;

        public BuddyStateEvent(IBuddy.State oldState, IBuddy.State newState) {
            super((INotifier)Buddy.this);
            this.oldState = oldState;
            this.newState = newState;
        }

        public IBuddy getSource() {
            return (IBuddy)super.getSource();
        }

        public IBuddy.State getOldState() {
            return this.oldState;
        }

        public IBuddy.State getNewState() {
            return this.newState;
        }

        public String toString() {
            return MessageFormat.format("BuddyStateEvent[source={0}, oldState={1}, newState={2}]", new Object[]{this.getSource(), this.getOldState(), this.getNewState()});
        }
    }
}

