/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.IBuddyContainer;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyContainer
extends Lifecycle
implements IBuddyContainer,
IListener {
    private Map<String, IBuddy> buddies = new HashMap<String, IBuddy>();

    public BuddyContainer(Collection<IBuddy> buddies) {
        if (buddies != null) {
            for (IBuddy buddy : buddies) {
                this.buddies.put(buddy.getUserID(), buddy);
                buddy.addListener(this);
            }
        }
    }

    public BuddyContainer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBuddy(IBuddy buddy) {
        String userID = buddy.getUserID();
        Map<String, IBuddy> map = this.buddies;
        synchronized (map) {
            block5: {
                if (this.buddies.containsKey(userID)) break block5;
                this.buddies.put(userID, buddy);
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new SingleDeltaContainerEvent((IContainer)this, (Object)buddy, IContainerDelta.Kind.ADDED), listeners);
                }
                buddy.addListener(this);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBuddy removeBuddy(String userID) {
        IBuddy buddy;
        Map<String, IBuddy> map = this.buddies;
        synchronized (map) {
            buddy = this.buddies.remove(userID);
        }
        if (buddy != null) {
            buddy.removeListener(this);
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent((IEvent)new SingleDeltaContainerEvent((IContainer)this, (Object)buddy, IContainerDelta.Kind.REMOVED), listeners);
            }
        }
        return buddy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBuddy[] getBuddies() {
        Map<String, IBuddy> map = this.buddies;
        synchronized (map) {
            return this.buddies.values().toArray(new IBuddy[this.buddies.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBuddy getBuddy(String userID) {
        Map<String, IBuddy> map = this.buddies;
        synchronized (map) {
            return this.buddies.get(userID);
        }
    }

    public IBuddy[] getElements() {
        return this.getBuddies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<String, IBuddy> map = this.buddies;
        synchronized (map) {
            return this.buddies.isEmpty();
        }
    }

    public void notifyEvent(IEvent event) {
        if (event.getSource() instanceof IBuddy) {
            LifecycleEvent e;
            this.notifyBuddyEvent(event);
            if (event instanceof LifecycleEvent && (e = (LifecycleEvent)event).getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                this.removeBuddy(((IBuddy)e.getSource()).getUserID());
            }
        }
    }

    protected void notifyBuddyEvent(IEvent event) {
    }

    protected void doDeactivate() throws Exception {
        IBuddy[] iBuddyArray = this.getBuddies();
        int n = iBuddyArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuddy buddy = iBuddyArray[n2];
            buddy.removeListener(this);
            ++n2;
        }
        super.doDeactivate();
    }
}

