/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.mongodb;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.mongodb.CDOMongoDBUtil;
import org.eclipse.emf.cdo.tests.config.impl.RepositoryConfig;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

public class MongoDBConfig
extends RepositoryConfig {
    public static final String STORE_NAME = "MongoDB";
    private static final long serialVersionUID = 1L;

    public MongoDBConfig() {
        super(STORE_NAME);
    }

    protected String getStoreName() {
        return STORE_NAME;
    }

    public void setUp() throws Exception {
        CDOMongoDBUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        super.setUp();
    }

    public IStore createStore(String repoName) {
        MongoURI mongoURI = new MongoURI("mongodb://localhost");
        if (!this.isRestarting()) {
            this.dropDatabase(mongoURI, repoName);
        }
        return CDOMongoDBUtil.createStore((String)mongoURI.toString(), (String)repoName);
    }

    protected void dropDatabase(MongoURI mongoURI, String repoName) {
        Mongo mongo = null;
        try {
            try {
                mongo = new Mongo(mongoURI);
                DB db = mongo.getDB(repoName);
                if (!db.getCollectionNames().isEmpty()) {
                    db.dropDatabase();
                }
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            if (mongo != null) {
                mongo.close();
            }
        }
    }

    public boolean supportingExtRefs() {
        return false;
    }
}

