/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.transfer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.examples.transfer.UploadProtocol;
import org.eclipse.net4j.internal.examples.bundle.OM;
import org.eclipse.net4j.signal.IndicationWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.tcp.ssl.SSLUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.PrintTraceHandler;
import org.eclipse.spi.net4j.ServerProtocolFactory;

public class UploadSSLServer
implements UploadProtocol {
    public static final String FOLDER_NAME = "/temp";

    public static void main(String[] args) throws Exception {
        OMPlatform.INSTANCE.setDebugging(true);
        OMPlatform.INSTANCE.addTraceHandler((OMTraceHandler)PrintTraceHandler.CONSOLE);
        OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        SSLUtil.prepareContainer((IManagedContainer)container);
        container.registerFactory((IFactory)new ProtocolFactory());
        container.activate();
        try {
            IAcceptor acceptor = (IAcceptor)container.getElement("org.eclipse.net4j.acceptors", "ssl", "0.0.0.0:2036");
            OM.LOG.info("Accepting connections: " + acceptor);
            new File(FOLDER_NAME).mkdirs();
            OM.LOG.info("Upload folder: /temp");
            System.out.println("Press any key to shutdown");
            while (System.in.read() == -1) {
                Thread.sleep(200L);
            }
        }
        finally {
            LifecycleUtil.deactivate((Object)container);
        }
    }

    public static final class ProtocolFactory
    extends ServerProtocolFactory {
        public ProtocolFactory() {
            super("upload");
        }

        public Object create(String description) throws ProductCreationException {
            return new SignalProtocol<Object>("upload"){

                protected SignalReactor createSignalReactor(short signalID) {
                    switch (signalID) {
                        case 1: {
                            return new UploadIndication(this);
                        }
                    }
                    return super.createSignalReactor(signalID);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UploadIndication
    extends IndicationWithMonitoring {
        private boolean replaced;

        public UploadIndication(SignalProtocol<Object> protocol) {
            super(protocol, (short)1);
        }

        protected void indicating(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
            long size = in.readLong();
            String fileName = in.readString();
            File file = new File(UploadSSLServer.FOLDER_NAME, fileName);
            this.replaced = file.exists();
            System.out.println(String.valueOf(this.replaced ? "Replacing " : "Storing ") + file.getAbsolutePath());
            monitor.begin((double)((int)size));
            BufferedOutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(file));
                while (size != 0L) {
                    int chunk = 8192;
                    if (size < 8192L) {
                        chunk = (int)size;
                    }
                    byte[] buffer = in.readByteArray();
                    out.write(buffer);
                    monitor.worked((double)chunk);
                    size -= (long)chunk;
                }
            }
            finally {
                monitor.done();
                if (out != null) {
                    out.close();
                }
            }
        }

        protected void responding(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
            out.writeBoolean(this.replaced);
        }
    }
}

