/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.syncing;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.internal.common.revision.NOOPRevisionCache;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.session.CDOSessionLocksChangedEvent;
import org.eclipse.emf.cdo.spi.common.CDORawReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchAdjustable;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.server.InternalRepositorySynchronizer;
import org.eclipse.emf.cdo.spi.server.InternalSynchronizableRepository;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.PriorityQueueRunnable;
import org.eclipse.net4j.util.concurrent.PriorityQueueRunner;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.om.monitor.NotifyingMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class RepositorySynchronizer
extends PriorityQueueRunner
implements InternalRepositorySynchronizer {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REPOSITORY, RepositorySynchronizer.class);
    private static final Integer CONNECT_PRIORITY = 0;
    private static final Integer REPLICATE_PRIORITY = 1;
    private static final Integer BRANCH_PRIORITY = 2;
    private static final Integer COMMIT_PRIORITY;
    private static final Integer LOCKS_PRIORITY;
    private int retryInterval = 3;
    private Object connectLock = new Object();
    private InternalSynchronizableRepository localRepository;
    private InternalCDOSession remoteSession;
    private RemoteSessionListener remoteSessionListener = new RemoteSessionListener();
    private CDOSessionConfigurationFactory remoteSessionConfigurationFactory;
    private boolean rawReplication = true;
    private int maxRecommits = 10;
    private int recommitInterval = 1;
    private Timer recommitTimer;

    static {
        LOCKS_PRIORITY = COMMIT_PRIORITY = Integer.valueOf(3);
    }

    public RepositorySynchronizer() {
        this.setDaemon(true);
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public InternalSynchronizableRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(InternalSynchronizableRepository localRepository) {
        this.checkInactive();
        this.localRepository = localRepository;
    }

    public CDOSessionConfigurationFactory getRemoteSessionConfigurationFactory() {
        return this.remoteSessionConfigurationFactory;
    }

    public void setRemoteSessionConfigurationFactory(CDOSessionConfigurationFactory masterSessionConfigurationFactory) {
        this.checkArg(masterSessionConfigurationFactory, "remoteSessionConfigurationFactory");
        this.remoteSessionConfigurationFactory = masterSessionConfigurationFactory;
    }

    public InternalCDOSession getRemoteSession() {
        return this.remoteSession;
    }

    public boolean isRawReplication() {
        return this.rawReplication;
    }

    public void setRawReplication(boolean rawReplication) {
        this.checkInactive();
        this.rawReplication = rawReplication;
    }

    public int getMaxRecommits() {
        return this.maxRecommits;
    }

    public void setMaxRecommits(int maxRecommits) {
        this.maxRecommits = maxRecommits;
    }

    public int getRecommitInterval() {
        return this.recommitInterval;
    }

    public void setRecommitInterval(int recommitInterval) {
        this.recommitInterval = recommitInterval;
    }

    public boolean isEmpty() {
        return this.remoteSession == null;
    }

    public CDOSession[] getElements() {
        if (this.remoteSession == null) {
            return new CDOSession[0];
        }
        return new CDOSession[]{this.remoteSession};
    }

    protected String getThreadName() {
        return "CDORepositorySynchronizer";
    }

    protected void noWork(Worker.WorkContext context) {
        if (!this.localRepository.isActive()) {
            context.terminate();
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.remoteSessionConfigurationFactory, "remoteSessionConfigurationFactory");
        this.checkState(this.localRepository, "localRepository");
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        this.scheduleConnect();
    }

    protected void doDeactivate() throws Exception {
        if (this.recommitTimer != null) {
            this.recommitTimer.cancel();
            this.recommitTimer = null;
        }
        if (this.remoteSession != null) {
            this.closeRemoteSession();
        }
        super.doDeactivate();
    }

    protected void handleConnect() {
        this.scheduleReplicate();
        this.remoteSession.addListener((IListener)this.remoteSessionListener);
        this.remoteSession.getBranchManager().addListener((IListener)this.remoteSessionListener);
        this.fireEvent((IEvent)new SingleDeltaContainerEvent((IContainer)this, (Object)this.remoteSession, IContainerDelta.Kind.ADDED));
    }

    protected void handleDisconnect() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Disconnected from master.");
        }
        if (this.localRepository.hasBeenReplicated()) {
            this.localRepository.setState(CDOCommonRepository.State.OFFLINE);
        } else {
            this.localRepository.setState(CDOCommonRepository.State.INITIAL);
        }
        if (this.remoteSession != null) {
            InternalCDOSession element = this.remoteSession;
            this.closeRemoteSession();
            this.fireEvent((IEvent)new SingleDeltaContainerEvent((IContainer)this, (Object)element, IContainerDelta.Kind.REMOVED));
        }
        this.reconnect();
    }

    private void closeRemoteSession() {
        this.remoteSession.removeListener((IListener)this.remoteSessionListener);
        this.remoteSession.getBranchManager().removeListener((IListener)this.remoteSessionListener);
        this.remoteSession.close();
        this.remoteSession = null;
    }

    private void reconnect() {
        this.clearQueue();
        if (this.isActive()) {
            this.scheduleConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleConnect() {
        Object object = this.connectLock;
        synchronized (object) {
            CDOCommonRepository.State state = this.localRepository.getState();
            if (state.isConnected()) {
                return;
            }
            if (this.isActive()) {
                this.addWork((Object)new ConnectRunnable());
            }
        }
    }

    private void scheduleReplicate() {
        if (this.isActive()) {
            this.addWork((Object)new ReplicateRunnable());
        }
    }

    private void sleepRetryInterval() {
        long now;
        long end = System.currentTimeMillis() + 1000L * (long)this.retryInterval;
        while ((now = System.currentTimeMillis()) < end && this.isActive()) {
            ConcurrencyUtil.sleep((long)Math.min(100L, end - now));
        }
    }

    private final class BranchRunnable
    extends PriorityQueueRunnable {
        private CDOBranch branch;

        public BranchRunnable(CDOBranch branch) {
            this.branch = branch;
        }

        public void run() {
            try {
                RepositorySynchronizer.this.localRepository.handleBranch(this.branch);
            }
            catch (Exception ex) {
                RepositorySynchronizer.this.fireThrowable(ex);
            }
        }

        public int compareTo(PriorityQueueRunnable o) {
            int result = super.compareTo(o);
            if (result == 0) {
                result = this.branch.compareTo((Object)((BranchRunnable)o).branch);
            }
            return result;
        }

        protected Integer getPriority() {
            return BRANCH_PRIORITY;
        }
    }

    private final class CommitRunnable
    extends RetryingRunnable {
        private CDOCommitInfo commitInfo;

        public CommitRunnable(CDOCommitInfo commitInfo) {
            this.commitInfo = commitInfo;
        }

        protected void doRun() {
            RepositorySynchronizer.this.localRepository.handleCommitInfo(this.commitInfo);
        }

        public int compareTo(PriorityQueueRunnable o) {
            int result = super.compareTo(o);
            if (result == 0) {
                Long timeStamp = this.commitInfo.getTimeStamp();
                Long timeStamp2 = ((CommitRunnable)o).commitInfo.getTimeStamp();
                result = timeStamp < timeStamp2 ? -1 : (timeStamp == timeStamp2 ? 0 : 1);
            }
            return result;
        }

        protected Integer getPriority() {
            return COMMIT_PRIORITY;
        }

        protected String getErrorMessage() {
            return "Replication of master commit failed:" + this.commitInfo;
        }
    }

    private final class ConnectRunnable
    extends PriorityQueueRunnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = RepositorySynchronizer.this.connectLock;
            synchronized (object) {
                RepositorySynchronizer.this.checkActive();
                if (TRACER.isEnabled()) {
                    TRACER.trace("Connecting to master...");
                }
                try {
                    CDOSessionConfiguration masterConfiguration = RepositorySynchronizer.this.remoteSessionConfigurationFactory.createSessionConfiguration();
                    masterConfiguration.setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode.ADDITIONS);
                    masterConfiguration.setLockNotificationMode(CDOCommonSession.Options.LockNotificationMode.ALWAYS);
                    RepositorySynchronizer.this.remoteSession = (InternalCDOSession)masterConfiguration.openSession();
                    this.ensureNOOPRevisionCache();
                }
                catch (Exception ex) {
                    RepositorySynchronizer.this.remoteSession = null;
                    if (RepositorySynchronizer.this.isActive()) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("Connection attempt failed. Retrying in {0} seconds...", new Object[]{RepositorySynchronizer.this.retryInterval});
                        }
                        RepositorySynchronizer.this.fireThrowable(ex);
                        RepositorySynchronizer.this.sleepRetryInterval();
                        RepositorySynchronizer.this.reconnect();
                    }
                    return;
                }
                if (TRACER.isEnabled()) {
                    TRACER.trace("Connected to master.");
                }
                RepositorySynchronizer.this.handleConnect();
            }
        }

        protected Integer getPriority() {
            return CONNECT_PRIORITY;
        }

        private void ensureNOOPRevisionCache() {
            InternalCDORevisionCache cache = RepositorySynchronizer.this.remoteSession.getRevisionManager().getCache();
            if (!(cache instanceof NOOPRevisionCache)) {
                String message = "Master session does not use a NOOPRevisionCache: " + cache.getClass().getName();
                OM.LOG.error(message);
                throw new Error(message);
            }
        }
    }

    private final class LocksRunnable
    extends RetryingRunnable {
        private CDOLockChangeInfo lockChangeInfo;

        public LocksRunnable(CDOLockChangeInfo lockChangeInfo) {
            this.lockChangeInfo = lockChangeInfo;
        }

        protected Integer getPriority() {
            return LOCKS_PRIORITY;
        }

        protected void doRun() {
            try {
                StoreThreadLocal.setSession(RepositorySynchronizer.this.localRepository.getReplicatorSession());
                if (this.lockChangeInfo instanceof CDOBranchAdjustable) {
                    ((CDOBranchAdjustable)this.lockChangeInfo).adjustBranches((CDOBranchManager)RepositorySynchronizer.this.localRepository.getBranchManager());
                }
                RepositorySynchronizer.this.localRepository.handleLockChangeInfo(this.lockChangeInfo);
            }
            finally {
                StoreThreadLocal.release();
            }
        }

        protected String getErrorMessage() {
            return "Replication of master lock changes failed:" + this.lockChangeInfo;
        }
    }

    private final class RemoteSessionListener
    implements IListener {
        private RemoteSessionListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyEvent(IEvent event) {
            if (!RepositorySynchronizer.this.isActive()) {
                return;
            }
            if (event instanceof CDOBranchChangedEvent) {
                CDOBranchChangedEvent e = (CDOBranchChangedEvent)event;
                if (e.getChangeKind() != CDOBranchChangedEvent.ChangeKind.CREATED) throw new UnsupportedOperationException("Branch renaming not supported: " + RepositorySynchronizer.this);
                RepositorySynchronizer.this.addWork((Object)new BranchRunnable(e.getBranch()));
                return;
            } else if (event instanceof CDOSessionInvalidationEvent) {
                CDOSessionInvalidationEvent e = (CDOSessionInvalidationEvent)event;
                if (!e.isRemote()) return;
                RepositorySynchronizer.this.addWork((Object)new CommitRunnable((CDOCommitInfo)e));
                return;
            } else if (event instanceof CDOSessionLocksChangedEvent) {
                CDOSessionLocksChangedEvent e = (CDOSessionLocksChangedEvent)event;
                RepositorySynchronizer.this.addWork((Object)new LocksRunnable((CDOLockChangeInfo)e));
                return;
            } else {
                ILifecycleEvent e;
                if (!(event instanceof ILifecycleEvent) || (e = (ILifecycleEvent)event).getKind() != ILifecycleEvent.Kind.DEACTIVATED || e.getSource() != RepositorySynchronizer.this.remoteSession) return;
                RepositorySynchronizer.this.handleDisconnect();
            }
        }
    }

    private final class ReplicateRunnable
    extends PriorityQueueRunnable {
        public void run() {
            block9: {
                try {
                    boolean firstSyncing;
                    RepositorySynchronizer.this.checkActive();
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Synchronizing with master...");
                    }
                    boolean bl = firstSyncing = !RepositorySynchronizer.this.localRepository.hasBeenReplicated();
                    if (!firstSyncing) {
                        RepositorySynchronizer.this.localRepository.setState(CDOCommonRepository.State.SYNCING);
                    }
                    CDOSessionProtocol sessionProtocol = RepositorySynchronizer.this.remoteSession.getSessionProtocol();
                    NotifyingMonitor monitor = new NotifyingMonitor("Synchronizing", RepositorySynchronizer.this.getListeners());
                    if (RepositorySynchronizer.this.isRawReplication()) {
                        sessionProtocol.replicateRepositoryRaw((CDORawReplicationContext)RepositorySynchronizer.this.localRepository, (OMMonitor)monitor);
                    } else {
                        sessionProtocol.replicateRepository((CDOReplicationContext)RepositorySynchronizer.this.localRepository, (OMMonitor)monitor);
                    }
                    if (firstSyncing) {
                        CDOID id = RepositorySynchronizer.this.remoteSession.getRepositoryInfo().getRootResourceID();
                        RepositorySynchronizer.this.localRepository.setRootResourceID(id);
                    }
                    RepositorySynchronizer.this.localRepository.setState(CDOCommonRepository.State.ONLINE);
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Synchronized with master.");
                    }
                }
                catch (RuntimeException ex) {
                    if (!RepositorySynchronizer.this.isActive()) break block9;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Replication attempt failed. Retrying in {0} seconds...", (Throwable)ex, new Object[]{RepositorySynchronizer.this.retryInterval});
                    }
                    RepositorySynchronizer.this.fireThrowable(ex);
                    RepositorySynchronizer.this.sleepRetryInterval();
                    RepositorySynchronizer.this.handleDisconnect();
                }
            }
        }

        protected Integer getPriority() {
            return REPLICATE_PRIORITY;
        }
    }

    private abstract class RetryingRunnable
    extends PriorityQueueRunnable {
        private List<Exception> failedRuns;

        public void run() {
            try {
                this.doRun();
            }
            catch (Exception ex) {
                RepositorySynchronizer.this.fireThrowable(ex);
                if (this.failedRuns == null) {
                    this.failedRuns = new ArrayList<Exception>();
                }
                this.failedRuns.add(ex);
                if (this.failedRuns.size() <= RepositorySynchronizer.this.maxRecommits) {
                    if (TRACER.isEnabled()) {
                        String simpleName = ((Object)((Object)this)).getClass().getSimpleName();
                        TRACER.format(String.valueOf(simpleName) + " failed. Trying again in {0} seconds...", new Object[]{RepositorySynchronizer.this.recommitInterval});
                    }
                    if (RepositorySynchronizer.this.recommitTimer == null) {
                        RepositorySynchronizer.this.recommitTimer = new Timer("RetryTimer-" + RepositorySynchronizer.this);
                    }
                    RepositorySynchronizer.this.recommitTimer.schedule(new TimerTask(){

                        public void run() {
                            try {
                                RepositorySynchronizer.this.addWork((Object)RetryingRunnable.this);
                            }
                            catch (Exception ex) {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("{0} failed. Exiting.", new Object[]{((Object)((Object)RetryingRunnable.this)).getClass().getSimpleName()});
                                }
                                RepositorySynchronizer.this.fireThrowable(ex);
                            }
                        }
                    }, (long)RepositorySynchronizer.this.recommitInterval * 1000L);
                }
                if (TRACER.isEnabled()) {
                    TRACER.trace((Throwable)ex);
                }
                RepositorySynchronizer.this.fireThrowable(ex);
            }
        }

        protected abstract void doRun();

        protected abstract String getErrorMessage();
    }
}

