/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.buddies.protocol;

import java.util.Set;
import org.eclipse.net4j.buddies.IBuddySession;
import org.eclipse.net4j.buddies.common.IAccount;
import org.eclipse.net4j.buddies.internal.common.protocol.ProtocolUtil;
import org.eclipse.net4j.internal.buddies.ClientSession;
import org.eclipse.net4j.internal.buddies.protocol.BuddiesClientProtocol;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSessionRequest
extends RequestWithConfirmation<IBuddySession> {
    private String userID;
    private String password;
    private Set<String> facilityTypes;

    public OpenSessionRequest(BuddiesClientProtocol protocol, String userID, String password, Set<String> facilityTypes) {
        super((SignalProtocol)protocol, (short)1);
        this.userID = userID;
        this.password = password;
        this.facilityTypes = facilityTypes;
    }

    protected void requesting(ExtendedDataOutputStream out) throws Exception {
        out.writeString(this.userID);
        out.writeString(this.password);
        out.writeInt(this.facilityTypes.size());
        for (String facilityType : this.facilityTypes) {
            out.writeString(facilityType);
        }
    }

    protected IBuddySession confirming(ExtendedDataInputStream in) throws Exception {
        IAccount account = ProtocolUtil.readAccount((ExtendedDataInputStream)in);
        if (account == null) {
            return null;
        }
        BuddiesClientProtocol protocol = (BuddiesClientProtocol)this.getProtocol();
        ClientSession session = new ClientSession(protocol);
        protocol.setInfraStructure(session);
        session.setSelf(account, this.facilityTypes);
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            session.buddyAdded(in.readString());
            ++i;
        }
        session.activate();
        return session;
    }
}

