/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.sql.ResultSet;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.config.impl.ConfigTest;
import org.eclipse.emf.cdo.tests.db.verifier.DBStoreVerifier;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.db.DBUtil;

@ConfigTest.Skips(value={"Postgresql"})
public class DBAnnotationsTest
extends AbstractCDOTest {
    private static int modelCounter;

    public void testLengthAnnotationPositive() throws Exception {
        DBAnnotationsTest.msg((Object)"Opening session");
        EPackage model1 = this.createModel();
        this.addLengthAnnotation(model1, "8");
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage(model1);
        DBAnnotationsTest.msg((Object)"Opening transaction");
        CDOTransaction transaction = session.openTransaction();
        DBAnnotationsTest.msg((Object)"Creating resource");
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        DBAnnotationsTest.msg((Object)"Commit a product that has a name with an allowed string length.");
        EClass eClass = (EClass)model1.getEClassifier("Product1");
        EObject product = model1.getEFactoryInstance().create(eClass);
        product.eSet(eClass.getEStructuralFeature("name"), (Object)"01234567");
        resource.getContents().add((Object)product);
        transaction.commit();
        transaction.close();
        session.close();
    }

    @ConfigTest.Skips(value={"Hsqldb"})
    public void testLengthAnnotationNegative() throws Exception {
        DBAnnotationsTest.msg((Object)"Opening session");
        EPackage model1 = this.createModel();
        this.addLengthAnnotation(model1, "8");
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage(model1);
        DBAnnotationsTest.msg((Object)"Opening transaction");
        CDOTransaction transaction = session.openTransaction();
        DBAnnotationsTest.msg((Object)"Creating resource");
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        DBAnnotationsTest.msg((Object)"Commit a product that has a name with an invalid string length.");
        EClass eClass = (EClass)model1.getEClassifier("Product1");
        EObject product = model1.getEFactoryInstance().create(eClass);
        product.eSet(eClass.getEStructuralFeature("name"), (Object)"012345678");
        resource.getContents().add((Object)product);
        try {
            try {
                transaction.commit();
                DBAnnotationsTest.fail((String)"Committing too long data did not result in an exception");
            }
            catch (Exception exception) {
                transaction.close();
                session.close();
            }
        }
        finally {
            transaction.close();
            session.close();
        }
    }

    public void testLengthAnnotationByMetaData() throws CommitException {
        DBAnnotationsTest.msg((Object)"Opening session");
        final EPackage model1 = this.createModel();
        this.addLengthAnnotation(model1, "8");
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage(model1);
        DBAnnotationsTest.msg((Object)"Opening transaction");
        CDOTransaction transaction = session.openTransaction();
        DBAnnotationsTest.msg((Object)"Creating resource");
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        DBAnnotationsTest.msg((Object)"Commit a product.");
        EClass eClass = (EClass)model1.getEClassifier("Product1");
        EObject product = model1.getEFactoryInstance().create(eClass);
        resource.getContents().add((Object)product);
        transaction.commit();
        transaction.close();
        session.close();
        DBAnnotationsTest.msg((Object)"Check if column size was correctly set.");
        new DBStoreVerifier((IRepository)this.getRepository()){

            protected void doVerify() throws Exception {
                String tableName = String.valueOf(model1.getName().toUpperCase()) + "_PRODUCT1";
                ResultSet rset = this.getMetaData().getColumns(null, null, tableName, "NAME");
                try {
                    rset.next();
                    DBAnnotationsTest.assertEquals((String)"8", (String)rset.getString(7));
                }
                finally {
                    DBUtil.close((ResultSet)rset);
                }
            }
        }.verify();
    }

    @ConfigTest.Skips(value={"Hsqldb"})
    public void testTypeAnnotationByMetaData() throws CommitException {
        DBAnnotationsTest.msg((Object)"Opening session");
        final EPackage model1 = this.createModel();
        this.addTypeAnnotation(model1, "CLOB");
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage(model1);
        DBAnnotationsTest.msg((Object)"Opening transaction");
        CDOTransaction transaction = session.openTransaction();
        DBAnnotationsTest.msg((Object)"Creating resource");
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        DBAnnotationsTest.msg((Object)"Commit a category.");
        EClass eClass = (EClass)model1.getEClassifier("Category");
        EObject category = model1.getEFactoryInstance().create(eClass);
        resource.getContents().add((Object)category);
        transaction.commit();
        transaction.close();
        session.close();
        DBAnnotationsTest.msg((Object)"Check if column type was correctly set.");
        new DBStoreVerifier((IRepository)this.getRepository()){

            protected void doVerify() throws Exception {
                String tableName = String.valueOf(model1.getName().toUpperCase()) + "_CATEGORY";
                ResultSet rset = this.getMetaData().getColumns(null, null, tableName, "NAME");
                try {
                    rset.next();
                    DBAnnotationsTest.assertEquals((String)"CLOB", (String)rset.getString(6));
                }
                finally {
                    DBUtil.close((ResultSet)rset);
                }
            }
        }.verify();
    }

    public void testTableNameAnnotationByMetaData() throws CommitException {
        DBAnnotationsTest.msg((Object)"Opening session");
        EPackage model1 = this.createModel();
        this.addTableNameAnnotation(model1, "Subject");
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage(model1);
        DBAnnotationsTest.msg((Object)"Opening transaction");
        CDOTransaction transaction = session.openTransaction();
        DBAnnotationsTest.msg((Object)"Creating resource");
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        DBAnnotationsTest.msg((Object)"Commit a category.");
        EClass eClass = (EClass)model1.getEClassifier("Category");
        EObject category = model1.getEFactoryInstance().create(eClass);
        resource.getContents().add((Object)category);
        transaction.commit();
        transaction.close();
        session.close();
        DBAnnotationsTest.msg((Object)"Check if table name was correctly set.");
        new DBStoreVerifier((IRepository)this.getRepository()){

            protected void doVerify() throws Exception {
                ResultSet rset = this.getMetaData().getTables(null, null, "SUBJECT", null);
                try {
                    rset.next();
                    DBAnnotationsTest.assertEquals((String)"SUBJECT", (String)rset.getString(3));
                }
                finally {
                    DBUtil.close((ResultSet)rset);
                }
            }
        }.verify();
    }

    public void testColumnNameAnnotationByMetaData() throws CommitException {
        DBAnnotationsTest.msg((Object)"Opening session");
        final EPackage model1 = this.createModel();
        this.addColumnNameAnnotation(model1, "TOPIC");
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage(model1);
        DBAnnotationsTest.msg((Object)"Opening transaction");
        CDOTransaction transaction = session.openTransaction();
        DBAnnotationsTest.msg((Object)"Creating resource");
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        DBAnnotationsTest.msg((Object)"Commit a category.");
        EClass eClass = (EClass)model1.getEClassifier("Category");
        EObject category = model1.getEFactoryInstance().create(eClass);
        resource.getContents().add((Object)category);
        transaction.commit();
        transaction.close();
        session.close();
        DBAnnotationsTest.msg((Object)"Check if table name was correctly set.");
        new DBStoreVerifier((IRepository)this.getRepository()){

            protected void doVerify() throws Exception {
                String tableName = String.valueOf(model1.getName().toUpperCase()) + "_CATEGORY";
                ResultSet rset = this.getMetaData().getColumns(null, null, tableName, "TOPIC");
                try {
                    rset.next();
                    DBAnnotationsTest.assertEquals((String)"TOPIC", (String)rset.getString(4));
                }
                finally {
                    DBUtil.close((ResultSet)rset);
                }
            }
        }.verify();
    }

    @ConfigTest.Skips(value={"Hsqldb"})
    public void testColumnNameTypeAnnotationByMetaData() throws CommitException {
        DBAnnotationsTest.msg((Object)"Opening session");
        final EPackage model1 = this.createModel();
        this.addColumnNameAndTypeAnnoation(model1, "TOPIC", "CLOB");
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage(model1);
        DBAnnotationsTest.msg((Object)"Opening transaction");
        CDOTransaction transaction = session.openTransaction();
        DBAnnotationsTest.msg((Object)"Creating resource");
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        DBAnnotationsTest.msg((Object)"Commit a category.");
        EClass eClass = (EClass)model1.getEClassifier("Category");
        EObject category = model1.getEFactoryInstance().create(eClass);
        resource.getContents().add((Object)category);
        transaction.commit();
        transaction.close();
        session.close();
        DBAnnotationsTest.msg((Object)"Check if table name was correctly set.");
        new DBStoreVerifier((IRepository)this.getRepository()){

            protected void doVerify() throws Exception {
                String tableName = String.valueOf(model1.getName().toUpperCase()) + "_CATEGORY";
                ResultSet rset = this.getMetaData().getColumns(null, null, tableName, "TOPIC");
                try {
                    rset.next();
                    DBAnnotationsTest.assertEquals((String)"TOPIC", (String)rset.getString(4));
                    DBAnnotationsTest.assertEquals((String)"CLOB", (String)rset.getString(6));
                }
                finally {
                    DBUtil.close((ResultSet)rset);
                }
            }
        }.verify();
    }

    public void testTableMappingAnnotationByMetaData() throws CommitException {
        DBAnnotationsTest.msg((Object)"Opening session");
        final EPackage model1 = this.createModel();
        this.addTableMappingAnnotation(model1, "OrderDetail", "Company");
        CDOSession session = this.openSession();
        session.getPackageRegistry().putEPackage(model1);
        DBAnnotationsTest.msg((Object)"Opening transaction");
        CDOTransaction transaction = session.openTransaction();
        DBAnnotationsTest.msg((Object)"Creating resource");
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        DBAnnotationsTest.msg((Object)"Commit a category.");
        EClass eClass = (EClass)model1.getEClassifier("Category");
        EObject category = model1.getEFactoryInstance().create(eClass);
        resource.getContents().add((Object)category);
        transaction.commit();
        transaction.close();
        session.close();
        DBAnnotationsTest.msg((Object)"Check if table name was correctly set.");
        new DBStoreVerifier((IRepository)this.getRepository()){

            protected void doVerify() throws Exception {
                ResultSet rset = this.getMetaData().getTables(null, null, null, null);
                try {
                    boolean orderDetailTableCreated = false;
                    boolean companyTableCreated = false;
                    boolean categoryTableCreated = false;
                    String prefix = String.valueOf(model1.getName().toUpperCase()) + '_';
                    while (rset.next()) {
                        String tableName = rset.getString(3);
                        if ((String.valueOf(prefix) + "ORDERDETAIL").equalsIgnoreCase(tableName)) {
                            orderDetailTableCreated = true;
                            continue;
                        }
                        if ((String.valueOf(prefix) + "COMPANY").equalsIgnoreCase(tableName)) {
                            companyTableCreated = true;
                            continue;
                        }
                        if (!(String.valueOf(prefix) + "CATEGORY").equalsIgnoreCase(tableName)) continue;
                        categoryTableCreated = true;
                    }
                    DBAnnotationsTest.assertEquals((boolean)false, (boolean)orderDetailTableCreated);
                    DBAnnotationsTest.assertEquals((boolean)false, (boolean)companyTableCreated);
                    DBAnnotationsTest.assertEquals((boolean)true, (boolean)categoryTableCreated);
                }
                finally {
                    DBUtil.close((ResultSet)rset);
                }
            }
        }.verify();
    }

    private EPackage createModel() {
        EPackage ePackage = (EPackage)EcoreUtil.copy((EObject)this.getModel1Package());
        String suffix = "_dynamic" + modelCounter++;
        ePackage.setNsURI(String.valueOf(ePackage.getNsURI()) + suffix);
        ePackage.setName(String.valueOf(ePackage.getName()) + suffix);
        return ePackage;
    }

    private void addLengthAnnotation(EPackage model1, String value) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource("http://www.eclipse.org/CDO/DBStore");
        annotation.getDetails().put((Object)"columnLength", (Object)value);
        EClass product1 = (EClass)model1.getEClassifier("Product1");
        EStructuralFeature element = product1.getEStructuralFeature(0);
        element.getEAnnotations().add((Object)annotation);
    }

    private void addTypeAnnotation(EPackage model1, String value) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource("http://www.eclipse.org/CDO/DBStore");
        annotation.getDetails().put((Object)"columnType", (Object)value);
        EClass category = (EClass)model1.getEClassifier("Category");
        EStructuralFeature element = category.getEStructuralFeature(0);
        element.getEAnnotations().add((Object)annotation);
    }

    private void addTableNameAnnotation(EPackage model1, String value) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource("http://www.eclipse.org/CDO/DBStore");
        annotation.getDetails().put((Object)"tableName", (Object)value);
        EClass category = (EClass)model1.getEClassifier("Category");
        category.getEAnnotations().add((Object)annotation);
    }

    private void addColumnNameAnnotation(EPackage model1, String value) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource("http://www.eclipse.org/CDO/DBStore");
        annotation.getDetails().put((Object)"columnName", (Object)value);
        EClass category = (EClass)model1.getEClassifier("Category");
        EStructuralFeature element = category.getEStructuralFeature(0);
        element.getEAnnotations().add((Object)annotation);
    }

    private void addColumnNameAndTypeAnnoation(EPackage model1, String name, String type) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource("http://www.eclipse.org/CDO/DBStore");
        annotation.getDetails().put((Object)"columnName", (Object)name);
        annotation.getDetails().put((Object)"columnType", (Object)type);
        EClass category = (EClass)model1.getEClassifier("Category");
        EStructuralFeature element = category.getEStructuralFeature(0);
        element.getEAnnotations().add((Object)annotation);
    }

    private void addTableMappingAnnotation(EPackage model1, String ... unmappedTables) {
        String[] stringArray = unmappedTables;
        int n = unmappedTables.length;
        int n2 = 0;
        while (n2 < n) {
            String unmappedTable = stringArray[n2];
            EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("http://www.eclipse.org/CDO/DBStore");
            annotation.getDetails().put((Object)"tableMapping", (Object)"NONE");
            annotation.getDetails().put((Object)"typeMapping", (Object)"org.eclipse.emf.cdo.tests.db.EIntToVarchar");
            EClass orderDetail = (EClass)model1.getEClassifier(unmappedTable);
            orderDetail.getEAnnotations().add((Object)annotation);
            ++n2;
        }
    }
}

