/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class RWLockManager<OBJECT, CONTEXT>
extends Lifecycle
implements IRWLockManager<OBJECT, CONTEXT> {
    private LockStrategy<OBJECT, CONTEXT> readLockStrategy = new LockStrategy<OBJECT, CONTEXT>(){

        @Override
        public boolean isLocked(LockEntry<OBJECT, CONTEXT> entry, CONTEXT context) {
            return entry.isReadLock(context);
        }

        @Override
        public boolean isLockedByOthers(LockEntry<OBJECT, CONTEXT> entry, CONTEXT context) {
            return entry.isReadLockByOthers(context);
        }

        @Override
        public boolean canObtainLock(LockEntry<OBJECT, CONTEXT> entry, CONTEXT context) {
            return entry.canObtainReadLock(context);
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> lock(LockEntry<OBJECT, CONTEXT> entry, CONTEXT context) {
            return entry.readLock(context);
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> unlock(LockEntry<OBJECT, CONTEXT> entry, CONTEXT context) {
            return entry.readUnlock(context);
        }

        public String toString() {
            return "ReadLockStrategy";
        }
    };
    private LockStrategy<OBJECT, CONTEXT> writeLockStrategy = new LockStrategy<OBJECT, CONTEXT>(){

        @Override
        public boolean isLocked(LockEntry<OBJECT, CONTEXT> entry, CONTEXT context) {
            return entry.isWriteLock(context);
        }

        @Override
        public boolean isLockedByOthers(LockEntry<OBJECT, CONTEXT> entry, CONTEXT context) {
            return entry.isWriteLockByOthers(context);
        }

        @Override
        public boolean canObtainLock(LockEntry<OBJECT, CONTEXT> entry, CONTEXT context) {
            return entry.canObtainWriteLock(context);
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> lock(LockEntry<OBJECT, CONTEXT> entry, CONTEXT context) {
            return entry.writeLock(context);
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> unlock(LockEntry<OBJECT, CONTEXT> entry, CONTEXT context) {
            return entry.writeUnlock(context);
        }

        public String toString() {
            return "WriteLockStrategy";
        }
    };
    private Map<OBJECT, LockEntry<OBJECT, CONTEXT>> lockEntries = new HashMap<OBJECT, LockEntry<OBJECT, CONTEXT>>();
    private LockChanged lockChanged = new LockChanged();

    @Override
    public void lock(IRWLockManager.LockType type, CONTEXT context, Collection<? extends OBJECT> objectsToLock, long timeout) throws InterruptedException {
        LockStrategy<OBJECT, CONTEXT> lockingStrategy = this.getLockingStrategy(type);
        this.lock(lockingStrategy, context, objectsToLock, timeout);
    }

    @Override
    public void lock(IRWLockManager.LockType type, CONTEXT context, OBJECT objectToLock, long timeout) throws InterruptedException {
        List<OBJECT> objectsToLock = Collections.singletonList(objectToLock);
        this.lock(type, context, (OBJECT)objectsToLock, timeout);
    }

    @Override
    public void unlock(IRWLockManager.LockType type, CONTEXT context, Collection<? extends OBJECT> objectsToUnlock) {
        LockStrategy<OBJECT, CONTEXT> lockingStrategy = this.getLockingStrategy(type);
        this.unlock(lockingStrategy, context, objectsToUnlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(CONTEXT context) {
        LockChanged lockChanged = this.lockChanged;
        synchronized (lockChanged) {
            Object object;
            ArrayList<LockEntry<OBJECT, CONTEXT>> lockEntrysToRemove = new ArrayList<LockEntry<OBJECT, CONTEXT>>();
            ArrayList<LockEntry<OBJECT, CONTEXT>> lockEntrysToAdd = new ArrayList<LockEntry<OBJECT, CONTEXT>>();
            for (Map.Entry<OBJECT, LockEntry<OBJECT, CONTEXT>> entry : this.lockEntries.entrySet()) {
                LockEntry<OBJECT, CONTEXT> lockedContext = entry.getValue();
                LockEntry<OBJECT, CONTEXT> newEntry = lockedContext.clearLock(context);
                if (newEntry == null) {
                    lockEntrysToRemove.add(lockedContext);
                    continue;
                }
                if (newEntry == entry) continue;
                lockEntrysToAdd.add(newEntry);
            }
            for (LockEntry lockEntry : lockEntrysToRemove) {
                object = lockEntry.getObject();
                this.lockEntries.remove(object);
            }
            for (LockEntry lockEntry : lockEntrysToAdd) {
                object = lockEntry.getObject();
                this.lockEntries.put(object, lockEntry);
            }
            this.lockChanged.notifyAll();
        }
    }

    @Override
    public boolean hasLock(IRWLockManager.LockType type, CONTEXT context, OBJECT objectToLock) {
        LockStrategy<OBJECT, CONTEXT> lockingStrategy = this.getLockingStrategy(type);
        return this.hasLock(lockingStrategy, context, objectToLock);
    }

    @Override
    public boolean hasLockByOthers(IRWLockManager.LockType type, CONTEXT context, OBJECT objectToLock) {
        LockStrategy<OBJECT, CONTEXT> lockingStrategy = this.getLockingStrategy(type);
        LockEntry<OBJECT, CONTEXT> entry = this.getLockEntry(objectToLock);
        return entry != null && lockingStrategy.isLockedByOthers(entry, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLockEntries(CONTEXT context, LockEntryHandler<OBJECT, CONTEXT> handler) {
        LockChanged lockChanged = this.lockChanged;
        synchronized (lockChanged) {
            for (LockEntry<OBJECT, CONTEXT> lockEntry : this.lockEntries.values()) {
                if ((context == null || lockEntry.hasContext(context)) && !handler.handleLockEntry(lockEntry)) break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LockEntry<OBJECT, CONTEXT> getLockEntry(OBJECT objectToLock) {
        LockChanged lockChanged = this.lockChanged;
        synchronized (lockChanged) {
            return this.lockEntries.get(objectToLock);
        }
    }

    protected LockStrategy<OBJECT, CONTEXT> getLockingStrategy(IRWLockManager.LockType type) {
        if (type == IRWLockManager.LockType.READ) {
            return this.readLockStrategy;
        }
        if (type == IRWLockManager.LockType.WRITE) {
            return this.writeLockStrategy;
        }
        throw new IllegalArgumentException("Invalid lock type: " + (Object)((Object)type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeContext(CONTEXT oldContext, CONTEXT newContext) {
        LockChanged lockChanged = this.lockChanged;
        synchronized (lockChanged) {
            for (LockEntry<OBJECT, CONTEXT> lockEntry : this.lockEntries.values()) {
                lockEntry.changeContext(oldContext, newContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(LockStrategy<OBJECT, CONTEXT> lockingStrategy, CONTEXT context, Collection<? extends OBJECT> objectsToLock) {
        LockChanged lockChanged = this.lockChanged;
        synchronized (lockChanged) {
            Object object;
            ArrayList<LockEntry<OBJECT, CONTEXT>> lockEntrysToRemove = new ArrayList<LockEntry<OBJECT, CONTEXT>>();
            ArrayList<LockEntry<OBJECT, CONTEXT>> lockEntrysToAdd = new ArrayList<LockEntry<OBJECT, CONTEXT>>();
            for (OBJECT OBJECT : objectsToLock) {
                LockEntry<OBJECT, CONTEXT> entry = this.lockEntries.get(OBJECT);
                if (entry == null) {
                    throw new IllegalMonitorStateException();
                }
                LockEntry<OBJECT, CONTEXT> newEntry = lockingStrategy.unlock(entry, context);
                if (newEntry == null) {
                    lockEntrysToRemove.add(entry);
                    continue;
                }
                if (newEntry == entry) continue;
                lockEntrysToAdd.add(newEntry);
            }
            for (LockEntry lockEntry : lockEntrysToRemove) {
                object = lockEntry.getObject();
                this.lockEntries.remove(object);
            }
            for (LockEntry lockEntry : lockEntrysToAdd) {
                object = lockEntry.getObject();
                this.lockEntries.put(object, lockEntry);
            }
            this.lockChanged.notifyAll();
        }
    }

    private boolean hasLock(LockStrategy<OBJECT, CONTEXT> lockingStrategy, CONTEXT context, OBJECT objectToLock) {
        LockEntry<OBJECT, CONTEXT> entry = this.getLockEntry(objectToLock);
        return entry != null && lockingStrategy.isLocked(entry, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(LockStrategy<OBJECT, CONTEXT> lockStrategy, CONTEXT context, Collection<? extends OBJECT> objectsToLocks, long timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (true) {
            LockChanged lockChanged = this.lockChanged;
            synchronized (lockChanged) {
                OBJECT conflict = this.obtainLock(lockStrategy, context, objectsToLocks);
                if (conflict == null) {
                    this.lockChanged.notifyAll();
                    return;
                }
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (timeout != 0L && elapsedTime > timeout) {
                    throw new TimeoutRuntimeException("Could not lock " + conflict + " within " + timeout + " milli seconds");
                }
                if (timeout == 0L) {
                    this.lockChanged.wait();
                } else {
                    this.lockChanged.wait(Math.max(1L, timeout - elapsedTime));
                }
            }
        }
    }

    private OBJECT obtainLock(LockStrategy<OBJECT, CONTEXT> lockingStrategy, CONTEXT context, Collection<? extends OBJECT> objectsToLock) {
        ArrayList<LockEntry<OBJECT, CONTEXT>> lockEntrys = new ArrayList<LockEntry<OBJECT, CONTEXT>>();
        for (OBJECT OBJECT : objectsToLock) {
            LockEntry<OBJECT, CONTEXT> entry = this.lockEntries.get(OBJECT);
            if (entry == null) {
                entry = new NoLockEntry(OBJECT);
            }
            if (lockingStrategy.canObtainLock(entry, context)) {
                lockEntrys.add(entry);
                continue;
            }
            return OBJECT;
        }
        for (LockEntry lockEntry : lockEntrys) {
            Object object = lockEntry.getObject();
            LockEntry<OBJECT, CONTEXT> lock = lockingStrategy.lock(lockEntry, context);
            this.lockEntries.put(object, lock);
        }
        return null;
    }

    private static final class LockChanged {
        private LockChanged() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    protected static interface LockEntry<OBJECT, CONTEXT> {
        public OBJECT getObject();

        public boolean isReadLock(CONTEXT var1);

        public boolean isWriteLock(CONTEXT var1);

        public boolean isReadLockByOthers(CONTEXT var1);

        public boolean isWriteLockByOthers(CONTEXT var1);

        public boolean canObtainReadLock(CONTEXT var1);

        public boolean canObtainWriteLock(CONTEXT var1);

        public LockEntry<OBJECT, CONTEXT> readLock(CONTEXT var1);

        public LockEntry<OBJECT, CONTEXT> writeLock(CONTEXT var1);

        public LockEntry<OBJECT, CONTEXT> readUnlock(CONTEXT var1);

        public LockEntry<OBJECT, CONTEXT> writeUnlock(CONTEXT var1);

        public LockEntry<OBJECT, CONTEXT> clearLock(CONTEXT var1);

        public void changeContext(CONTEXT var1, CONTEXT var2);

        public boolean hasContext(CONTEXT var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    protected static interface LockEntryHandler<OBJECT, CONTEXT> {
        public boolean handleLockEntry(LockEntry<OBJECT, CONTEXT> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    protected static interface LockStrategy<OBJECT, CONTEXT> {
        public boolean isLocked(LockEntry<OBJECT, CONTEXT> var1, CONTEXT var2);

        public boolean isLockedByOthers(LockEntry<OBJECT, CONTEXT> var1, CONTEXT var2);

        public boolean canObtainLock(LockEntry<OBJECT, CONTEXT> var1, CONTEXT var2);

        public LockEntry<OBJECT, CONTEXT> lock(LockEntry<OBJECT, CONTEXT> var1, CONTEXT var2);

        public LockEntry<OBJECT, CONTEXT> unlock(LockEntry<OBJECT, CONTEXT> var1, CONTEXT var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NoLockEntry<OBJECT, CONTEXT>
    implements LockEntry<OBJECT, CONTEXT> {
        private OBJECT object;

        public NoLockEntry(OBJECT objectToLock) {
            this.object = objectToLock;
        }

        @Override
        public OBJECT getObject() {
            return this.object;
        }

        @Override
        public boolean isReadLock(CONTEXT context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWriteLock(CONTEXT context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isReadLockByOthers(CONTEXT context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWriteLockByOthers(CONTEXT context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canObtainWriteLock(CONTEXT context) {
            return true;
        }

        @Override
        public boolean canObtainReadLock(CONTEXT context) {
            return true;
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> readLock(CONTEXT context) {
            return new ReadLockEntry<OBJECT, CONTEXT>(this.object, context);
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> writeLock(CONTEXT context) {
            return new WriteLockEntry<OBJECT, CONTEXT>(this.object, context, null);
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> readUnlock(CONTEXT context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> writeUnlock(CONTEXT context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> clearLock(CONTEXT context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void changeContext(CONTEXT oldContext, CONTEXT newContext) {
        }

        @Override
        public boolean hasContext(CONTEXT context) {
            return false;
        }

        public String toString() {
            return MessageFormat.format("NoLockEntry[object={0}]", this.object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReadLockEntry<OBJECT, CONTEXT>
    implements LockEntry<OBJECT, CONTEXT> {
        private OBJECT object;
        private Set<CONTEXT> contexts = new HashBag<CONTEXT>();

        public ReadLockEntry(OBJECT objectToLock, CONTEXT context) {
            this.object = objectToLock;
            this.contexts.add(context);
        }

        @Override
        public OBJECT getObject() {
            return this.object;
        }

        @Override
        public boolean isReadLock(CONTEXT context) {
            return this.contexts.contains(context);
        }

        @Override
        public boolean isWriteLock(CONTEXT context) {
            return false;
        }

        @Override
        public boolean isReadLockByOthers(CONTEXT context) {
            if (this.contexts.isEmpty()) {
                return false;
            }
            return this.contexts.size() > (this.isReadLock(context) ? 1 : 0);
        }

        @Override
        public boolean isWriteLockByOthers(CONTEXT context) {
            return false;
        }

        @Override
        public boolean canObtainReadLock(CONTEXT context) {
            return true;
        }

        @Override
        public boolean canObtainWriteLock(CONTEXT context) {
            return this.contexts.size() == 1 && this.contexts.contains(context);
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> readLock(CONTEXT context) {
            this.contexts.add(context);
            return this;
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> writeLock(CONTEXT context) {
            return new WriteLockEntry<OBJECT, CONTEXT>(this.object, context, this);
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> readUnlock(CONTEXT context) {
            this.contexts.remove(context);
            return this.contexts.isEmpty() ? null : this;
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> writeUnlock(CONTEXT context) {
            throw new IllegalMonitorStateException();
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> clearLock(CONTEXT context) {
            while (this.contexts.remove(context)) {
            }
            return this.contexts.isEmpty() ? null : this;
        }

        @Override
        public void changeContext(CONTEXT oldContext, CONTEXT newContext) {
            if (this.contexts.remove(oldContext)) {
                this.contexts.add(newContext);
            }
        }

        @Override
        public boolean hasContext(CONTEXT context) {
            return this.contexts.contains(context);
        }

        public String toString() {
            return MessageFormat.format("ReadLockEntry[object={0}, contexts={1}]", this.object, this.contexts);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WriteLockEntry<OBJECT, CONTEXT>
    implements LockEntry<OBJECT, CONTEXT> {
        private OBJECT object;
        private CONTEXT context;
        private int count;
        private ReadLockEntry<OBJECT, CONTEXT> readLock;

        public WriteLockEntry(OBJECT object, CONTEXT context, ReadLockEntry<OBJECT, CONTEXT> readLock) {
            this.object = object;
            this.context = context;
            this.readLock = readLock;
            this.count = 1;
        }

        @Override
        public OBJECT getObject() {
            return this.object;
        }

        @Override
        public boolean isReadLock(CONTEXT context) {
            return this.readLock != null ? this.readLock.isReadLock(context) : false;
        }

        @Override
        public boolean isWriteLock(CONTEXT context) {
            return ObjectUtil.equals(this.context, context);
        }

        @Override
        public boolean isReadLockByOthers(CONTEXT context) {
            return this.readLock != null ? this.readLock.isReadLockByOthers(context) : false;
        }

        @Override
        public boolean isWriteLockByOthers(CONTEXT context) {
            return context != this.context;
        }

        @Override
        public boolean canObtainWriteLock(CONTEXT context) {
            return ObjectUtil.equals(this.context, context);
        }

        @Override
        public boolean canObtainReadLock(CONTEXT context) {
            return ObjectUtil.equals(this.context, context);
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> readLock(CONTEXT context) {
            ReadLockEntry<OBJECT, CONTEXT> lock = this.getReadLock();
            lock.readLock(context);
            return this;
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> writeLock(CONTEXT context) {
            ++this.count;
            return this;
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> readUnlock(CONTEXT context) {
            if (this.readLock != null) {
                if (this.readLock.readUnlock(context) == null) {
                    this.readLock = null;
                }
                return this;
            }
            throw new IllegalMonitorStateException();
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> writeUnlock(CONTEXT context) {
            return --this.count <= 0 ? this.readLock : this;
        }

        @Override
        public LockEntry<OBJECT, CONTEXT> clearLock(CONTEXT context) {
            if (this.readLock != null && this.readLock.clearLock(context) == null) {
                this.readLock = null;
            }
            return ObjectUtil.equals(this.context, context) ? this.readLock : this;
        }

        @Override
        public void changeContext(CONTEXT oldContext, CONTEXT newContext) {
            if (ObjectUtil.equals(this.context, oldContext)) {
                this.context = newContext;
            }
        }

        @Override
        public boolean hasContext(CONTEXT context) {
            return ObjectUtil.equals(this.context, context);
        }

        public String toString() {
            return MessageFormat.format("WriteLockEntry[object={0}, context={1}, count={2}]", this.object, this.context, this.count);
        }

        private ReadLockEntry<OBJECT, CONTEXT> getReadLock() {
            if (this.readLock == null) {
                this.readLock = new ReadLockEntry<OBJECT, CONTEXT>(this.object, this.context);
            }
            return this.readLock;
        }
    }
}

