/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.properties;

import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public abstract class Property<RECEIVER> {
    private final String name;
    private final String label;
    private final String description;
    private final String category;

    public Property(String name, String label, String description, String category) {
        this.name = name;
        this.label = label;
        this.description = description;
        this.category = category;
    }

    public Property(String name, String label, String description) {
        this(name, label, description, null);
    }

    public Property(String name) {
        this(name, null, null);
    }

    public final String getName() {
        return this.name;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getCategory() {
        return this.category;
    }

    public final Object getValue(RECEIVER receiver) {
        block3: {
            try {
                Object value = this.eval(receiver);
                return this.convertValue(value);
            }
            catch (LifecycleException value) {
            }
            catch (Throwable ex) {
                if (!LifecycleUtil.isActive(receiver)) break block3;
                OM.LOG.error(ex);
            }
        }
        return null;
    }

    public boolean testValue(RECEIVER receiver, Object[] args, Object expectedValue) {
        Object value = this.getValue(receiver);
        return this.testValue(value, expectedValue);
    }

    boolean testValue(Object value, Object expectedValue) {
        if (value instanceof Boolean && expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return ObjectUtil.equals(value, expectedValue);
    }

    Object convertValue(Object value) {
        block12: {
            try {
                if (value != null) break block12;
                return null;
            }
            catch (Throwable ex) {
                OM.LOG.error(ex);
                return null;
            }
        }
        Class<?> c = value.getClass();
        if (c == Boolean.class) {
            return value;
        }
        if (c == Boolean.class) {
            return value;
        }
        if (c == Character.class) {
            return value;
        }
        if (c == Byte.class) {
            return value;
        }
        if (c == Short.class) {
            return value;
        }
        if (c == Integer.class) {
            return value;
        }
        if (c == Long.class) {
            return value;
        }
        if (c == Float.class) {
            return value;
        }
        if (c == Double.class) {
            return value;
        }
        return value.toString();
    }

    protected abstract Object eval(RECEIVER var1);

    public static abstract class WithArguments<RECEIVER>
    extends Property<RECEIVER> {
        public WithArguments(String name, String label, String description, String category) {
            super(name, label, description, category);
        }

        public WithArguments(String name, String label, String description) {
            super(name, label, description);
        }

        public WithArguments(String name) {
            super(name);
        }

        @Override
        public boolean testValue(RECEIVER receiver, Object[] args, Object expectedValue) {
            block3: {
                try {
                    Object value = this.eval(receiver, args);
                    value = this.convertValue(value);
                    return this.testValue(value, expectedValue);
                }
                catch (LifecycleException value) {
                }
                catch (Throwable ex) {
                    if (!LifecycleUtil.isActive(receiver)) break block3;
                    OM.LOG.error(ex);
                }
            }
            return false;
        }

        @Override
        protected final Object eval(RECEIVER receiver) {
            return this.eval(receiver, null);
        }

        protected abstract Object eval(RECEIVER var1, Object[] var2);
    }
}

