/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ReviewStatus implements Enumerator
{
    NEW(0, "New", "New"),
    SOURCE_OUTDATED(1, "SourceOutdated", "SourceOutdated"),
    TARGET_OUTDATED(2, "TargetOutdated", "TargetOutdated"),
    OUTDATED(3, "Outdated", "Outdated"),
    SUBMITTED(4, "Submitted", "Submitted"),
    ABANDONED(5, "Abandoned", "Abandoned"),
    RESTORING(6, "Restoring", "Restoring"),
    DELETED(7, "Deleted", "Deleted");

    public static final int NEW_VALUE = 0;
    public static final int SOURCE_OUTDATED_VALUE = 1;
    public static final int TARGET_OUTDATED_VALUE = 2;
    public static final int OUTDATED_VALUE = 3;
    public static final int SUBMITTED_VALUE = 4;
    public static final int ABANDONED_VALUE = 5;
    public static final int RESTORING_VALUE = 6;
    public static final int DELETED_VALUE = 7;
    private static final ReviewStatus[] VALUES_ARRAY;
    public static final List<ReviewStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ReviewStatus[]{NEW, SOURCE_OUTDATED, TARGET_OUTDATED, OUTDATED, SUBMITTED, ABANDONED, RESTORING, DELETED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ReviewStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReviewStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReviewStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReviewStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReviewStatus get(int value) {
        switch (value) {
            case 0: {
                return NEW;
            }
            case 1: {
                return SOURCE_OUTDATED;
            }
            case 2: {
                return TARGET_OUTDATED;
            }
            case 3: {
                return OUTDATED;
            }
            case 4: {
                return SUBMITTED;
            }
            case 5: {
                return ABANDONED;
            }
            case 6: {
                return RESTORING;
            }
            case 7: {
                return DELETED;
            }
        }
        return null;
    }

    public static ReviewStatus getOutdated(boolean sourceOutdated, boolean targetOutdated) {
        if (sourceOutdated) {
            if (targetOutdated) {
                return OUTDATED;
            }
            return SOURCE_OUTDATED;
        }
        if (targetOutdated) {
            return TARGET_OUTDATED;
        }
        return NEW;
    }

    private ReviewStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public boolean isOpen() {
        return this.value < 4;
    }

    public boolean isClosed() {
        return !this.isOpen();
    }
}

