/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.internal.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.ui.views.IntrospectionProvider;

public final class IterableIntrospectionProvider
extends IntrospectionProvider {
    public IterableIntrospectionProvider() {
        super("java.lang.Iterable", "Iterable");
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof Iterable;
    }

    @Override
    public void createColumns(TableViewer viewer) {
        IterableIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_13"), 50);
        IterableIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_11"), 400);
        IterableIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_12"), 300);
    }

    @Override
    public Object[] getElements(Object parent) throws Exception {
        Iterable iterable = (Iterable)parent;
        ArrayList<IntrospectionProvider.NameAndValue> result = new ArrayList<IntrospectionProvider.NameAndValue>();
        int index = 0;
        for (Object object : iterable) {
            result.add(new IntrospectionProvider.NameAndValue(index++, object));
        }
        return result.toArray();
    }

    @Override
    public Object getElementByName(Object parent, String name) throws Exception {
        int index;
        Iterable iterable = (Iterable)parent;
        Iterator iterator = iterable.iterator();
        Object value = null;
        try {
            index = Integer.parseInt(name);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        int i = 0;
        while (i < index) {
            if (!iterator.hasNext()) {
                return null;
            }
            value = iterator.next();
            ++i;
        }
        return new IntrospectionProvider.NameAndValue(index, value);
    }

    @Override
    public IntrospectionProvider.NameAndValue getNameAndValue(Object element) throws Exception {
        return (IntrospectionProvider.NameAndValue)element;
    }

    @Override
    public String getColumnText(Object element, int index) throws Exception {
        IntrospectionProvider.NameAndValue nameAndValue = (IntrospectionProvider.NameAndValue)element;
        switch (index) {
            case 0: {
                return nameAndValue.getName();
            }
            case 1: {
                return IterableIntrospectionProvider.formatValue(nameAndValue.getValue());
            }
            case 2: {
                return IterableIntrospectionProvider.getClassName(nameAndValue.getValue());
            }
        }
        return null;
    }
}

