/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.lock;

import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.ref.Interner;

public final class DurableCDOLockOwner
implements CDOLockOwner {
    private static final DurableInterner INTERNER = new DurableInterner();
    private static final boolean SHOW_DURABLE_LOCKING_ID = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.internal.common.lock.DurableCDOLockOwner.SHOW_DURABLE_LOCKING_ID");
    private final int sessionID;
    private final int viewID;
    private final String durableLockingID;

    private DurableCDOLockOwner(int sessionID, int viewID, String durableLockingID) {
        this.sessionID = sessionID;
        this.viewID = viewID;
        this.durableLockingID = durableLockingID;
    }

    @Override
    public int getSessionID() {
        return this.sessionID;
    }

    @Override
    public int getViewID() {
        return this.viewID;
    }

    @Override
    public String getDurableLockingID() {
        return this.durableLockingID;
    }

    @Override
    public boolean isDurableView() {
        return true;
    }

    public int hashCode() {
        return DurableCDOLockOwner.getHashCode(this.sessionID, this.viewID, this.durableLockingID);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CDOLockOwner[");
        builder.append(this.sessionID);
        builder.append(':');
        builder.append(this.viewID);
        builder.append(':');
        builder.append(SHOW_DURABLE_LOCKING_ID ? this.durableLockingID : "durable");
        builder.append(']');
        return builder.toString();
    }

    public static DurableCDOLockOwner create(int sessionID, int viewID, String durableLockingID) {
        return INTERNER.intern(sessionID, viewID, durableLockingID.intern());
    }

    private static int getHashCode(int sessionID, int viewID, String durableLockingID) {
        return 31 * (31 * (31 + sessionID) + viewID + durableLockingID.hashCode());
    }

    /* synthetic */ DurableCDOLockOwner(int n, int n2, String string, DurableCDOLockOwner durableCDOLockOwner) {
        this(n, n2, string);
    }

    private static final class DurableInterner
    extends Interner<DurableCDOLockOwner> {
        private DurableInterner() {
        }

        public synchronized DurableCDOLockOwner intern(int sessionID, int viewID, String durableLockingID) {
            int hashCode = DurableCDOLockOwner.getHashCode(sessionID, viewID, durableLockingID);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                DurableCDOLockOwner lockOwner = (DurableCDOLockOwner)entry.get();
                if (lockOwner != null && lockOwner.sessionID == sessionID && lockOwner.viewID == viewID && lockOwner.durableLockingID == durableLockingID) {
                    return lockOwner;
                }
                entry = entry.getNextEntry();
            }
            DurableCDOLockOwner id = new DurableCDOLockOwner(sessionID, viewID, durableLockingID, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(DurableCDOLockOwner lockOwner) {
            return DurableCDOLockOwner.getHashCode(lockOwner.sessionID, lockOwner.viewID, lockOwner.durableLockingID);
        }
    }
}

