/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerWriteIndication;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.net4j.util.ObjectUtil;

public class RenameBranchIndication
extends CDOServerWriteIndication {
    private int branchID;
    private String oldName;
    private String newName;

    public RenameBranchIndication(CDOServerProtocol protocol) {
        super(protocol, (short)58);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.branchID = in.readXInt();
        this.oldName = in.readString();
        this.newName = in.readString();
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        InternalCDOBranch branch = branchManager.getBranch(this.branchID);
        if (!ObjectUtil.equals((Object)branch.getName(), (Object)this.oldName)) {
            throw new IllegalStateException("Branch name has been changed by someone else in the meantime");
        }
        branch.setName(this.newName);
        InternalSession session = this.getSession();
        InternalSessionManager sessionManager = this.getRepository().getSessionManager();
        sessionManager.sendBranchNotification(session, CDOBranchChangedEvent.ChangeKind.RENAMED, new CDOBranch[]{branch});
        out.writeBoolean(true);
    }
}

